<?php
use yii\helpers\Html;
use yii\helpers\Url;
use backend\widgets\FormattedTitle;
use backend\components\helpers\Frequencies;
use backend\components\helpers\Formatter;
?>

<div id="body" class="container-fluid no-nav" data-js-callback="bodyLoaded" data-select-menu="li#dashboard-nav" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>">


    <div class="row">
        <div class="col-lg-12">
            <div class="col-head welcome">
                <h3>Welcome!</h3>
            </div>

            <p class="text-center">Please watch the following video to find out more about Grandma's Jars and the First Time Setup!</p>

        </div>
    </div>

    <div class="row">
        <div class="col-sm-8 col-sm-offset-2">
            <div class="yt-video-container">
                <iframe src="https://www.youtube.com/embed/pielC9KD_xk" frameborder="0" allowfullscreen class="yt-video"></iframe>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-4 col-sm-offset-4">
            <a href="<?= Url::toRoute(['/first-time-setup/step-1']) ?>" class="btn btn-primary btn-lg btn-block">
                Begin First Time Setup
                <i class="glyphicon glyphicon-triangle-right pull-right"></i>
            </a>
        </div>
    </div>

    <?= $this->render('/layouts/_footer') ?>

</div>


