<?php
use yii\helpers\Url;
use backend\components\helpers\Formatter;
?>

<table id="it-table-1" class="table table-paginated table-bordered data-table" data-table-id="it-table-1" data-ajax="<?= Url::toRoute(['/income-transactions/account-income-transactions-table', 'account_id' => $account->id]); ?>">
    <thead>
        <tr>
            <?php /*<th class="no-sort checked">Checked</th>*/ ?>
            <th class="sort-by sort-desc">Date</th>
            <th>Income</th>
            <th>Description</th>
            <th>Amount</th>
            <?php if ($allowEdit) { ?>
            <th class="no-sort"></th>
            <?php } ?>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td colspan="<?= ($allowEdit) ? 5 : 4; ?>" class="dataTables_empty">No income transactions yet.</td>
        </tr>
    </tbody>
    <tfoot>
        <tr>
            <td colspan="<?= ($allowEdit) ? 4 : 3; ?>">Total Transactions</td>
            <td class="this-months-income-transactions-amount"><?= Formatter::currency($account->getMonthsIncomeTransactionsAmount(date('m'), date('Y'), true, false)) ?></td>
        </tr>
    </tfoot>
</table>
