<?php
use yii\helpers\Url;
use backend\components\helpers\Formatter;
use backend\components\helpers\Frequencies;
?>

<ul class="nav nav-tabs detail-tab-nav incomes" role="tablist">
    <?php foreach ($incomes as $i) {
    $active = (isset($income) && ($i->id == $income->id)) ? ' class="active"' : '';
    ?>
    <li role="presentation"<?= $active ?> data-income-id="<?= $i->id ?>">
        <a href="<?= Url::toRoute(['/incomes/income-detail', 'id' => $i->id]) ?>">
            <?= $i->name ?>
            <span class="clearfix val">
                <span class="pull-left"><?= Formatter::currency($i->amount) ?></span>
                <span class="pull-right"><?= Frequencies::getLabel($i->frequency) ?></span>
            </span>
        </a>
    </li>
    <?php } ?>
</ul>
