<?php
use backend\components\ActiveForm;
use backend\components\helpers\JsTools;
use backend\components\helpers\Formatter;
use yii\helpers\Html;
use yii\helpers\Url;
?>

<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <?php if ($formModel->scenario == 'update') { ?>
    <h4 class="modal-title" id="myModalLabel"><?= Html::encode($this->title) ?></h4>
    <?php } else { ?>
    <div class='modal-tabs'>
        <div class='modal-tab open-modal' data-modal-url='/transactions/add-es-transaction'>Spent Money</div>
        <div class='modal-tab active'>Received Money</div>
        <div class='modal-tab open-modal' data-modal-url='/transfers/add-onetime-transfer'>Transfered Money</div>
    </div>
    <?php } ?>
</div>
<?php $form = ActiveForm::begin(['id' => 'add-onetime-income-form']); ?>
<div class="modal-body">
    <div class="message"></div>

    <?= $form->field($formModel, 'date')->widget(\dosamigos\datetimepicker\DateTimePicker::className(), [
        'template' => '{input}{button}',
        'pickButtonIcon' => 'glyphicon glyphicon-calendar',
        'clientOptions' => [
            'format' => Formatter::phpDateCodeToDatepickerCode(Yii::$app->session->get('dateFormat')),
            'minView' => 'month',
            'maxView' => 'year',
            'autoclose' => true
        ]
    ])->label('When did you receive the money?') ?>

    <?= $form->field($formModel, 'description') ?>

    <?= $form->field($formModel, 'amount')->label('How much did you receive?') ?>

    <?= $form->field($formModel, 'account_id')->dropDownList($accounts, [
        'prompt' => 'Select one',
        'options' => [
            $selectedAccount => ['selected' => true]
        ]
        ])->label('Account')
    ?>

    <?= $form->field($formModel, 'jar_id')
        ->dropDownList($jars, ['prompt' => $formModel->scenario != 'update' ? 'Other' : 'Select One'])
        ->label('Jar'.($formModel->scenario != 'update' ? ' (leave "other" if you don\'t want to assign it to a jar)' : '')) ?>

</div>
<div class="modal-footer">
    <?= Html::submitButton('Close', ['class' => 'btn btn-default close-modal', 'data-dismiss' => 'modal']) ?>
    <?= Html::submitButton(
        $formModel->scenario == 'update' ? 'Save Income' : 'Add Income',
        [
            'class' => 'btn btn-primary ajax-submit',
            'data-js-callback' => $jsCallback ? $jsCallback : 'reloadMoneyOperationsTable',
            'data-submit-url' => $formModel->scenario == 'update' ?
                Url::toRoute(['/incomes/edit-onetime-income', 'id' => $id]) :
                Url::toRoute(['/incomes/add-onetime-income'])
        ]) ?>
</div>
<?php ActiveForm::end(); ?>
<?= JsTools::viewJs($this); ?>
