<?php
use backend\models\db\Jar;
use yii\helpers\Url;
use backend\components\helpers\Formatter;
?>

<nav id="secondary-side-bar" class="navmenu navmenu-default navmenu-fixed-left jars-side-bar" role="navigation">
    <div id="seconday-side-bar-header">
        <h2><?= ($allowEdit) ? 'Jars' : 'Deleted Jars'; ?></h2>

        <?php if ($allowEdit) { ?>
        <a class="btn btn-primary btn-sm open-modal" data-modal-url="<?= Url::toRoute(['/jars/create-expense-jar', 'budget_id' => (isset($budget) ? $budget->id : false)]) ?>"><i class="glyphicon glyphicon-plus"></i> Add</a>
        <a class="btn btn-primary btn-sm reorder-jars" data-budget-id="<?= isset($budget) ? $budget->id : '' ?>">
            <i class="glyphicon glyphicon-move"></i>
            <span class='text'>Reorder Jars</span>
            <span class='active-text'>Save Order</span>
        </a>
        <?php } ?>
    </div>
    <ul id="secondary-side-bar-nav" class="nav navmenu-nav panel-group jars reorder-jars-list" role="tablist" aria-multiselectable="true">
        <?php /** @var Jar $j */
            foreach ($jars as $j) {
                $id = $j->id;
                $name = $j->name;
                $amountSpent = Formatter::currency($j->getThisMonthsTransactionsAmount());
                $fundsRemaining = Formatter::currency($j->getThisMonthsFundsRemainingAmount());
                $isActive = (isset($jar) && ($j->id == $jar->id));
                $iconUrl = Url::to('@web/imgs/jar.svg');
                if ($j->jar_type_id == 2) {
                    if ($allowEdit) {
                        $url = Url::toRoute(['jars/debt-jar-detail', 'id' => $j->id]);
                    }
                    else {
                        $url = Url::toRoute(['jars/deleted-debt-jar-detail', 'id' => $j->id]);
                    }
                } else {
                    if ($allowEdit) {
                        $url = Url::toRoute(['jars/expense-jar-detail', 'id' => $j->id]);
                    } else {
                        $url = Url::toRoute(['jars/deleted-expense-jar-detail', 'id' => $j->id]);
                    }
                }

                echo $this->render('_jars-list-item', [
                    'id' => $id,
                    'name' => $name,
                    'amountSpent' => $amountSpent,
                    'fundsRemaining' => $fundsRemaining,
                    'isActive' => $isActive,
                    'url' => $url,
                    'iconUrl' => $iconUrl
                ]);
            }
        ?>
    </ul>
</nav>
