<?php
use backend\widgets\JarTooltip;
use yii\bootstrap\ButtonDropdown;
use yii\helpers\Url;
use backend\widgets\FormattedTitle;
use backend\widgets\VideoTutorial;
?>
<?php if (isset($isMockBudget) && $isMockBudget) { ?>
<div id="body" class="container-fluid secondary-nav is-mock-budget" data-jar-id="<?= $jar->id; ?>" data-js-callback="jarDetailLoaded" data-select-menu="<?= ($allowEdit) ? 'li#my-jars-jars' : 'li#my-jars-deleted-jars'; ?>" data-jar-id="<?= $jar->id ?>" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>" data-mock-budget-id="<?= $budgetId ?>">
<?php } else { ?>
<div id="body" class="container-fluid secondary-nav" data-jar-id="<?= $jar->id; ?>" data-js-callback="jarDetailLoaded" data-select-menu="<?= ($allowEdit) ? 'li#my-jars-jars' : 'li#my-jars-deleted-jars'; ?>" data-jar-id="<?= $jar->id ?>" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>">
<?php } ?>
    <?= VideoTutorial::widget(['type' => $allowEdit ? 'jars' : 'deleted-jars']) ?>
    <?php if (isset($isMockBudget) && $isMockBudget) {
        echo $this->render('/mock-budgets/_mock-budget-header', [
            'budgetId' => $budgetId,
            'budgetName' => $budgetName,
            'pageTitle' => 'Jars',
        ]);
    } ?>
    <div class="row">
        <div class="col-md-12">
            <div class="col-head">
                <h3><?= $jar->name ?></h3>
                <?php if ($allowEdit) { ?>
                <a href="#" class="open-modal" data-modal-url="<?= Url::toRoute(['/jars/edit-expense-jar', 'id' => $jar->id]) ?>" data-toggle="tooltip" title="Edit"><i class="glyphicon glyphicon-pencil gi-2x"></i></a>
                <a href="#" class="open-modal" data-modal-url="<?= Url::toRoute(['/jars/remove-expense-jar', 'id' => $jar->id]) ?>" data-toggle="tooltip" title="Remove"><i class="glyphicon glyphicon-trash gi-2x"></i></a>
                <?php } else { ?>
                <a href="#" class="open-modal" data-modal-url="<?= Url::toRoute(['/jars/restore-expense-jar', 'id' => $jar->id]) ?>" data-toggle="tooltip" title="Restore"><i class="glyphicon glyphicon-refresh gi-2x"></i></a>
                <?php } ?>
                <?=
                JarTooltip::widget(['type' => $jar->type])
                ?>
            </div>
        </div>
    </div>

    <div class="row jar-header-info">
      <?= $this->render('debt-jar-detail-header-info.php', [
          'budget' => $budget,
          'jar' => $jar
      ]); ?>
    </div>

    <div class="row">
        <div class="col-md-7">
            <div class="col-head">
                <h4>Recurring Expenses</h4>
            </div>
        </div>

        <div class="col-sm-5">
            <div class="input-group">
                <input type="text" class="form-control table-search" data-search-id="d-table-1">
                <span class="input-group-addon">
                    <span class="glyphicon glyphicon-search"></span>
                </span>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-table debts-panel">
                <?= $this->render('/debt-payments/_debt-payments-table-full', [
                    'id' => 1,
                    'budget' => $budget,
                    'jar' => $jar,
                    'allowEdit' => $allowEdit
                ]); ?>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-3">
            <div class="col-head">
                <h4>Transactions</h4>
            </div>
        </div>
        <div class="col-sm-4">
            <?= ButtonDropdown::widget([
                'label' => $year,
                'dropdown' => [
                    'items' => $years,
                ]
            ]); ?>
            <?= ButtonDropdown::widget([
                'label' => $monthName,
                'dropdown' => [
                    'items' => $months,
                ]
            ]); ?>
        </div>
        <div class="col-sm-5">
            <div class="input-group">
                <input type="text" class="form-control table-search" data-search-id="d-table-2">
                <span class="input-group-addon">
                    <span class="glyphicon glyphicon-search"></span>
                </span>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-table debts-panel">
                <?= $this->render('/debt-payments/_debt-transactions-table-full', [
                    'id' => 2,
                    'budget' => $budget,
                    'jar' => $jar,
                    'allowEdit' => $allowEdit,
                    'year' => $year,
                    'month' => $month
                ]); ?>
            </div>
        </div>
    </div>

    <?= $this->render('/layouts/_footer') ?>

</div>
