<?php

use backend\models\db\Jar;
use backend\widgets\FormattedTitle;
use backend\widgets\JarTooltip;
use backend\widgets\Tooltip;
use yii\bootstrap\ButtonDropdown;
use yii\helpers\Html;
use yii\helpers\Url;
use backend\widgets\VideoTutorial;
?>

<?php if (isset($isMockBudget) && $isMockBudget) { ?>
<div id="body" class="container-fluid secondary-nav is-mock-budget" data-jar-id="<?= $jar->id; ?>" data-js-callback="jarDetailLoaded" data-select-menu="<?= ($allowEdit) ? 'li#my-jars-jars' : 'li#my-jars-deleted-jars'; ?>" data-jar-id="<?= $jar->id ?>" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>" data-mock-budget-id="<?= $budgetId ?>">
<?php } else { ?>
<div id="body" class="container-fluid secondary-nav" data-jar-id="<?= $jar->id; ?>" data-js-callback="jarDetailLoaded" data-select-menu="<?= ($allowEdit) ? 'li#my-jars-jars' : 'li#my-jars-deleted-jars'; ?>" data-jar-id="<?= $jar->id ?>" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>">
<?php } ?>
    <?= VideoTutorial::widget(['type' => $allowEdit ? 'jars' : 'deleted-jars']) ?>
    <?php if (isset($isMockBudget) && $isMockBudget) {
        echo $this->render('/mock-budgets/_mock-budget-header', [
            'budgetId' => $budgetId,
            'budgetName' => $budgetName,
            'pageTitle' => 'Jars',
        ]);
    } ?>
    <div class="row">
        <div class="col-md-12">
            <div class="col-head">
                <h3><?= $jar->name ?></h3>
                <?php if ($allowEdit) { ?>
                <a href="#" class="open-modal" data-modal-url="<?= Url::toRoute(['/jars/edit-expense-jar', 'id' => $jar->id]) ?>" data-toggle="tooltip" title="Edit"><i class="glyphicon glyphicon-pencil gi-2x"></i></a>
                <?php if ($jar->type != Jar::EVERYDAY_JAR_TYPE) { ?>
                <a href="#" class="open-modal" data-modal-url="<?= Url::toRoute(['/jars/remove-expense-jar', 'id' => $jar->id]) ?>" data-toggle="tooltip" title="Remove"><i class="glyphicon glyphicon-trash gi-2x"></i></a>
                <?php }
                } else { ?>
                <a href="#" class="open-modal" data-modal-url="<?= Url::toRoute(['/jars/restore-expense-jar', 'id' => $jar->id]) ?>" data-toggle="tooltip" title="Restore"><i class="glyphicon glyphicon-refresh gi-2x"></i></a>
                <?php } ?>
                <?=
                    JarTooltip::widget(['type' => $jar->type])
                ?>
            </div>
        </div>
    </div>

    <div class="row jar-header-info">
      <?= $this->render('expense-jar-detail-header-info.php', [
          'jar' => $jar
      ]); ?>
    </div>

    <div class="row">
        <div class="col-md-7">
            <div class="col-head">
                <h4>
                    Regular Expenses
                    <?=
                        Tooltip::widget(['text' => 'Most expenses are ‘Regular expenses’ Regular expenses are a part of everyday life but they do not a have a set frequency or amount.']);
                    ?>
                </h4>
                <?php if ($allowEdit) { ?>
                <a class="btn btn-primary btn-sm open-modal" data-modal-url="<?= Url::toRoute(['/expenses/add-estimated-expense', 'jar_id' => $jar->id]) ?>"><i class="glyphicon glyphicon-plus"></i> Add</a>
                <?php } ?>
            </div>
        </div>

        <div class="col-sm-5">
            <div class="input-group">
                <input type="text" class="form-control table-search" data-search-id="ee-table-1">
                <span class="input-group-addon">
                    <span class="glyphicon glyphicon-search"></span>
                </span>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-table expenses-panel recurring-expenses">
                <?= $this->render('/expenses/_estimated-expenses-table.php', [
                    'jar' => $jar,
                    'enhanced' => (isset($enhanced) ? $enhanced : true),
                    'totalMonthlyAvg' => $totalMonthlyEstimAvg,
                    'allowEdit' => $allowEdit
                ]); ?>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-7">
            <div class="col-head">
                <h4>
                    Recurring Expenses
                    <?=
                        Tooltip::widget(['text' => 'Recurring expenses are expenses that occur at consistent interval and are the same value every time. Good examples of this are mobile phone plans, loan repayments, insurance payments, sponsor children etc. When you enter an expense as ‘Recurring’ Grandma’s Jars will automatically assume these are ongoing expenses and will record them on their due date without any input from you.']);
                    ?>
                </h4>
                <?php if ($allowEdit) { ?>
                <a class="btn btn-primary btn-sm open-modal" data-modal-url="<?= Url::toRoute(['/expenses/add-recurring-expense', 'jar_id' => $jar->id]) ?>"><i class="glyphicon glyphicon-plus"></i> Add</a>
                <?php } ?>
            </div>
        </div>

        <div class="col-sm-5">
            <div class="input-group">
                <input type="text" class="form-control table-search" data-search-id="re-table-1">
                <span class="input-group-addon">
                    <span class="glyphicon glyphicon-search"></span>
                </span>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-table expenses-panel recurring-expenses">
                <?= $this->render('/expenses/_recurring-expenses-table.php', [
                    'jar' => $jar,
                    'totalMonthlyAvg' => $totalMonthlyRecurrAvg,
                    'allowEdit' => $allowEdit
                ]); ?>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-7">
            <div class="col-head">
                <h4>
                    One-off Expenses
                    <?=
                        Tooltip::widget(['text' => 'One-off expenses are typically larger one off purchases that you are saving towards and want to factor into your budget, examples of One-off expenses are – a new laptop, a new car, an overseas holiday, wedding costs etc.']);
                    ?>
                </h4>
                <?php /*if ($allowEdit) { ?>
                <a class="btn btn-primary btn-sm open-modal" data-modal-url="<?= Url::toRoute(['/expenses/add-onetime-expense', 'jar_id' => $jar->id]) ?>"><i class="glyphicon glyphicon-plus"></i> Add</a>
                <?php }*/ ?>
            </div>
        </div>

        <div class="col-sm-5">
            <div class="input-group">
                <input type="text" class="form-control table-search" data-search-id="oe-table-1">
                <span class="input-group-addon">
                    <span class="glyphicon glyphicon-search"></span>
                </span>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-table expenses-panel onetime-expenses">
                <?= $this->render('/expenses/_onetime-expenses-table.php', [
                    'jar' => $jar,
                    'totalMonthlyAvg' => $totalMonthlyOneTimeAvg,
                    'totalOneTimeAmount' => $totalOneTimeAmount,
                    'totalOneTimeSavedAndPaid' => $totalOneTimeSavedAndPaid,
                    'allowEdit' => $allowEdit
                ]); ?>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-3">
            <div class="col-head">
                <h4>Transactions</h4>
            </div>
        </div>
        <div class="col-sm-4">
            <?= ButtonDropdown::widget([
                'label' => $year,
                'dropdown' => [
                    'items' => $years,
                ],

            ]); ?>
            <?= ButtonDropdown::widget([
                'label' => $monthName,
                'dropdown' => [
                    'items' => $months,
                ]
            ]); ?>
        </div>
        <div class="col-sm-5">
            <div class="input-group">
                <input type="text" class="form-control table-search" data-search-id="t-table-1">
                <span class="input-group-addon">
                    <span class="glyphicon glyphicon-search"></span>
                </span>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-table transactions-panel">
                <?= $this->render('/transactions/_transactions-table.php', [
                    'jar' => $jar,
                    'allowEdit' => $allowEdit,
                    'year' => $year,
                    'month' => $month
                ]); ?>
            </div>
        </div>
    </div>

    <?= $this->render('/layouts/_footer') ?>

</div>
