<?php
use backend\components\helpers\Formatter;
use backend\models\db\Jar;
use backend\widgets\Tooltip;

/** @var Jar $jar */
?>



<div class="item-value col-md-15">
  <div class="value jar-amount"><?= Formatter::currency($jar->getThisMonthsFundsBroughtForwardAmount()); ?></div>
  <div class="desc">
    Accumulated Funds
    <?=
      Tooltip::widget(['text' => 'The Accumulated Funds is the balance of funds that haven’t been spent in previous months. Whatever you don’t spend of your monthly allocation accumulates in the Jar and becomes your Accumulated Funds.']);
    ?>
  </div>
</div>
<div class="item-value col-md-15">
  <div class="value this-months-expenses-amount"><?= Formatter::currency($jar->getMonthlyBudget()); ?></div>
  <div class="desc">
    Monthly Budget
    <?=
      Tooltip::widget(['text' => 'Monthly Budget is the amount you allocate to each Jar on a monthly basis.']);
    ?>
  </div>
</div>
<div class="item-value col-md-15">
  <div class="value this-months-transactions-amount"><?= Formatter::currency($jar->getThisMonthsTransactionsAmount(false, false)); ?></div>
  <div class="desc">
    Amount Spent
     <?=
      Tooltip::widget(['text' => 'The ‘Amount Spent’ is the total amount spent against this Jar for the current month.']);
    ?>
  </div>
</div>
<div class="item-value col-md-15">
  <div class="value this-months-money-in"><?= Formatter::currency($jar->getThisMonthsMoneyInAmount(false, false)); ?></div>
  <div class="desc">
    Money In
    <?=
    Tooltip::widget(['text' => 'The ‘Money In‘ is money that was taken from a jar and then returned. An example would be a refund on an item purchased or money back from a payment.']);
    ?>
  </div>
</div>
<div class="item-value col-md-15">
  <div class="value this-months-funds-remaining"><?= Formatter::currency($jar->getThisMonthsFundsRemainingAmount()); ?></div>
  <div class="desc">
    Funds Remaining
    <?=
      Tooltip::widget(['text' => 'The ‘Funds remaining’ is the amount you have left to spend this month.']);
    ?>
  </div>
</div>

