<?php
use yii\helpers\Html;
use yii\helpers\Url;
use backend\widgets\FormattedTitle;
?>
<!---------------------------------------------------------------
Secondary Navigation
---------------------------------------------------------------->
<?= $this->render('_jars-list', [
    'budget' => $budget,
    'jars' => $jars,
    'jar' => $jar,
    'title' => ($allowEdit) ? 'My Jars' : 'Deleted Jars',
    'allowEdit' => $allowEdit
]); ?>
<!---------------------------------------------------------------
End Secondary Navigation
---------------------------------------------------------------->

<!---------------------------------------------------------------
Body
---------------------------------------------------------------->
<div class="jar-container content-container" data-block-loading="true">

<?= $this->render('expense-jar-detail-content', [
    'jar' => $jar,
    'totalMonthlyRecurrAvg' => $totalMonthlyRecurrAvg,
    'totalMonthlyEstimAvg' => $totalMonthlyEstimAvg,
    'totalMonthlyOneTimeAvg' => $totalMonthlyOneTimeAvg,
    'totalOneTimeAmount' => $totalOneTimeAmount,
    'totalOneTimeSavedAndPaid' => $totalOneTimeSavedAndPaid,
    'allowEdit' => $allowEdit,
    'budgetId' => (isset($budgetId) ? $budgetId : false),
    'budgetName' => (isset($budgetName) ? $budgetName : false),
    'isMockBudget' => (isset($isMockBudget) ? $isMockBudget : false),
    'year' => $year,
    'years' => $years,
    'monthName' => $monthName,
    'month' => $month,
    'months' => $months
]); ?>

</div>
<!---------------------------------------------------------------
End Body
---------------------------------------------------------------->


