<?php
use yii\helpers\Html;
use yii\helpers\Url;
use yii\bootstrap\ActiveForm;
use backend\components\helpers\JsTools;
?>

<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h4 class="modal-title" id="myModalLabel"><?= Html::encode($this->title) ?></h4>
</div>
<?php $form = ActiveForm::begin(['id' => 'remove-jar-form']); ?>
<div class="modal-body">
    <p><strong>Do you really wish to remove this jar?</strong></p>
    <p>You will no longer be able to assign any transactions or expenses to this jar once you delete it. Deleted Jars can be restored on the Deleted Jars page under My Jars.</p>
</div>
<div class="modal-footer">
    <?= Html::submitButton('Close', ['class' => 'btn btn-default close-modal', 'data-dismiss' => 'modal']) ?>
    <?= Html::submitButton('Remove Jar', ['class' => 'btn btn-primary ajax-submit', 'data-js-callback' => JsTools::jsCallback($this, 'reloadJarsAfterRemove'), 'data-submit-url' => Url::toRoute(['/jars/remove-jar', 'id' => $jarId, 'confirm' => '1'])]) ?>
</div>
<?php ActiveForm::end(); ?>
