<?php
use yii\helpers\Html;
use yii\helpers\Url;
use yii\bootstrap\ActiveForm;
use backend\components\helpers\JsTools;
?>

<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h4 class="modal-title" id="myModalLabel"><?= Html::encode($this->title) ?></h4>
</div>
<?php $form = ActiveForm::begin(['id' => 'restore-jar-form', 'options' => ['data-jar-id' => $jarId]]); ?>
<div class="modal-body">
    <p>Do you really wish to restore this jar?</p>
</div>
<div class="modal-footer">
    <?= Html::submitButton('Close', ['class' => 'btn btn-default close-modal', 'data-dismiss' => 'modal']) ?>
    <?= Html::submitButton('Restore Jar', ['class' => 'btn btn-primary ajax-submit', 'data-js-callback' => 'reloadJarsAfterRestore', 'data-submit-url' => Url::toRoute(['/jars/restore-jar', 'id' => $jarId, 'confirm' => '1'])]) ?>
</div>
<?php ActiveForm::end(); ?>
