<?php

use backend\assets\VisitorAsset;
use backend\models\db\UserPlan;
use yii\helpers\Html;
use yii\helpers\Url;

/* @var $this \yii\web\View */
/* @var $content string */

VisitorAsset::register($this);

$this->beginPage(); ?><!DOCTYPE html>
<html lang="en">
    <head>
        <?php if (empty(Yii::$app->params['hideIntercom'])) { ?>
        <script>
            var dataLayer = window.dataLayer = window.dataLayer || [];
            dataLayer.push({
                intercomSettings: {
                    app_id: "eyivdakd"<?php if (!Yii::$app->user->isGuest) { ?>,
                    name: "<?= Yii::$app->user->identity->fullName ?>",
                    email: "<?= Yii::$app->user->identity->email ?>",
                    user_id: "<?= Yii::$app->user->id ?>",
                    created_at: <?= strtotime(Yii::$app->user->identity->created_at) ?>,
                    <?php $userPlan = UserPlan::getActivePlan(Yii::$app->user->id);
                        if ($userPlan) { ?>plan_name: "<?= $userPlan->userPlanVariation->name ?>",<?php } ?>
                    user_hash: "<?= hash_hmac(
                        'sha256',
                        Yii::$app->user->id,
                        Yii::$app->params['intercom_hash']
                    ) ?>"
                    <?php } ?>
                }
                <?php if (empty(Yii::$app->params['hideIntercom']) && Yii::$app->session->get('signed-up')) {
                $data = Yii::$app->session->get('signed-up'); ?>
                , signedUpEmail: '<?= $data['email'] ?>'
                , signedUpPlan: '<?= $data['plan'] ?>'
                <?php Yii::$app->session->remove('signed-up');
                }
                if (!Yii::$app->user->isGuest) { ?>
                , userId: <?= Yii::$app->user->id ?>
                <?php } ?>
            });
        </script>
        <?php } ?>
        <!-- Google Tag Manager -->
        <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
                    new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
                j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
                'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
            })(window,document,'script','dataLayer','GTM-KVVB5GB');</script>
        <!-- End Google Tag Manager -->
        <meta content="text/html;charset=UTF-8" http-equiv="content-type">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="apple-mobile-web-app-capable" content="yes" />
        <?= Html::csrfMetaTags() ?>
        <title><?= Html::encode($this->title) ?> | <?= Yii::$app->name ?></title>
        <link rel="shortcut icon" href="<?= Url::to(['/favicon.ico']) ?>" type="image/x-icon">
        <link rel="icon" href="<?= Url::to(['/favicon.ico']) ?>" type="image/x-icon">
        <?php $this->head() ?>
    </head>
    <body>
        <!-- Google Tag Manager (noscript) -->
        <noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-KVVB5GB"
                          height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
        <!-- End Google Tag Manager (noscript) -->
        <?php $this->beginBody() ?>
        <div class="wrap">
            <nav id="top-bar" class="container-fluid navbar-fixed-top">
                <div class="wrap">
                    <div id="logo">
                        <a href="/" class="system-link"><img class="logo-light" src="<?= Url::to('@web/imgs/logo-light.svg') ?>" onerror="this.src='<?= Url::to('@web/imgs/logo-light.svg') ?>'" alt="Grandmas Jars"></a>
                    </div>
                </div>
            </nav>
            <div class="container">
                <?php if (Yii::$app->session->hasFlash('warning')) { ?>
                    <div class="app-warning">
                        <p class="text-center">
                            <?= Yii::$app->session->getFlash('warning') ?>
                        </p>
                    </div>
                <?php } ?>
                <?php if (Yii::$app->session->hasFlash('success')) { ?>
                    <div class="app-success autodestroy" data-timeout="10">
                        <p class="text-center">
                            <?= Yii::$app->session->getFlash('success') ?>
                        </p>
                    </div>
                <?php } ?>

                <?= $content ?>
            </div>
        </div>

        <footer class="footer">
            <div class="container">
                <p class="pull-left">&copy; <?= Yii::$app->name ?> <?= date('Y') ?></p>
            </div>
        </footer>

        <?php $this->endBody() ?>
    </body>
</html>
<?php $this->endPage();
