<?php
use backend\widgets\FormattedTitle;

try {
    $pageContent = $this->render("lessons/{$group}/{$page}");
}
catch (\yii\base\ViewNotFoundException $e) {
    throw new \yii\web\NotFoundHttpException("Page '{$page}' not found");
}
?>
<div class="lesson-container" data-block-loading="true">
    <div id="body" class="container-fluid secondary-nav" data-select-menu="li#lessons-nav" data-js-callback="lessonsPageLoaded" data-page-title="<?= FormattedTitle::widget( [ 'title' => $this->title ] ); ?>">
        <div class="row">
            <div class="col-md-12">
                <?= $pageContent ?>
            </div>
        </div>

        <?= $this->render('/layouts/_footer') ?>
    </div>
</div>