<?php
use yii\helpers\Url;
use backend\components\helpers\Formatter;

$showTotal = !($moneyOperationsAmount === null);
$footSpan = $showTotal ? 7 : 8;
?>

<table id="mo-table-1" class="table table-paginated table-bordered data-table secondary-date-sorting" data-table-id="mo-table-1" data-ajax="<?= (isset($ajaxUrl)) ? $ajaxUrl : Url::toRoute(['/money-operations/money-operations-table', 'year' => $year, 'month' => $month]) ?>">
    <thead>
        <tr>
            <th class="sort-by sort-desc">Date</th>
            <th>Expense/Income/Debt</th>
            <th>Description</th>
            <th>Account</th>
            <th>Amount</th>
            <th>Jar</th>
            <th class="no-sort">Checked</th>
            <th class="no-sort"></th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td colspan="8">No transactions yet.</td>
        </tr>
    </tbody>
    <tfoot>
        <tr>
            <td colspan="<?= $footSpan ?>">
                <div class='table-footer-legend'>
                    <div class='item'>
                        <i class="glyphicon glyphicon-triangle-bottom ico-spend"></i>
                        Spend
                    </div>
                    <div class='item'>
                        <i class="glyphicon glyphicon-triangle-top ico-receive"></i>
                        Receive
                    </div>
                    <div class='item'>
                        <i class="glyphicon glyphicon-triangle-right ico-transfer"></i>
                        Transfer
                    </div>
                </div>
            <?php if ($showTotal) { ?>
                <span class='this-months-money-operations-label'>Total Transactions</span>
            </td>
            <td class="this-months-money-operations-amount"><?= Formatter::currency($moneyOperationsAmount) ?>
            <?php } ?>
            </td>
        </tr>
    </tfoot>
</table>

