<?php
/**
 * @var yii\web\View $this
 * @var \backend\models\db\userActivity\Jar $model
 */
$formatter = Yii::$app->formatter;
?>
<div class="panel panel-tabbed">
    <div class="item item-single clearfix">
        <div class="icon">
            <i class="glyphicon glyphicon-gear"></i>
        </div>
        <div class="title">
            <div><?= $model->title ?> </div>
            <div class="info"><?= $formatter->asTime($model->time, 'short') ?> </div>
        </div>
        <div class="col">
            <div><?= $model->description ?></div>
            <div class="info info-spec"><?= $labels['categoryName'] ?></div>
        </div>
        <div class="col">
            <div><?= $formatter->asDate($model->date) ?></div>
            <div class="info">Date</div>
        </div>
        <div class="col">
            <?php if (!empty(@$model->fields['jar'])): ?>
                <div>Everyday</div>
                <div class="info">Jar</div>
            <?php endif ?>
        </div>
        <div class="col">
            <?php if (!empty(@$model->fields['expense'])): ?>
            <div>&nbsp;</div>
            <div class="info">Expense</div>
            <?php endif ?>
        </div>
        <div class="col">
            <?php if (!empty(@$model->fields['amount'])): ?>
            <div><?= $formatter->asCurrency($model->fields['amount']) ?></div>
            <div class="info">Amount</div>
            <?php endif ?>
        </div>
        <div class="actions last">
            <a href="#" id="menu1" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true"><i
                    class="glyphicon glyphicon-cog gi-2x"></i></a>
            <ul class="dropdown-menu" aria-labelledby="menu1">
                <li><a href="#">Snooze</a></li>
                <li><a href="#">Dismiss</a></li>
            </ul>
        </div>
    </div>
</div>

