<?php

use yii\helpers\Html;
use backend\widgets\FormattedTitle;
use yii\helpers\Url;
use yii\grid\GridView;
use backend\components\helpers\Formatter;
use backend\components\helpers\JsTools;

?>
<div id="body" class="container-fluid" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>">

    <div class="col-head">
        <h3>New notifications</h3>
        <?php if ($newNotificationsProvider->getTotalCount() > 0) {
            echo '<a href="#" class="open-modal btn btn-primary btn-sm" data-modal-url="' . Url::to(['/notifications/mark-all-as-read']) . '">Mark All as Read</a>';
        } ?>
    </div>

    <div class="notifications new-notifications">
        <div class="panel panel-table no-border margin-top">
            <div class="table-responsive">
                <?= GridView::widget([
                    'layout' => '{items}',
                    'showHeader' => false,
                    'dataProvider' => $newNotificationsProvider,
                    'pager' => [
                        'class' => yii\widgets\LinkPager::className(),
                        'firstPageLabel' => 'First',
                        'lastPageLabel' => 'Last',
                    ],
                    'tableOptions' => ['class' => 'notifications-list table table-striped outer-border'],
                    'columns' => [
                        [
                            'label' => '',
                            'format' => 'raw',
                            'contentOptions' => function ($m) {
                                return [
                                    'class' => 'notification-icon middle notification-category-' . $m->notificationTemplate->notification_category_id,
                                ];
                            },
                            'value' => function ($m) {
                                return '<i class="glyphicon ' . $m->notificationTemplate->getTemplateGlyphicon() . '"></i>';
                            }
                        ],
                        [
                            'attribute' => 'content',
                            'format' => 'raw',
                            'contentOptions' => function ($m) {
                                return [
                                    'class' => 'notification-content notification-category-' . $m->notificationTemplate->notification_category_id . '-link',
                                ];
                            },
                            'value' => function ($m) {
                                return
                                    '<p>' .
                                        $m->content .
                                        '<span class="date">' . Formatter::datetime(Formatter::utcDatetimeToLocalDatetime($m->created_at, $timezone->code, 'Y-m-d H:i:s')) . '</span>' .
                                    '</p>';
                            },
                        ],
                        [
                            'label' => '',
                            'format' => 'raw',
                            'contentOptions' => function ($m) {
                                return [
                                    'class' => 'notification-buttons middle notification-category-' . $m->notificationTemplate->notification_category_id,
                                    'nowrap' => 'nowrap'
                                ];
                            },
                            'value' => function ($m) {
                                return
                                    '<a href="" class="open-modal btn btn-success btn-sm" data-modal-url="' . Url::to(['/notifications/snooze-notification', 'id' => $m->id]) . '">Remind Me</a>' .
                                    '<a href="' . Url::to(['/notifications/mark-as-read', 'notification_id' => $m->id]) . '" class="btn btn-primary btn-sm mark-as-read">Mark as Read</a>';
                            }
                        ]
                    ],
                ]); ?>
            </div>

        </div>
    </div>

    <div class="col-head">
        <h3>Read notifications</h3>
        <?php if ($oldNotificationsProvider->getTotalCount() > 0) {
            echo '<a href="#" class="open-modal btn btn-primary btn-sm" data-modal-url="' . Url::to(['/notifications/delete-all']) . '">Delete All</a>';
        } ?>
    </div>

    <?php \yii\widgets\Pjax::begin([
        'id' => 'pjax-main',
        'enableReplaceState' => true,
    ]) ?>

    <div class="notifications new-notifications">
        <div class="panel panel-table no-border margin-top">

            <div class="table-responsive">
                <?= GridView::widget([
                    'layout' => '{pager}{items}{summary}',
                    'showHeader' => false,
                    'dataProvider' => $oldNotificationsProvider,
                    'pager' => [
                        'class' => yii\widgets\LinkPager::className(),
                        'firstPageLabel' => 'First',
                        'lastPageLabel' => 'Last'
                    ],
                    'tableOptions' => ['class' => 'notifications-list table table-striped outer-border'],
                    'columns' => [
                        [
                            'label' => '',
                            'format' => 'raw',
                            'contentOptions' => function ($m){
                                return [
                                    'class' => 'notification-icon middle notification-category-' . $m->notificationTemplate->notification_category_id,
                                ];
                            },
                            'value' => function ($m) {
                                return '<i class="glyphicon ' . $m->notificationTemplate->getTemplateGlyphicon() . '"></i>';
                            }
                        ],
                        [
                            'attribute' => 'content',
                            'format' => 'raw',
                            'contentOptions' => function ($m){
                                return [
                                    'class' => 'notification-content notification-category-' . $m->notificationTemplate->notification_category_id . '-link',
                                ];
                            },
                            'value' => function ($m) {
                                return
                                    '<p>' .
                                        $m->content .
                                        '<span class="date">' . Formatter::datetime(strtotime($m->created_at)) . '</span>' .
                                    '</p>';
                            },
                        ],
                        [
                            'label' => '',
                            'format' => 'raw',
                            'contentOptions' => function ($m){
                                return [
                                    'class' => 'notification-buttons middle notification-category-' . $m->notificationTemplate->notification_category_id,
                                    'nowrap' => 'nowrap'
                                ];
                            },
                            'value' => function ($m) {
                                return
                                    '<a href="#" class="open-modal btn btn-success btn-sm" data-modal-url="' . Url::to(['/notifications/snooze-notification', 'id' => $m->id]) . '">Remind Me</a>' .
                                    '<a href="#" class="open-modal btn btn-primary btn-sm" data-modal-url="' . Url::to(['/notifications/delete', 'id' => $m->id]) . '">Delete</a>';
                            }
                        ]
                    ],
                ]); ?>
            </div>

        </div>
    </div>
    <?php \yii\widgets\Pjax::end() ?>

    <?= $this->render('/layouts/_footer') ?>

</div>
<?= JsTools::viewJs($this); ?>
