<?php
use backend\components\StripeCheckoutExtended;
use kartik\switchinput\SwitchInput;
use yii\helpers\Html;
use yii\bootstrap\ActiveForm;
use backend\widgets\Messages;
use yii\helpers\Url;
use yii\web\JsExpression;

/* @var $this yii\web\View */
/* @var $title string */
/* @var $subtitle string */
/* @var $formModel \common\models\form\Register */
/* @var $plan \backend\models\db\UserPlanType */
/* @var $variations \backend\models\db\UserPlanVariation[] */

$this->params['breadcrumbs'][] = $title;

$plan1Variations   = $plan1->userPlanVariations;
$variation1Monthly = $plan1Variations[0]->plan_length == 1 ? $plan1Variations[0] : $plan1Variations[1];
$variation1Yearly  = $plan1Variations[0]->plan_length == 12 ? $plan1Variations[0] : $plan1Variations[1];

$plan2Variations   = $plan2->userPlanVariations;
$variation2Monthly = $plan2Variations[0]->plan_length == 1 ? $plan2Variations[0] : $plan2Variations[1];
$variation2Yearly  = $plan2Variations[0]->plan_length == 12 ? $plan2Variations[0] : $plan2Variations[1];
?>
<div class="site-login">
    <div class="row">
        <div class="col-md-6 col-md-offset-3">
            <h3 class="text-center mb40"><?= Html::encode($title) ?></h3>
            <?php if ($discount) { ?>
            <h3 class="text-center mb40" style="color:#7f66b3">
                Limited Time Offer. Expires Soon.<br/>
                $100 Off the Original Price.
            </h3>
            <?php } ?>
            <p class="text-center lead mb40">
                <?= $plan1->description ?>
            </p>
            <?= Messages::widget(['name' => 'registration']); ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6 col-md-offset-3">
            <?= Html::hiddenInput('option_selected', '', ['id' => 'option_selected']); ?>
            <?= Html::hiddenInput('tax_percent', Yii::$app->formatter->asDecimal(Yii::$app->params['gstTaxPercent'] / 100, 2), ['id' => 'tax_percent']) // FIXME: dynamic tax retrieval ?>
            <?= Html::hiddenInput('coupon_url', Url::toRoute(['/register/coupon']), ['id' => 'coupon_url']); ?>
            <?php $form = ActiveForm::begin([
                'id' => 'buy-form',
                'enableAjaxValidation' => true
            ]); ?>
            <?= $form->field($formModel, 'token', ['options' => ['class' => 'hidden']])->hiddenInput() ?>
            <?= $form->field($formModel, 'plan_variation_id', ['options' => ['class' => 'hidden']])->hiddenInput() ?>
            <?= $form->field($formModel, 'username') ?>
            <?= $form->field($formModel, 'email') ?>
            <?= $form->field($formModel, 'password')->passwordInput() ?>
            <?= $form->field($formModel, 'password_repeat')->passwordInput() ?>
            <?= $form->field($formModel, 'first_name') ?>
            <?= $form->field($formModel, 'last_name') ?>
            <?php if (!isset($noCoupon) || !$noCoupon) { ?>
            <?= $form->field($formModel, 'coupon')->label('Coupon Code') ?>
            <?php } ?>
            <?php ActiveForm::end(); ?>

            <div class="row" style="text-align:center;position:relative">
                <div class="col-md-5" style="display:inline-block;float:none;vertical-align:top">
                    <div class="panel panel-default option-1">
                        <h4 class="text-center">
                            Course + 1 Year Access<br/>
                            to the App
                        </h4>
                        <select class="form-control mb20 plan-select">
                            <option value="annual" selected
                                    data-id="<?= $variation1Yearly->id ?>"
                                    data-name="<?= $variation1Yearly->name ?>"
                                    data-price-original="<?= $variation1Yearly->getPrice() * 100 ?>"
                                    data-price="<?= $variation1Yearly->getPrice() * 100 ?>"
                                    data-price-text="$<?= $variation1Yearly->getPrice() ?> + GST">One-off Payment</option>
                            <option value="monthly"
                                    data-id="<?= $variation1Monthly->id ?>"
                                    data-name="<?= $variation1Monthly->name ?>"
                                    data-price-original="<?= $variation1Monthly->getPrice() * 100 ?>"
                                    data-price="<?= $variation1Monthly->getPrice() * 100 ?>"
                                    data-price-text="<?= $variation1Monthly->getPriceText(true) ?> for 12 months">Monthly Payment</option>
                        </select>
                        <h3 class="text-center mb40 variation-1 variation-option"
                            data-id="<?= $variation1Yearly->id ?>"
                            data-name="<?= $variation1Yearly->name ?>"
                            data-price-original="<?= $variation1Yearly->getPrice() * 100 ?>"
                            data-price="<?= $variation1Yearly->getPrice() * 100 ?>">
                            $<?= $variation1Yearly->getPrice() ?> + GST
                        </h3>
                        <div class="form-group text-center">
                            <?= Html::button('Buy', ['class' => 'btn btn-primary buy-button variation-1-button']); ?>
                        </div>
                    </div>
                </div>
                <div class="col-md-1" style="display:inline-block;float:none;position:absolute;top:40%">
                    <p class="text-center">
                        OR
                    </p>
                </div>
                <div class="col-md-5 col-md-offset-1" style="display:inline-block;float:none;vertical-align:top">
                    <div class="panel panel-default option-2">
                        <h4 class="text-center">
                            Course + 3 Months Access<br/>
                            to the App
                        </h4>
                        <select class="form-control mb20 plan-select">
                            <option value="annual" selected
                                    data-id="<?= $variation2Yearly->id ?>"
                                    data-name="<?= $variation2Yearly->name ?>"
                                    data-price-original="<?= $variation2Yearly->getPrice() * 100 ?>"
                                    data-price="<?= $variation2Yearly->getPrice() * 100 ?>"
                                    data-price-text="$<?= $variation2Yearly->getPrice() ?> + GST">One-off Payment</option>
                            <option value="monthly"
                                    data-id="<?= $variation2Monthly->id ?>"
                                    data-name="<?= $variation2Monthly->name ?>"
                                    data-price-original="<?= $variation2Monthly->getPrice() * 100 ?>"
                                    data-price="<?= $variation2Monthly->getPrice() * 100 ?>"
                                    data-price-text="<?= $variation2Monthly->getPriceText(true) ?> for 12 months">Monthly Payment</option>
                        </select>
                        <h3 class="text-center mb40 variation-2 variation-option"
                            data-id="<?= $variation2Yearly->id ?>"
                            data-name="<?= $variation2Yearly->name ?>"
                            data-price-original="<?= $variation2Yearly->getPrice() * 100 ?>"
                            data-price="<?= $variation2Yearly->getPrice() * 100 ?>">
                            $<?= $variation2Yearly->getPrice() ?> + GST
                        </h3>
                        <div class="form-group text-center">
                            <?= Html::button('Buy', ['class' => 'btn btn-primary buy-button variation-2-button']); ?>
                        </div>
                    </div>
                </div>
            </div>

            <?= StripeCheckoutExtended::widget([
                'id' => 'payInvoice',
                'name' => 'Grandma\'s Jars',
                'label' => 'Buy',
                'description' => new JsExpression('"Pay for " + $(".panel." + $("#option_selected").val()).find(".variation-option").data("name")'),
                'amount' => new JsExpression(
                    'parseInt($(".panel." + $("#option_selected").val()).find(".variation-option").data("price")) + '.
                    'parseInt($(".panel." + $("#option_selected").val()).find(".variation-option").data("price")) * $("#tax_percent").val()'
                ),
                'currency' => Yii::$app->params['defaultChargeCurrency'],
                'userEmail' => new JsExpression('$("#buy-form #register-email").val()'),
                'image' => Url::to(['/imgs/jar.png']),
                'buttonOptions' => [
                    'class' => 'btn btn-primary hidden',
                    'id' => 'stripe-buy'
                ],
                'tokenFunction' => new JsExpression("function(token) { submitFormWithToken(token); }"),
                'openedFunction' => new JsExpression('function() {}'),
                'closedFunction' => new JsExpression('function() {}')
            ]); ?>

            <?php $this->registerJs(<<<JS
    var planPrice = (parseInt($(".variation-1").attr("data-price")) / 100).toFixed(2);
    var dataLayer = window.dataLayer = window.dataLayer || [];
    dataLayer.push({
        trackEvent: 'Lead',
        salevalue: planPrice,
        saleCurrency: 'AUD'
    });
    
    function submitFormWithToken(token) {
        if (token.object == 'token') {
            $('html, body').animate({ scrollTop: 0 }, 'slow');
            $('.site-login').blockloader();
            $('#buy-form #register-token').val(token.id);
            $('#buy-form').submit();
        }
    }
    var clicked = false;
    $('body').on('change', '.plan-select', function() {
        var priceTag = $(this).next(),
            option = $(this).find('option:selected');
        priceTag.data('id', option.data('id'));
        priceTag.data('name', option.data('name'));
        priceTag.data('price-original', option.data('price-original'));
        priceTag.data('price', option.data('price'));
        priceTag.text(option.data('price-text'))
    });
    
    $('body').on('click', '.buy-button', function() {
        $('#register-plan_variation_id').val(
            $(this).parents('.panel').find('.variation-option').data('id')
        );
        $('#option_selected').val(
            $(this).hasClass('variation-1-button') ? 'option-1' : 'option-2'
        );
        $('#buy-form input:not(:hidden)').each(function() {
            $('#buy-form').yiiActiveForm('validateAttribute', $(this).attr('id'));
        });
        clicked = true;
        return false;
    });
    $('body').on('change', '#register-coupon', function() {
        $('.buy-button').attr('disabled', true);
        $.post(
            $('#coupon_url').val(),
            { id: $('#register-coupon').val() },
            function (data) {
                var variationOption = $('.panel.' + $('#option_selected').val()).find(".variation-option");
                if (data.success) {
                    if (data.amount) {
                        variationOption.attr("data-price", variationOption.data("price-original") - data.amount);
                    }
                    else {
                        variationOption.attr("data-price", variationOption.data("price-original") -
                            variationOption.attr("data-price-original") * data.percent);
                    }
                }
                else {
                    variationOption.attr("data-price", variationOption.data("price-original"));
                }
                $('.buy-button').attr('disabled', false);
            }, 'json'
        );
    });
    $('body').on('ajaxComplete', '#buy-form', function() {
        if ($(this).find('.has-error').length > 0) {
            clicked = false;
            return false;
        }
        var empty = $('#buy-form .required input:not(:hidden)').filter(function() { return $(this).val() == '' });
        if (empty.length == 0 && clicked && $('#buy-form #register-token').val() == '') {
            var variationOption = $('.panel.' + $('#option_selected').val()).find(".variation-option");
            clicked = false;
            var dataLayer = window.dataLayer = window.dataLayer || [];
            dataLayer.push({
                trackEvent: 'AddToCart',
                salevalue: planPrice,
                saleCurrency: 'AUD',
                saleContentIds: [variationOption.data("id")],
                saleContentType: variationOption.data("name")
            });
            $('#stripe-buy').trigger('click');
        }
        return false;
    });
JS
            ); ?>
        </div>
    </div>
</div>
