<?php
use backend\components\StripeCheckoutExtended;
use kartik\switchinput\SwitchInput;
use yii\helpers\Html;
use yii\bootstrap\ActiveForm;
use backend\widgets\Messages;
use yii\helpers\Url;
use yii\web\JsExpression;

/* @var $this yii\web\View */
/* @var $title string */
/* @var $subtitle string */
/* @var $formModel \common\models\form\Register */
/* @var $plan \backend\models\db\UserPlanType */
/* @var $variations \backend\models\db\UserPlanVariation[] */

$this->params['breadcrumbs'][] = $title;
$variations = $plan->getUserPlanVariations()->all();
$defaultVariation = $plan->getDefaultPlanVariation();
$formModel->plan_variation_id = $variations[0]->id;
?>
<div class="site-login">
    <div class="row">
        <div class="col-md-6 col-md-offset-3">
            <h3 class="text-center mb40"><?= Html::encode($title) ?></h3>
            <?php if (count($variations) > 1) { ?>
            <h3 class="text-center mb40 variation-0 variation-option"
                data-id="<?= $variations[0]->id ?>"
                data-name="<?= $variations[0]->name ?>"
                data-price-original="<?= $variations[0]->getPrice() * 100 ?>"
                data-price="<?= $variations[0]->getPrice() * 100 ?>">
                <?= $variations[0]->getPriceText(true) ?>
            </h3>
            <h3 class="text-center mb40 variation-1 variation-option hidden"
                data-id="<?= $variations[1]->id ?>"
                data-name="<?= $variations[1]->name ?>"
                data-price-original="<?= $variations[1]->getPrice() * 100 ?>"
                data-price="<?= $variations[1]->getPrice() * 100 ?>">
                <?= $variations[1]->getPriceText(true) ?>
            </h3>
            <div class="text-center mb20">
                <?= SwitchInput::widget([
                    'name' => 'variation',
                    'id' => 'register-variation',
                    'pluginOptions' => [
                        'handleWidth' => 60,
                        'offText' => $variations[0]->getCleanName(),
                        'onText' => $variations[1]->getCleanName()
                    ]
                ]) ?>
            </div>
            <?php } else { ?>
            <h3 class="text-center mb40 variation-0 variation-option"
                data-id="<?= $variations[0]->id ?>"
                data-name="<?= $variations[0]->name ?>"
                data-price-original="<?= $variations[0]->getPrice() * 100 ?>"
                data-price="<?= $variations[0]->getPrice() * 100 ?>">
                <?= $variations[0]->getPriceText(true) ?>
            </h3>
            <?php } ?>
            <p class="text-center lead mb40">
                <?= $plan->description ?>
            </p>
            <?= Messages::widget(['name' => 'registration']); ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6 col-md-offset-3">
            <?= Html::hiddenInput('tax_percent', Yii::$app->formatter->asDecimal(Yii::$app->params['gstTaxPercent'] / 100, 2), ['id' => 'tax_percent']) // FIXME: dynamic tax retrieval ?>
            <?= Html::hiddenInput('coupon_url', Url::toRoute(['/register/coupon']), ['id' => 'coupon_url']); ?>
            <?php $form = ActiveForm::begin([
                'id' => 'buy-form',
                'enableAjaxValidation' => true
            ]); ?>
            <?= $form->field($formModel, 'token', ['options' => ['class' => 'hidden']])->hiddenInput() ?>
            <?= $form->field($formModel, 'plan_variation_id', ['options' => ['class' => 'hidden']])->hiddenInput() ?>
            <?= $form->field($formModel, 'username') ?>
            <?= $form->field($formModel, 'email') ?>
            <?= $form->field($formModel, 'password')->passwordInput() ?>
            <?= $form->field($formModel, 'password_repeat')->passwordInput() ?>
            <?= $form->field($formModel, 'first_name') ?>
            <?= $form->field($formModel, 'last_name') ?>
            <?= $form->field($formModel, 'address') ?>
            <?php if (!isset($noCoupon) || !$noCoupon) { ?>
            <?= $form->field($formModel, 'coupon')->label('Coupon Code') ?>
            <?php } ?>
            <div class="form-group text-center">
                <?php
                echo Html::button($defaultVariation->getPrice() > 0 ? 'Buy' : 'Register', ['class' => 'btn btn-primary', 'id' => 'buy-button']);
                echo StripeCheckoutExtended::widget([
                    'id' => 'payInvoice' . $invoice->id,
                    'name' => 'Grandma\'s Jars',
                    'label' => 'Buy',
                    'description' => 'Pay for ' . $plan->name,
                    'amount' => new JsExpression('parseInt($(".variation-option:visible").attr("data-price")) + parseInt($(".variation-option:visible").attr("data-price")) * $("#tax_percent").val()'),
                    'currency' => Yii::$app->params['defaultChargeCurrency'],
                    'userEmail' => new JsExpression('$("#buy-form #register-email").val()'),
                    'image' => Url::to(['/imgs/jar.png']),
                    'buttonOptions' => [
                        'class' => 'btn btn-primary hidden',
                        'id' => 'stripe-buy'
                    ],
                    'tokenFunction' => new JsExpression("function(token) { submitFormWithToken(token); }"),
                    'openedFunction' => new JsExpression('function() {}'),
                    'closedFunction' => new JsExpression('function() {}')
                ]); ?>
            </div>

            <?php $this->registerJs(<<<JS
    var planPrice = (parseInt($(".variation-option:visible").attr("data-price")) / 100).toFixed(2);
    var dataLayer = window.dataLayer = window.dataLayer || [];
    dataLayer.push({
        trackEvent: 'Lead',
        salevalue: planPrice,
        saleCurrency: 'AUD'
    });
    
    function submitFormWithToken(token) {
        if (token.object == 'token') {
            $('.site-login').blockloader();
            $('#buy-form #register-token').val(token.id);
            $('#buy-form').submit();
        }
    }
    var clicked = false;
    $('body').on('switchChange.bootstrapSwitch', '#register-variation', function(e) {
        if ($(e.target).is(':checked')) {
            $('#register-plan_variation_id').val($('.variation-option.variation-1').data('id'));
            $('.variation-option').addClass('hidden');
            $('.variation-option.variation-1').removeClass('hidden');
        }
        else {
            $('#register-plan_variation_id').val($('.variation-option.variation-0').data('id'));
            $('.variation-option').addClass('hidden');
            $('.variation-option.variation-0').removeClass('hidden');
        }
    });
    $('body').on('click', '#buy-button', function() {
        $('#buy-form input:not(:hidden)').each(function() {
            $('#buy-form').yiiActiveForm('validateAttribute', $(this).attr('id'));
        });
        clicked = true;
        return false;
    });
    $('body').on('change', '#register-coupon', function() {
        $('#buy-button').attr('disabled', true);
        $.post(
            $('#coupon_url').val(),
            { id: $('#register-coupon').val() },
            function (data) {
                if (data.success) {
                    if (data.amount) {
                        $(".variation-option:visible").attr("data-price", $(".variation-option:visible").attr("data-price-original") - data.amount);
                    }
                    else {
                        $(".variation-option:visible").attr("data-price", $(".variation-option:visible").attr("data-price-original") -
                            $(".variation-option:visible").attr("data-price-original") * data.percent);
                    }
                }
                else {
                    $(".variation-option:visible").attr("data-price", $(".variation-option:visible").attr("data-price-original"));
                }
                $('#buy-button').attr('disabled', false);
            }, 'json'
        );
    });
    $('body').on('ajaxComplete', '#buy-form', function() {
        if ($(this).find('.has-error').length > 0) {
            $('#buy-form #register-token').val('');
            clicked = false;
            return false;
        }
        var empty = $('#buy-form .required input:not(:hidden)').filter(function() { return $(this).val() == '' });
        if (empty.length == 0 && clicked && $('#buy-form #register-token').val() == '') {
            clicked = false;
            var dataLayer = window.dataLayer = window.dataLayer || [];
            dataLayer.push({
                trackEvent: 'AddToCart',
                salevalue: planPrice,
                saleCurrency: 'AUD',
                saleContentIds: [$(".price-option.selected").attr("data-id")],
                saleContentType: $(".price-option.selected").attr("data-name")
            });
            $('#stripe-buy').trigger('click');
        }
        return false;
    });
JS
            ); ?>
            <?php ActiveForm::end(); ?>
        </div>
    </div>
</div>
