<?php
use yii\helpers\Url;
use backend\components\helpers\Formatter;
?>

<nav id="secondary-side-bar" class="navmenu navmenu-default navmenu-fixed-left reports-side-bar contracted" role="navigation">
    <div id="seconday-side-bar-header">
        <button id="mobile-nav-toggle-reports" type="button">
            <span class="glyphicon glyphicon-chevron-right submenu-open"></span>
            <span class="glyphicon glyphicon-chevron-left submenu-close"></span>
        </button>
        <h2>Reports</h2>
    </div>
    <ul id="secondary-side-bar-nav" class="nav navmenu-nav panel-group reports" role="tablist" aria-multiselectable="true">
        <?php foreach ($reports as $key => $r) {
            $active = (isset($reportId) && ($r->id == $reportId)) ? ' class="active"' : '';
            ?>
            <li data-report-id="<?= $r->id ?>"<?= $active; ?>>
                <a href="<?= $r->link ?>" title="<?= $r->name ?>">
                    <div class="info color-<?= $key ?>">
                        <h4 class="clearfix">
                            <i class="glyphicon glyphicon-<?= $r->icon ?>"></i>
                            <div class="name"><?= $r->name ?></div>
                        </h4>
                        <div class="description"><?= $r->desc ?></div>
                    </div>
                </a>
            </li>
        <?php } ?>
    </ul>
</nav>
