<?php
use yii\helpers\Html;
use yii\helpers\Url;
use backend\widgets\FormattedTitle;
use backend\components\helpers\Formatter;
use yii\bootstrap\ButtonDropdown;
use backend\widgets\VideoTutorial;
?>
<div id="body" class="container-fluid secondary-nav" data-js-callback="reportDetailLoaded" data-report-id="<?= $reportId ?>" data-select-menu="li#mainnav-reports" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>">
    <?= VideoTutorial::widget() ?>
    <div class="row">
        <div class="col-md-12">
            <div class="col-head">
                <h3><?= $this->title ?></h3>
                <?= ButtonDropdown::widget([
                    'label' => $year,
                    'dropdown' => [
                        'items' => $years,
                    ]
                ]); ?>
                <?= ButtonDropdown::widget([
                    'label' => $optionName,
                    'dropdown' => [
                        'items' => $options,
                    ]
                ]); ?>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-3">
            <div class="item-value">
                <div class="value"><?= $totalBudgeted ? Formatter::currency($totalBudgeted) : '-'; ?></div>
                <div class="desc">Total Amount Budgeted</div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="item-value">
                <div class="value"><?= $totalSpent ? Formatter::currency($totalSpent) : '-'; ?></div>
                <div class="desc">Total Amount Spent</div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="item-value">
                <div class="value"><?= $balance ? Formatter::currency($balance) : '-'; ?></div>
                <div class="desc">Resulting Balance</div>
            </div>
        </div>
        <div class="col-md-3 text-right">
            <a href="javascript:window.print()" target="_blank" class="btn btn-primary"><i class="glyphicon glyphicon-print"></i> Print Report</a>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-table transactions-panel">
                 <?php
                    if (!$optionId) {

                        echo $this->render('/transactions/_transactions-totals-for-budget-with-planned-graph.php', [
                            'year' => $year,
                        ]);

                    }
                    elseif ($optionId == 1) {

                        echo $this->render('/transactions/_transactions-totals-for-budget-by-jar-chart.php', [
                            'year' => $year,
                        ]);

                    }
                ?>
            </div>
        </div>
    </div>

    <?= $this->render('/layouts/_footer') ?>

</div>


