<?php
use yii\helpers\Html;
use yii\bootstrap\ActiveForm;
use backend\widgets\Messages;

/* @var $this yii\web\View */
/* @var $form yii\bootstrap\ActiveForm */
/* @var $model \common\models\LoginForm */

$this->params['breadcrumbs'][] = $this->title;

?>
<div class="site-login">
    <div class="row">
        <div class="col-md-4 col-md-offset-4 text-center">
            <h1><?= Html::encode($this->title) ?></h1>
            <p>Please fill out the following fields to log in</p>
        </div>
    </div>

    <?= Messages::widget(['name' => 'login']); ?>

    <div class="row">
        <div class="col-md-4 col-md-offset-4">
            <?php $form = ActiveForm::begin(['id' => 'login-form']); ?>
                <?= $form->field($formModel, 'username') ?>
                <?= $form->field($formModel, 'password')->passwordInput() ?>
                <a href="/site/forgotten-password" class="reset-password-link pull-left">Forgot your password?</a>
                <?= $form->field($formModel, 'rememberMe')->checkbox(['template' => "<div class=\"checkbox\">\n{input}\n{label}\n{error}\n{hint}\n</div>"]) ?>
                <div class="form-group text-center">
                    <?= Html::submitButton('Login', ['class' => 'btn btn-primary', 'name' => 'login-button']) ?>
                </div>
            <?php ActiveForm::end(); ?>

            <hr style="margin: 10px 0 15px" />

            <p class="text-center">
                Don't have acccount? <a href="/register"><strong>Sign up</strong></a>
            </p>
        </div>
    </div>
</div>
