<?php
use common\models\form\ResetPassword;
use yii\helpers\Html;
use yii\bootstrap\ActiveForm;
use backend\widgets\Messages;

/* @var $this yii\web\View */
/* @var $form yii\bootstrap\ActiveForm */
/* @var $model ResetPassword */

$this->params['breadcrumbs'][] = $title;
?>
<div class="site-login">
    <h1><?= Html::encode($title) ?></h1>

    <?php if ($isSetup) { ?>
        <p>Please fill out the following fields to finish setting up your GMJS account:</p>
    <?php } else { ?>
        <p>Please fill out the following fields to reset your password:</p>
    <?php } ?>

    <?= Messages::widget(['name' => 'reset-password']); ?>

    <?php $form = ActiveForm::begin(['id' => 'reset-password-form']); ?>
    <div class="row">
        <div class="col-lg-5">
            <?php if (!$uniqueEmail) { ?>
                <?= $form->field($formModel, 'email')->textInput() ?>
            <?php } ?>
            <?php if ($isSetup) { ?>
                <?= $form->field($formModel, 'username')->textInput() ?>
            <?php } ?>
            <?= $form->field($formModel, 'password')->passwordInput() ?>
            <?= $form->field($formModel, 'passwordConfirm')->passwordInput() ?>
            <div class="form-group">
                <?= Html::submitButton($isSetup ? 'Save' : 'Reset', ['class' => 'btn btn-primary', 'name' => 'login-button']) ?>
            </div>
        </div>
    </div>
    <?php ActiveForm::end(); ?>
</div>
