<?php
use backend\components\helpers\Subscription;
use backend\widgets\Tooltip;

/** @var \backend\models\db\UserPlan $userPlan */
?>

<table class="plans plan-current">
    <?php if ($userPlan):
        $oneOff = isset($userPlan->userPlanVariation) && empty($userPlan->userPlanVariation->stripe_plan_id) ?
            round($userPlan->userPlanVariation->price, 2) : null;
        $perMonth = isset($userPlan->userPlanVariation) ? $userPlan->userPlanVariation->getPricePerMonth() : null;
        $start = date('Y-m-d', strtotime($userPlan->start_time));
        $end = date('Y-m-d', $userPlan->getExpirationTime());
        $foreverPlan = empty($userPlan->userPlanVariation->plan_length); ?>
        <thead>
        <tr>
            <th>
                <div class="col-head">
                    <h3>Subscription</h3>
                </div>
            </th>
        </tr>
        <tr>
            <th class="plan-type plan0">
                <?= isset($userPlan->userPlanVariation) ? $userPlan->userPlanVariation->name : $userPlan->userPlanType->name ?>
                <?= Tooltip::widget(['text' => 'Info about ' . $userPlan->userPlanType->name . ' plan']) ?>
            </th>
        </tr>
        <tr>
            <?php if ($oneOff) { ?>
            <th class="price plan0"><?= '$' . $oneOff ?></th>
            <?php } else { ?>
            <th class="price plan0"><?= $perMonth ? '$' . $perMonth . ($perMonth > 0 ? '<span>per month</span>' : '') : '-' ?></th>
            <?php } ?>
        </tr>
        </thead>
        <tbody>
        <tr>
            <td>
                <div class="row info">
                    <div class="col-xs-5">Start Date</div>
                    <div class="col-xs-7"><?= $userPlan->getFormattedStartDate() ?></div>
                </div>
                <?php if (!$foreverPlan) { ?>
                <div class="row info">
                    <div class="col-xs-5">End Date</div>
                    <div class="col-xs-7"><?= $end <= $start ? '<em>pending...</em>' : $userPlan->getFormattedExpirationDate() ?></div>
                </div>
                <?php $daysLeft = $userPlan->getDaysLeft(); ?>
                <div class="progress static-popover"
                     data-content="<?= $daysLeft ?> Day<?= $daysLeft > 1 ? 's' : '' ?> Left"
                     data-placement="top" data-toggle="popover">
                    <div class="progress-bar progress-bar-success" role="progressbar"
                         aria-valuenow="<?= $userPlan->getPercentageCompleted(); ?>" aria-valuemin="0" aria-valuemax="100"
                         style="width: <?= $userPlan->getPercentageCompleted(); ?>%">
                    </div>
                </div>
                <?php } ?>
                <?php if (!empty((float)$userPlan->userPlanVariation->price)) { ?>
                <div>
                    <?= Subscription::getSubscriptionActionInfo($userPlan) ?>
                </div>
                <?php } ?>
            </td>
        </tr>
        </tbody>
        <tfoot>
        <tr>
            <td></td>
        </tr>
        </tfoot>
    <?php else: ?>
        <thead>
        <tr>
            <th>
                <div class="col-head">
                    <h3>Subscription</h3>
                </div>
            </th>
        </tr>
        <tr>
            <th class="plan-type plan0">
                No subscription selected
            </th>
        </tr>
        </thead>
        <tfoot>
        <tr><td></td></tr>
        </tfoot>
    <?php endif; ?>
</table>
