<?php
use yii\helpers\Html;
use yii\helpers\Url;
use yii\bootstrap\ActiveForm;
use backend\components\helpers\JsTools;
?>

<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h4 class="modal-title" id="myModalLabel"><?= Html::encode($this->title) ?></h4>
</div>
<?php $form = ActiveForm::begin(['id' => 'cancel-subscription-form']); ?>
<div class="modal-body">
    <p>
        Are you sure you want to cancel your Grandma's Jars Subscription?<br/>
        Click Yes to stop using Grandma's Jars, click No to go back to the Subscriptions page
    </p>
</div>
<div class="modal-footer">
    <?= Html::submitButton('No', ['class' => 'btn btn-default close-modal', 'data-dismiss' => 'modal']) ?>
    <?= Html::submitButton('Yes', ['class' => 'btn btn-primary ajax-submit', 'data-js-callback' => JsTools::jsCallback($this, 'reloadPage'), 'data-submit-url' => Url::toRoute(['/subscription/cancel', 'confirm' => '1'])]) ?>
</div>
<?php ActiveForm::end(); ?>
