<?php
use yii\helpers\Html;
use yii\helpers\Url;
use backend\widgets\FormattedTitle;
use backend\components\helpers\Frequencies;
use backend\components\helpers\Formatter;
?>

<div id="body" class="container-fluid" data-js-callback="subscriptionLoaded" data-select-menu="li#dashboard-nav" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>">
    <div class="row">
        <div class="col-sm-3">
            <table class="plans plan-current">
                <thead>
                <tr>
                    <th>
                        <div class="col-head">
                            <h3>Subscription</h3>
                        </div>
                    </th>
                </tr>
                <tr>
                    <th class="plan-type plan0">Basic <a href="#" class="pull-right"><i class="ico ico-info"></i></a></th>
                </tr>
                <tr>
                    <th class="price plan0">$9.95<span>per month</span></th>
                </tr>
                </thead>
                <tbody>
                <tr>
                    <td>
                        <div class="row info">
                            <div class="col-xs-5">Start Date</div>
                            <div class="col-xs-7">3<sup>rd</sup> January 2014</div>
                        </div>
                        <div class="row info">
                            <div class="col-xs-5">Next Bill</div>
                            <div class="col-xs-7">3<sup>rd</sup> June 2014</div>
                        </div>
                        <div class="progress">
                            <div class="progress-bar progress-bar-success static-popover" role="progressbar" aria-valuenow="20" aria-valuemin="0" aria-valuemax="100" title="" data-content="5 Days" data-placement="top" data-toggle="popover" data-original-title="" style="width: 20%">
                            </div>
                        </div>
                        <div>
                            <a href="#" class="btn btn-danger">Cancel Subscription</a>
                        </div>
                    </td>
                </tr>
                </tbody>
                <tfoot>
                <tr>
                    <td></td>
                </tr>
                </tfoot>
            </table>
        </div>
        <div class="col-sm-9">
            <table class="plans">
                <thead>
                <tr>
                    <th class="col-legend"></th>
                    <th colspan="4">
                        <div class="col-head">
                            <h3>Available Plans</h3>
                        </div>
                    </th>
                </tr>
                <tr>
                    <th class="col-legend"></th>
                    <th class="plan-type plan1">Basic</th>
                    <th class="plan-type plan2">Kickstarter</th>
                    <th class="plan-type plan3">Budget Boot Camp</th>
                    <th class="plan-type plan4">Maintenance</th>
                </tr>
                <tr>
                    <th class="col-legend">Features</th>
                    <th class="price">$9.95<span>per month</span></th>
                    <th class="price">$299<span>3 months</span></th>
                    <th class="price">$95<span>per month</span></th>
                    <th class="price">$40<span>per month</span></th>
                </tr>
                </thead>
                <tbody>
                <tr>
                    <td class="col-legend">Web &amp; Mobile Apps</td>
                    <td><i class="ico ico-check plan1"></i></td>
                    <td><i class="ico ico-check plan2"></i></td>
                    <td><i class="ico ico-check plan3"></i></td>
                    <td><i class="ico ico-check plan4"></i></td>
                </tr>
                <tr>
                    <td class="col-legend">Live Webinars</td>
                    <td><i class="ico ico-check plan1"></i></td>
                    <td><i class="ico ico-check plan2"></i></td>
                    <td><i class="ico ico-check plan3"></i></td>
                    <td><i class="ico ico-check plan4"></i></td>
                </tr>
                <tr>
                    <td class="col-legend">G-Jars Community Forum</td>
                    <td><i class="ico ico-check plan1"></i></td>
                    <td><i class="ico ico-check plan2"></i></td>
                    <td><i class="ico ico-check plan3"></i></td>
                    <td><i class="ico ico-check plan4"></i></td>
                </tr>
                <tr>
                    <td class="col-legend">Tutorials &amp; Articles</td>
                    <td><i class="ico ico-check plan1"></i></td>
                    <td><i class="ico ico-check plan2"></i></td>
                    <td><i class="ico ico-check plan3"></i></td>
                    <td><i class="ico ico-check plan4"></i></td>
                </tr>
                <tr>
                    <td class="col-legend">Plan Length</td>
                    <td>Ongoing</td>
                    <td>3 Months</td>
                    <td>12 Months</td>
                    <td>Ongoing</td>
                </tr>
                <tr>
                    <td class="col-legend">Live Coaching &amp; Reminders</td>
                    <td><i class="ico ico-check"></i></td>
                    <td>4</td>
                    <td>12</td>
                    <td>4 per year</td>
                </tr>
                <tr>
                    <td class="col-legend">Email Coaching &amp; Reminders</td>
                    <td><i class="ico ico-check"></i></td>
                    <td>As needed</td>
                    <td>As needed</td>
                    <td>As needed</td>
                </tr>
                <tr>
                    <td class="col-legend">Money-Back Guarantee</td>
                    <td><i class="ico ico-check"></i></td>
                    <td><i class="ico ico-check"></i></td>
                    <td><i class="ico ico-check plan3"></i></td>
                    <td><i class="ico ico-check"></i></td>
                </tr>
                </tbody>
                <tfoot>
                <tr>
                    <td class="col-legend"></td>
                    <td class="plan1"><a href="#" class="btn btn-sm">CURRENT</a> <a href="#"><i class="ico ico-info plan1"></i></a></td>
                    <td class="plan2"><a href="#" class="btn btn-sm">UPGRADE</a> <a href="#"><i class="ico ico-info plan2"></i></a></td>
                    <td class="plan3"><a href="#" class="btn btn-sm">UPGRADE</a> <a href="#"><i class="ico ico-info plan3"></i></a></td>
                    <td class="plan4"><a href="#" class="btn btn-sm">UPGRADE</a> <a href="#"><i class="ico ico-info plan4"></i></a></td>
                </tr>
                </tfoot>
            </table>

        </div>
    </div>

    <?= $this->render('/layouts/_footer') ?>

</div>


