<?php
use backend\models\db\UserPlan;
use yii\helpers\Html;
use yii\helpers\Url;

/* @var $planFeatures array with features generals to all plans */
/* @var $plansDetails array with details (features) of each plan */
/* @var $userPlan UserPlan model of last plan of User */
?>
<div id="body" class="container-fluid subscription-page" data-js-callback="subscriptionLoaded" data-select-menu="li#dashboard-nav" data-page-title="<?= 
\backend\widgets\FormattedTitle::widget(['title' => $this->title]); ?>">

    <?php $conquerPlan = false;
    if ($userPlan &&
        ($userPlan->userPlanType->getPlanType() == \backend\models\db\UserPlanType::PLAN_TYPE_DISCOUNT_CONQUER_YOUR_CC ||
            $userPlan->userPlanType->getPlanType() == \backend\models\db\UserPlanType::PLAN_TYPE_CONQUER_YOUR_CC)) {
        $conquerPlan = true; ?>
    <div class="row" style="margin:-20px 0 40px">
        <div class="app-warning">
            <p class="text-center">
                <strong>You are currently on the Conquer Your Credit Card Course plan. You can switch to another plan after your current plan expires.</strong>
                <br/><br/>
                To request a special upgrade or ask for more information, email us at:<br/>
                <a href="mailto:team@grandmasjars.com">team@grandmasjars.com</a>
            </p>
        </div>
    </div>
    <?php } ?>

    <div class="row">
        <?php if ($userPlan) { ?>
        <div class="col-md-3">
            <?= $this->render('_current-plan', [
                'userPlan' => $userPlan
            ]); ?>

            <script src="https://checkout.stripe.com/checkout.js"></script>
            <?php if ($card) { ?>
            <hr/>
            <div class="text-center card-info">
                <small>Current Card on File</small>
                <p><strong><?= $card->brand ?></strong> ending in <strong><?= $card->last4 ?></strong></p>
            </div>
            <div class="text-center mt20">
                <button id="update-cc" class="btn btn-primary">Update Card Details</button>
            </div>
            <script>
                var updateHandler = StripeCheckout.configure({
                    key: '<?= Yii::$app->stripe->publicKey ?>',
                    email: '<?= Yii::$app->user->identity->email ?>',
                    panelLabel: 'Update Card Details',
                    allowRememberMe: false,
                    locale: 'auto',
                    token: function(token, args) {
                        showLoadingAfterPayment();
                        $.post('<?= $updateCardUrl ?>?token=' + token.id)
                            .done(function(data){
                                if (data.status == 'error') {
                                    hideLoadingAfterPayment();
                                    topScreenNotification(data.message, 'error');
                                }
                                else {
                                    window.location.replace('/subscription/index');
                                }
                            });
                    }
                });
                document.getElementById('update-cc').addEventListener('click', function(e) {
                    // Open Checkout with further options:
                    updateHandler.open({
                        name: 'Grandma\'s Jars'
                    });
                    e.preventDefault();
                });

                // Close Checkout on page navigation:
                window.addEventListener('popstate', function() {
                    updateHandler.close();
                });
            </script>
            <?php } ?>
        </div>
        <?php } ?>
        <?= $this->render('_available-plans', [
            'plansDetails' => $plansDetails,
            'planFeatures' => $planFeatures,
            'userPlan' => $userPlan,
            'conquerPlan' => $conquerPlan
        ]); ?>
    </div>
    <?php if(count($invoices) > 0): ?>
    <div class="col-head margin-top-20">
        <h3>Invoices</h3>
    </div>
    <div class="panel panel-tabbed">
        <div class="tabpanel tabpanel-secondary">
            <div class="container-fluid">
                <div class="row no-gutter">
                    <div class="col-lg-6 no-float tab-col">
                        <!-- Nav tabs -->
                        <ul class="nav nav-tabs" role="tablist">
                            <?php foreach ($invoices as $i => $invoice) :?>
                                <li role="presentation"<?= $i == 0 ? ' class="active"' : '' ?>>
                                    <a href="#invoice_<?= $invoice->id ?>" role="tab" data-toggle="tab">
                                        #<?= $invoice->id ?> - <?= Yii::$app->formatter->asDate($invoice->bill_date, 'long') ?>
                                        <?php if (!$invoice->isPaid) { ?>
                                        <span class="text-danger small pull-right">UNPAID</span>
                                        <?php } ?>
                                    </a>
                                </li>
                            <?php endforeach ?>
                        </ul>
                    </div>
                    <div class="col-lg-6 no-float">
                        <!-- Tab panes -->
                        <div class="tab-content">
                            <?php foreach ($invoices as $i => $invoice) :?>
                                <div role="tabpanel" class="tab-pane<?= $i == 0 ? ' active' : '' ?>" id="invoice_<?= $invoice->id ?>">
                                    <div class="invoice">
                                        <div class="row">
                                            <div class="col-sm-9">
                                                <img src="<?= Url::to(['/imgs/logo-dark.svg'])?>" alt="Grandma's Jars" />
                                            </div>
                                            <div class="col-sm-3">
                                                <p>Bill to:<br/>
                                                    <?= $invoice->bill_name ?>
                                                </p>
                                            </div>
                                        </div>
                                        <div class="row mt20">
                                            <div class="col-sm-3">
                                                <p>
                                                    PO Box 4002<br/>
                                                    Hawker<br/>
                                                    2614, ACT<br/>
                                                    Australia
                                                </p>
                                            </div>
                                            <div class="col-sm-6">
                                                <p>Bill Date:<br/>
                                                    <?= Yii::$app->formatter->asDate($invoice->bill_date) ?>
                                                </p>
                                                <p>Invoice Number:<br/>
                                                    #<?= $invoice->id ?>
                                                </p>
                                            </div>
                                            <div class="col-sm-3">
                                                <p>
                                                    <?= implode('<br/>', $invoice->getAddressLines(true)) ?>
                                                </p>
                                            </div>
                                        </div>
                                        <table class="table mt20">
                                            <thead>
                                            <tr>
                                                <th>Date</th>
                                                <th>Description</th>
                                                <th>Amount</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php foreach ($invoice->invoiceItems as $item) :?>
                                                <tr>
                                                    <td>
                                                        <?= Yii::$app->formatter->asDate($item->date_start) ?> -
                                                        <?= Yii::$app->formatter->asDate($item->date_end) ?>
                                                    </td>
                                                    <td><?= $item->description ?></td>
                                                    <td><?= Yii::$app->formatter->asCurrency($item->amount) ?></td>
                                                </tr>
                                            <?php endforeach ?>
                                            </tbody>
                                            <tfoot>
                                            <?php if (!empty($invoice->percent_off)) { ?>
                                            <tr>
                                                <td colspan="2">Discount Percent</td>
                                                <td><?= Yii::$app->formatter->asDecimal($invoice->percent_off, 1) ?>%</td>
                                            </tr>
                                            <?php } ?>
                                            <?php if (!empty($invoice->amount_off)) { ?>
                                            <tr>
                                                <td colspan="2">Discount Amount</td>
                                                <td><?= Yii::$app->formatter->asCurrency(-1 * $invoice->amount_off) ?></td>
                                            </tr>
                                            <?php } ?>
                                            <?php if (!empty($invoice->tax)) { ?>
                                            <tr>
                                                <td colspan="2">Tax<?= $invoice->tax_percent ? ' ('.Yii::$app->formatter->asDecimal($invoice->tax_percent, 1).'%)' : '' ?></td>
                                                <td><?= Yii::$app->formatter->asCurrency($invoice->tax) ?></td>
                                            </tr>
                                            <?php } ?>
                                            <tr>
                                                <td colspan="2">Total</td>
                                                <td><?= Yii::$app->formatter->asCurrency($invoice->total) ?></td>
                                            </tr>
                                            </tfoot>
                                        </table>
                                        <?php
                                        /*if (!$invoice->isPaid) {
                                            echo StripeCheckoutCustom::widget([
                                                'id' => 'payInvoice' . $invoice->id,
                                                'name' => 'Grandma\'s Jars',
                                                'label' => 'Pay This Invoice',
                                                'description' => 'Pay for Invoice #' . $invoice->id . ' (' . $userPlan->userPlanType->name . ')',
                                                'amount' => $invoice->total * 100, // Because Stripe amount must be set in cents: https://stripe.com/docs/checkout#integration-custom
                                                'currency' => Yii::$app->params['defaultChargeCurrency'],
                                                'userEmail' => Yii::$app->user->identity->email,
                                                'image' => Url::to(['/imgs/jar.svg']),
                                                'buttonOptions' => [
                                                    'class' => 'btn btn-success pull-left',
                                                ],
                                                'tokenFunction' => new JsExpression("function(token){processToken({$userPlan->user_plan_type_id}, token, {$invoice->id})}"),
                                                'openedFunction' => new JsExpression('function() {console.log("Modal opened");}'),
                                                'closedFunction' => new JsExpression('function() {console.log("Modal closed");}'),
                                            ]);
                                        }
                                        else {*/
                                            echo Html::a(
                                                'Print receipt',
                                                Url::to(['subscription/print-receipt', 'invoice' => $invoice->id]),
                                                ['class' => 'btn btn-info pull-right skip-history ml', 'target' => '_blank']
                                            );
                                        //} ?>
                                        <?= Html::a(
                                            'Print invoice',
                                            Url::to(['subscription/print-invoice', 'invoice' => $invoice->id]),
                                            ['class' => 'btn btn-info pull-right skip-history', 'target' => '_blank']
                                        ) ?>
                                        <div class="clear"></div>
                                    </div>
                                </div>
                            <?php endforeach ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif ?>

    <?= $this->render('/layouts/_footer') ?>

</div>
<?= \backend\components\helpers\JsTools::viewJs($this)?>

