<?php

use backend\components\helpers\JsTools;
use yii\helpers\Html;
use yii\bootstrap\ActiveForm;
use yii\helpers\Url;

/**
 * @var yii\web\View $this
 * @var backend\models\db\Bugs $model
 * @var yii\widgets\ActiveForm $form
 */
$this->title = 'Give Feedback';
?>
<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h4 class="modal-title" id="myModalLabel"><?= Html::encode($this->title) ?></h4>
</div>
<?php $form = ActiveForm::begin([
    'id' => 'Bugs',
    'layout' => 'horizontal',
    'enableClientValidation' => true,
    'errorSummaryCssClass' => 'error-summary alert alert-error',
]); ?>
<div class="modal-body">
    <div class="message"></div>
    <p>
        <?= $form->field($model, 'content')->textarea(['rows' => 6]) ?>
        <?= $form->field($model, 'url')->textInput(['maxlength' => true]) ?>
    </p>
</div>
<div class="modal-footer">
    <?= Html::submitButton('Close', ['class' => 'btn btn-default close-modal', 'data-dismiss' => 'modal']) ?>
    <?= Html::submitButton(($model->isNewRecord ? 'Create' : 'Save'), [
        'class' => 'btn btn-primary ajax-submit',
        'data' => [
            'js-callback' => 'closeModal',
            'submit-url' => Url::toRoute(['bugs']),
        ]
    ]) ?>
</div>
<?php ActiveForm::end(); ?>
<?= JsTools::viewJs($this); ?>
