<?php
use yii\helpers\Url;
use backend\components\helpers\Formatter;
?>

<table id="t-table-1" class="table table-paginated table-bordered data-table" data-table-id="t-table-1" data-ajax="<?= Url::toRoute([
        '/transactions/jar-transactions-table',
        'jar_id' => $jar->id,
        'year' => isset($year) ? $year : false,
        'month' => isset($month) ? $month : false
    ]) ?>" data-ajax-footer="<?= Url::toRoute([
        '/transactions/jar-transactions-table-footer',
        'jar_id' => $jar->id,
        'year' => isset($year) ? $year : false,
        'month' => isset($month) ? $month : false
    ]) ?>" data-footer-column="<?= $allowEdit ? 5 : 4 ?>">
    <thead>
        <tr>
            <th class="sort-by sort-desc">Date</th>
            <th>Name</th>
            <th>Description</th>
            <th>Amount</th>
            <th>Account</th>
            <?php if ($allowEdit) { ?>
            <th class="no-sort"></th>
            <?php } ?>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td colspan="<?= ($allowEdit) ? 6 : 5; ?>">No transactions yet.</td>
        </tr>
    </tbody>
    <tfoot>
        <tr>
            <td colspan="<?= ($allowEdit) ? 5 : 4; ?>">Total Transactions</td>
            <td class="this-months-jar-transactions-amount"></td>
        </tr>
    </tfoot>
</table>

