<?php
use yii\helpers\Html;
use yii\helpers\Url;
use yii\bootstrap\ActiveForm;
use backend\components\helpers\JsTools;
use backend\components\helpers\Formatter;
?>

<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <div class='modal-tabs'>
        <div class='modal-tab open-modal' data-modal-url='/transactions/add-es-transaction'>Spent Money</div>
        <div class='modal-tab open-modal' data-modal-url='/incomes/add-onetime-income'>Received Money</div>
        <div class='modal-tab active'>Transfered Money</div>
    </div>
</div>
<?php $form = ActiveForm::begin(['id' => 'add-onetime-transfer-form']); ?>
<div class="modal-body">
    <div class="message"></div>

    <?= $form->field($formModel, 'date')->widget(\dosamigos\datetimepicker\DateTimePicker::className(), [
        'template' => '{input}{button}',
        'pickButtonIcon' => 'glyphicon glyphicon-calendar',
        'clientOptions' => [
            'format' => Formatter::phpDateCodeToDatepickerCode(Yii::$app->session->get('dateFormat')),
            'minView' => 'month',
            'maxView' => 'year',
            'autoclose' => true
        ]
    ])->label('When did you transfer the money?') ?>

    <?= $form->field($formModel, 'name')->label('Description') ?>

    <?= $form->field($formModel, 'amount', [
        'inputOptions' => [
            'value' => Formatter::currency($formModel->amount, 'none')
        ]
    ])->label('How much did you transfer?') ?>

    <?=
    $form->field($formModel, 'account_from_id')->dropDownList($accounts, [
        'prompt' => 'Select one'
    ])->label('Account you transfered from');
    ?>

    <?=
    $form->field($formModel, 'account_to_id')->dropDownList($accounts, [
        'prompt' => 'Select one'
    ])->label('Account you transfered to');
    ?>

</div>
<div class="modal-footer">

    <?= Html::submitButton('Close', ['class' => 'btn btn-default close-modal', 'data-dismiss' => 'modal']) ?>
    <?= Html::submitButton('Add Transfer', ['class' => 'btn btn-primary ajax-submit', 'data-js-callback' => 'reloadMoneyOperationsTable', 'data-submit-url' => Url::toRoute('/transfers/add-onetime-transfer')]) ?>

</div>
<?php ActiveForm::end(); ?>
<?= JsTools::viewJs($this); ?>
