<?php
use yii\helpers\Html;
use yii\helpers\Url;
use backend\widgets\FormattedTitle;
use backend\components\helpers\Frequencies;
use backend\components\helpers\Formatter;
?>

<div role="tabpanel" class="tab-pane active" id="title1" data-js-callback="transferDetailLoaded" data-select-menu="li#my-financials-transfers" data-transfer-id="<?= $transfer->id ?>" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>">
    <div class="col-head">
        <h3><?= $transfer->name ?></h3>
        <a href="#" class="open-modal" data-modal-url="<?= Url::toRoute(['/transfers/edit-transfer', 'id' => $transfer->id]) ?>"><i class="glyphicon glyphicon-pencil gi-2x"></i></a>
        <a href="#" class="open-modal" data-modal-url="<?= Url::toRoute(['/transfers/remove-transfer', 'id' => $transfer->id]) ?>"><i class="glyphicon glyphicon-trash gi-2x"></i></a>
    </div>
    <div class="row">
        <div class="col-sm-6">
            <div class="label-group">
                <label for="frequency">Frequency</label>
                <div class="label-value">
                    <?= Frequencies::getLabel($transfer->frequency) ?>
                </div>
                <div class="label-group">
                    <label for="payday" class="control-label">Next Transfer Date</label>
                    <div class="label-value">
                        <?=  Formatter::date($transfer->getNextDue()); ?>
                    </div>
                </div>
                <div class="label-group">
                    <label for="">Amount</label>
                    <div class="label-value">
                        <?= Formatter::currency($transfer->amount) ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-6">
        </div>
    </div>
</div>
