<?php
use yii\bootstrap\ButtonDropdown;
use yii\helpers\Html;
use yii\helpers\Url;
use backend\widgets\FormattedTitle;
use backend\components\helpers\Frequencies;
use backend\components\helpers\Formatter;
use backend\widgets\VideoTutorial;
?>

<div id="body" class="container-fluid" data-js-callback="transferDetailLoaded" data-select-menu="li#my-financials-transfers" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>">
    <?= VideoTutorial::widget(['type' => 'transfers']) ?>
    <div class="row transfer-detail-headline" data-target-selector=".transfer-detail-headline"<?php if (!$this->params['pageLoadRequest'] && !$fullLoad) { ?> data-partial-load="1"<?php } ?>>
        <div class="col-md-12">
            <div class="col-head">
                <h2>Transfer</h2>
                <a class="btn btn-primary btn-sm open-modal" data-modal-url="<?= Url::toRoute('/transfers/add-transfer') ?>"><i class="glyphicon glyphicon-plus"></i> Add</a>
            </div>

            <div class="panel panel-tabbed">
                <div class="tabpanel tabpanel-secondary">
                    <div class="container-fluid">
                        <div class="row no-gutter transfer-row">
                            <div class="col-lg-6 no-float tab-col">
                                <!-- Nav tabs -->
                                <?= $this->render('_transfers-list', [
                                    'transfer' => $transfer,
                                    'transfers' => $transfers,
                                    'title' => ($allowEdit) ? 'My Transfers' : 'Deleted Transfers',
                                    'allowEdit' => $allowEdit
                                ]); ?>
                            </div>
                            <div class="col-lg-6 no-float">
                                <!-- Tab panes -->
                                <div class="tab-content body-content transfer-container" data-block-loading="true">
                                    <?= $this->render('transfer-detail-content', [
                                        'transfers' => $transfers,
                                        'transfer' => $transfer,
                                        'allowEdit' => $allowEdit,
                                    ]); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-4">
            <div class="col-head">
                <h4>Transfers that have occurred</h4>
            </div>
        </div>
        <div class="col-sm-3">
            <?= ButtonDropdown::widget([
                'label' => $year,
                'dropdown' => [
                    'items' => $years,
                ]
            ]); ?>
            <?= ButtonDropdown::widget([
                'label' => $monthName,
                'dropdown' => [
                    'items' => $months,
                ]
            ]); ?>
        </div>
        <div class="col-sm-5">
            <div class="input-group">
                <input type="text" class="form-control table-search" data-search-id="tf-table-1">
                <span class="input-group-addon">
                    <span class="glyphicon glyphicon-search"></span>
                </span>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-table">
                <?=  $this->render('/transfer-events/_transfer-events-table-no-accounts', [
                    'allowEdit' => $allowEdit,
                    'year' => $year,
                    'month' => $month
                ]);  ?>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-7">
            <div class="col-head">
                <h4>Scheduled Transfers</h4>
            </div>
        </div>

        <div class="col-sm-5">
            <div class="input-group">
                <input type="text" class="form-control table-search" data-search-id="t-table-1">
                <span class="input-group-addon">
                    <span class="glyphicon glyphicon-search"></span>
                </span>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-table">
                <?= $this->render('_transfers-table-full', [
                    'jsCallbackPause' => 'reloadTransfersAfterPause',
                    'allowEdit' => $allowEdit
                ]); ?>
            </div>
        </div>
    </div>

    <?= $this->render('/layouts/_footer') ?>

</div>


