<?php
use yii\helpers\Html;
use yii\helpers\Url;
use backend\widgets\FormattedTitle;
use yii\bootstrap\ActiveForm;
use backend\components\helpers\Frequencies;
use backend\components\helpers\Formatter;
use backend\components\helpers\JsTools;

?>

<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h4 class="modal-title" id="myModalLabel"><?= Html::encode($this->title) ?></h4>
</div>
<?php $form = ActiveForm::begin([
    'id'          => 'edit-user-form',
    'options'     => ['enctype' => 'multipart/form-data'],
    'fieldConfig' => [
        'inlineRadioListTemplate' => "<div class=\"radio-group-inline\">{input}\n{label}\n{hint}\n</div>",
    ]
]); ?>
<div class="modal-body">

    <div class="message"></div>

    <?php if ($noBasicInfo) { ?>
    <div class="alert alert-warning">
        Please provide your profile details which are necessary for the invoice (name, surname, address).
    </div>
    <?php } ?>

    <div class="basic-details"<?= $noBasicInfo ? ' style="display: none"' : '' ?>>
        <div class="row">
            <div class="col-sm-12">
                <?= $form->field($formModel, 'username') ?>
            </div>
        </div>
        <div class="row form-group-pair">
            <div class="col-sm-9">
                <?= $form->field($formModel, 'email') ?>
            </div>

            <div class="col-sm-3">
                <?= $form->field($formModel, 'email_visible')->inline(true)->radioList([
                    1 => 'Show',
                    0 => 'Hide'
                ],
                [
                    'item' => '\backend\widgets\RadiolistInlineTemplate::populateWidget'
                ])->label(false); ?>
            </div>
        </div>
        <?= $form->field($formModel, 'password')->passwordInput() ?>
        <?= $form->field($formModel, 'password_repeat')->passwordInput()->label('Re-type password') ?>
    </div>

    <div class="fileinput fileinput-new" data-provides="fileinput">
        <div class="clearfix">
            <div class="pull-left">
                <div class="fileinput-preview thumbnail" data-trigger="fileinput">
                    <img class="img-circle" src="<?= Yii::$app->user->identity->getAvatarUrl() ?>" alt="profile picture">
                </div>
            </div>
            <div>
                <small>Upload a profile picture</small>
            </div>
            <div class="gray">
                <small>minimum 200px square</small>
            </div>
            <div class="mt5">
                <div class="btn btn-success btn-xs btn-file mr">
                    <span class="fileinput-new">Browse</span>
                    <span class="fileinput-exists">Change</span>
                    <?= $form->field($formModel, 'avatar', [
                        'template' => '{input}{error}'
                    ])->input('file')->label(false); ?>
                </div>
                <a href="#" class="btn btn-danger btn-xs fileinput-exists" data-dismiss="fileinput">Remove</a>
            </div>
        </div>
    </div>

    <div class="row form-group-pair">
        <div class="col-sm-9">
        <?= $form->field($formModel, 'email_notifications')->inline(true)->radioList([
                1 => 'Yes',
                0 => 'No'
            ],
            [
                'template' => '<div class="radio-group-inline">{label}{input}{error}{hint}</div>',
                'item' => '\backend\widgets\RadiolistInlineTemplate::populateWidget'
            ])->label('Receive e-mail notifications?'); ?>
        </div>
    </div>

    <div class="row form-group-pair">
        <div class="col-sm-9">
            <?= $form->field($formModel, 'first_name') ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($formModel, 'first_name_visible')->inline(true)->radioList([
                1 => 'Show',
                0 => 'Hide'
            ],
            [
                'item' => '\backend\widgets\RadiolistInlineTemplate::populateWidget'
            ])->label(false); ?>
        </div>
    </div>
    <div class="row form-group-pair">
        <div class="col-sm-9">
            <?= $form->field($formModel, 'last_name') ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($formModel, 'last_name_visible')->inline(true)->radioList([
                1 => 'Show',
                0 => 'Hide'
            ],
            [
                'item' => '\backend\widgets\RadiolistInlineTemplate::populateWidget'
            ])->label(false); ?>
        </div>
    </div>

    <div class="form-group date-of-birth">
        <div class="row">
            <div class="col-sm-9">
                <?=
                    $form->field($formModel, 'birth_date')->widget(\dosamigos\datetimepicker\DateTimePicker::className(), [
                        'template' => '{input}{button}',
                        'pickButtonIcon' => 'glyphicon glyphicon-calendar',
                        'clientOptions' => [
                            'format' => Formatter::phpDateCodeToDatepickerCode(Yii::$app->session->get('dateFormat')),
                            'startView' => 'decade',
                            'minView' => 'month',
                            'maxView' => 'year',
                            'autoclose' => true
                        ]
                    ])->label('Date of Birth')
                ?>
            </div>
            <div class="col-sm-3">
                <?= $form->field($formModel, 'birth_date_visible')->inline(true)->radioList([
                    1 => 'Show',
                    0 => 'Hide'
                ],
                [
                    'item' => '\backend\widgets\RadiolistInlineTemplate::populateWidget'
                ])->label(''); ?>
            </div>
        </div>
    </div>

    <div class="form-group">

        <label class="control-label" for="adduser-address_line_1">Address</label>
        <?php if ($user->user_role_id != 3) { ?>
        <?= $form->field($formModel, 'copy_address')->checkbox(['template' => "<div class=\"checkbox\">\n{input}\n{label}\n{error}\n{hint}\n</div>"])->label('Copy from main user?') ?>
        <?php } ?>
        <?= $form->field($formModel, 'address_line_1')->textInput([
            'data-main-user-value' => $mainUserAdrLine1,
            'data-orig-value' => $formModel->address_line_1
        ])->label(false) ?>
        <?= $form->field($formModel, 'address_line_2')->textInput([
            'data-main-user-value' => $mainUserAdrLine2,
            'data-orig-value' => $formModel->address_line_2
        ])->label(false) ?>
        <?= $form->field($formModel, 'country_id')->dropDownList($countries, [
            'prompt' => '- country -',
            'data-main-user-value' => $mainUserCountryId,
            'data-orig-value' => $formModel->country_id
        ])->label(false) ?>

        <div class="row mt5">
            <div class="col-sm-12">
                <?= $form->field($formModel, 'address_visible')->inline(true)->radioList([
                    1 => 'Show',
                    0 => 'Hide'
                ],
                [
                    'item' => '\backend\widgets\RadiolistInlineTemplate::populateWidget'
                ])->label(false); ?>
            </div>
        </div>
    </div>
    <div class="row form-group-pair">
        <div class="col-sm-9">
            <?= $form->field($formModel, 'landline_number') ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($formModel, 'landline_number_visible')->inline(true)->radioList([
                1 => 'Show',
                0 => 'Hide'
            ],
            [
                'item' => '\backend\widgets\RadiolistInlineTemplate::populateWidget'
            ])->label(false); ?>
        </div>
    </div>
    <div class="row form-group-pair">
        <div class="col-sm-9">
            <?= $form->field($formModel, 'cellphone_number')->label('Mobile / Cell Phone Number') ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($formModel, 'cellphone_number_visible')->inline(true)->radioList([
                1 => 'Show',
                0 => 'Hide'
            ],
            [
                'item' => '\backend\widgets\RadiolistInlineTemplate::populateWidget'
            ])->label(false); ?>
        </div>
    </div>
    <div class="row form-group-pair">
        <div class="col-sm-9">
            <?= $form->field($formModel, 'skype_name')->label('Skype Account') ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($formModel, 'skype_name_visible')->inline(true)->radioList([
                1 => 'Show',
                0 => 'Hide'
            ],
            [
                'item' => '\backend\widgets\RadiolistInlineTemplate::populateWidget'
            ])->label(false); ?>
        </div>
    </div>
    <?php if (!isset($noDependant) || (!$noDependant)) {?>
    <?= $form->field($formModel, 'dependant')->checkbox(['template' => "<div class=\"checkbox\">\n{input}\n{label}\n{error}\n{hint}\n</div>"]) ?>
    <?php } ?>
</div>
<div class="modal-footer">
<?php if (!isset($noClose) || (!$noClose)) {?>
<?= Html::submitButton('Close', ['class' => 'btn btn-default close-modal', 'data-dismiss' => 'modal']); ?>
<?php } ?>
<?= Html::submitButton('Save User', [
    'class' => 'btn btn-primary ajax-submit',
    'data-js-callback' => JsTools::jsCallback($this, 'reloadUsers'),
    'data-submit-url' => Url::toRoute([
        '/users/edit-user',
        'id' => $userId,
        'user-details' => isset($noBasicInfo) && $noBasicInfo ? 1 : 0
    ])
]);?>
</div>
<?php ActiveForm::end(); ?>
<?= JsTools::viewJs($this); ?>
