<?php
use yii\bootstrap\ActiveForm;
use yii\helpers\Html;
use yii\helpers\Url;
use backend\components\helpers\Formatter;
use backend\widgets\FormattedTitle;
use backend\components\helpers\JsTools;
?>
<div id="body" class="container-fluid" data-js-callback="usersLoaded" data-select-menu="li.account-settings" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>">

    <div class="row">
        <div class="col-lg-12">
            <div class="col-head">
                <h4>Basic Information</h4>
            </div>

            <div class="panel">
                <?php $form = ActiveForm::begin([
                    'id' => 'add-estimated-expense-form',
                    'options' => [
                        'class' => 'auto-submit-form',
                        'data-submit-url' => Url::toRoute('/users/edit-user-basic-info')
                    ]
                ]); ?>
                    <div class="row">
                        <div class="col-sm-3">
                            <?= $form->field($formModel, 'currency_id')->dropDownList($currencies)->label('Currency') ?>
                        </div>
                        <div class="col-sm-2">
                            <?= $form->field($formModel, 'time_zone_id')->dropDownList($timeZones)->label('Time Zone') ?>
                        </div>
                        <div class="col-sm-2">
                            <?= $form->field($formModel, 'time_format_id')->dropDownList($timeFormats)->label('Time Format') ?>
                        </div>
                        <div class="col-sm-2">
                            <?= $form->field($formModel, 'date_format_id')->dropDownList($dateFormats)->label('Date Format') ?>
                        </div>
                        <div class="col-sm-3">
                            <?= $form->field($formModel, 'currency_format')->dropDownList($currencyFormats)->label('Currency Format') ?>
                        </div>
                    </div>
                <?php ActiveForm::end(); ?>
                <?= JsTools::viewJs($this); ?>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <div class="col-head">
                <h3>People on Your Account</h3>
                <?php if ($this->params['userRole'] == 'client') { ?>
                <a href="#" class="btn btn-primary btn-sm open-modal" data-modal-url="<?= Url::toRoute(['/users/add-user']) ?>">Add a New Person</a>
                <?php } ?>
            </div>

            <div class="panel panel-tabbed users-panel">
                <div class="tabpanel tabpanel-secondary">
                    <div class="container-fluid">
                        <div class="row no-gutter">
                            <div class="col-lg-6 no-float tab-col">
                                <!-- Nav tabs -->
                                <ul class="nav nav-tabs" role="tablist">
                                    <?php
                                    foreach ($users as $key => $u) {
                                    $active = ($u->id == $this->params['userIdentity']->id) ? 'active' : '';
                                    ?>
                                    <li role="presentation" class="<?= $active ?>" data-user-id="<?= $u->id ?>">
                                        <a href="#user<?= $u->id ?>" aria-controls="home" role="tab" data-toggle="tab" aria-expanded="true">
                                            <?= (strlen($u->meta['full_name']) > 0) ? $u->meta['full_name'] : $u->username; ?>
                                            <?php if ($u->user_parent_id == null) { ?><span class="val">Primary User</span><?php } ?>
                                            <?php if (isset($u->meta['dependant']) && ($u->meta['dependant'] == 1)) { ?><span class="val">Dependant</span><?php } ?>
                                        </a>
                                    </li>
                                    <?php } ?>
                                </ul>
                            </div>
                            <div class="col-lg-6 no-float">
                                <!-- Tab panes -->
                                <div class="tab-content">
                                    <?php foreach ($users as $key => $u) {
                                    $active = ($u->id == $this->params['userIdentity']->id) ? ' active' : '';
                                    ?>
                                    <div role="tabpanel" class="tab-pane<?= $active ?>" id="user<?= $u->id ?>" data-user-id="<?= $u->id ?>">
                                        <?php if ($u->hasNotUniqueEmail()) { ?>
                                        <p class="alert alert-warning">
                                            Sub Accounts with the same email address as the main account will need access to this email account
                                            for password retrieval purposes. If possible, we recommend using different emails for sub accounts.
                                        </p>
                                        <?php } ?>
                                        <div class="col-head">
                                            <img class="img-circle" src="<?= $u->getAvatarUrl() ?>" alt="profile picture">
                                            <h3><?= (strlen($u->meta['full_name'])) ? $u->meta['full_name'] : $u->username; ?></h3>
                                            <?php if (($this->params['initUserRole'] != 'sub-client') || ($u->id == Yii::$app->user->id)){ ?>
                                            <a href="#" class="open-modal" data-modal-url="<?= Url::toRoute(['/users/edit-user', 'id' => $u->id ]) ?>" data-toggle="tooltip" title="Edit"><i class="glyphicon glyphicon-pencil gi-2x"></i></a>
                                            <?php } ?>
                                            <?php if ($this->params['initUserRole'] != 'sub-client') { ?>
                                            <a href="#" class="open-modal" data-modal-url="<?= Url::toRoute(['/users/remove-user', 'id' => $u->id]) ?>" data-toggle="tooltip" title="Remove"><i class="glyphicon glyphicon-trash gi-2x"></i></a>
                                            <?php } ?>
                                        </div>
                                        <div class="row">
                                            <div class="col-sm-5">
                                                <div class="label-group">
                                                    <label>Username</label>
                                                    <span class="label-value"><?= $u->username ?></span>
                                                </div>
                                                <div class="label-group">
                                                    <label>Email Address</label>
                                                    <span class="label-value"><?= $u->email; ?></span>
                                                </div>
                                                <?php if (isset($u->meta['first_name']) && (strlen($u->meta['first_name']) > 0)) { ?>
                                                <div class="label-group">
                                                    <label>First Name</label>
                                                    <span class="label-value"><?= $u->meta['first_name'] ?></span>
                                                </div>
                                                <?php } ?>
                                                <?php if (isset($u->meta['last_name']) && (strlen($u->meta['last_name']) > 0)) { ?>
                                                <div class="label-group">
                                                    <label>Last Name</label>
                                                    <span class="label-value"><?= $u->meta['last_name'] ?></span>
                                                </div>
                                                <?php } ?>
                                                <?php if (isset($u->meta['birth_date']) && (strlen($u->meta['birth_date']) > 0)) { ?>
                                                <div class="label-group">
                                                    <label>Date of Birth</label>
                                                    <span class="label-value"><?= Formatter::date(strtotime($u->meta['birth_date'])) ?></span>
                                                </div>
                                                <?php } ?>
                                                <?php if (isset($u->meta['email_notifications'])) { ?>
                                                <div class="label-group">
                                                    <label>Email Notifications</label>
                                                    <span class="label-value"><?= $u->meta['email_notifications'] ? 'Yes' : 'No'; ?></span>
                                                </div>
                                                <?php } ?>
                                            </div>
                                            <div class="col-sm-5">

                                                <?php if (isset($u->meta['address_one_line']) && (strlen($u->meta['address_one_line']) > 0)) { ?>
                                                <div class="label-group">
                                                    <label>Address</label>
                                                    <span class="label-value"><?= $u->meta['address_one_line'] ?></span>
                                                </div>
                                                <?php } ?>
                                                <?php if (isset($u->meta['landline_number']) && (strlen($u->meta['landline_number']) > 0)) { ?>
                                                <div class="label-group">
                                                    <label>Phone Number</label>
                                                    <span class="label-value"><?= $u->meta['landline_number'] ?></span>
                                                </div>
                                                <?php } ?>
                                                <?php if (isset($u->meta['cellphone_number']) && (strlen($u->meta['cellphone_number']) > 0)) { ?>
                                                <div class="label-group">
                                                    <label>Mobile / Cell Phone Number</label>
                                                    <span class="label-value"><?= $u->meta['cellphone_number'] ?></span>
                                                </div>
                                                <?php } ?>
                                                <?php if (isset($u->meta['skype_name']) && (strlen($u->meta['skype_name']) > 0)) { ?>
                                                <div class="label-group">
                                                    <label>Skype Account</label>
                                                    <span class="label-value"><?= $u->meta['skype_name'] ?></span>
                                                </div>
                                                <?php } ?>
                                                <?php if (isset($u->meta['country_name']) && (strlen($u->meta['country_name']) > 0)) { ?>
                                                <div class="label-group">
                                                    <label>Country</label>
                                                    <span class="label-value"><?= $u->meta['country_name'] ?></span>
                                                </div>
                                                <?php } ?>
                                            </div>
                                        </div>
                                    </div>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?= $this->render('/layouts/_footer') ?>

</div>
