// Array.find polyfill
// https://tc39.github.io/ecma262/#sec-array.prototype.find
if (!Array.prototype.find) {
    Object.defineProperty(Array.prototype, 'find', {
        value: function(predicate) {
            // 1. Let O be ? ToObject(this value).
            if (this == null) {
                throw new TypeError('"this" is null or not defined');
            }

            var o = Object(this);

            // 2. Let len be ? ToLength(? Get(O, "length")).
            var len = o.length >>> 0;

            // 3. If IsCallable(predicate) is false, throw a TypeError exception.
            if (typeof predicate !== 'function') {
                throw new TypeError('predicate must be a function');
            }

            // 4. If thisArg was supplied, let T be thisArg; else let T be undefined.
            var thisArg = arguments[1];

            // 5. Let k be 0.
            var k = 0;

            // 6. Repeat, while k < len
            while (k < len) {
                // a. Let Pk be ! ToString(k).
                // b. Let kValue be ? Get(O, Pk).
                // c. Let testResult be ToBoolean(? Call(predicate, T, « kValue, k, O »)).
                // d. If testResult is true, return kValue.
                var kValue = o[k];
                if (predicate.call(thisArg, kValue, k, o)) {
                    return kValue;
                }
                // e. Increase k by 1.
                k++;
            }

            // 7. Return undefined.
            return undefined;
        }
    });
}

$.urlParam = function(name) {
    var results = new RegExp('[\?&]' + name + '=?([^&#]*)').exec(window.location.href);
    if (results == null){
        return null;
    }
    else{
        return decodeURI(results[1]) || 0;
    }
};


var player;
function onYouTubeIframeAPIReady() {
    player = new YT.Player('video-player', {
        height: '360',
        width: '640',
        videoId: $('.video-tutorial-content .video-container').data('video-id'),
        playerVars: {
            autoplay: 1,
            rel: 0
        },
        events: {
            'onReady': onPlayerReady,
            'onStateChange': onPlayerStateChange
        }
    });
}
function onPlayerReady(event) {
    event.target.setPlaybackQuality('hd720');
}
function onPlayerStateChange(event) {
    if (event.data === YT.PlayerState.BUFFERING) {
        event.target.setPlaybackQuality('hd720');
    }
}

var GMJS = {};
GMJS.POLL_FOR_UPDATES = true;
GMJS.C = {};
GMJS.C.CLONE = function(cloneMe) { return JSON.parse(JSON.stringify(cloneMe)); };
GMJS.C.REMOVE = function(arr, item) {
    var index = arr.indexOf(item);
    if (index < 0) {
        return arr;
    }
    arr.splice(index, 1);
    return arr;
};
GMJS.C.DISABLE_BACK_BY_BACKSPACE = function() {
    $(document).unbind('keydown').bind('keydown', function (event) {
        var isBackspace = event.keyCode === 8;
        if (!isBackspace) {
            return;
        }
        var target = event.target || event.srcElement;
        var isInput = target.tagName.toLowerCase() === 'input';
        var isTextArea = target.tagName.toLowerCase() === 'textarea';
        if (isInput || isTextArea) {
            return;
        }
        var isDisabled = target.readOnly || target.disabled;
        if (isDisabled) {
            return;
        }
        event.preventDefault();
    });
};
GMJS.C.MANAGE_VIDEO_TUTORIAL = function () {
    $('body').on('click', '.video-tutorial-handle', function() {
        var $tutorial = $('.video-tutorial');
        var tutorialId = $tutorial.data('tutorial-id');
        var $content = $('.video-tutorial-content');
        var hT = window.localStorage.getItem('hiddenTutorials');
        if (!hT) { hT = []; } else { hT = JSON.parse(hT); }
        if ($tutorial.is('.is-visible')) {
            hT.push(tutorialId);
            $content.slideUp(function() {
                $tutorial.removeClass('is-visible');
            });
        } else {
            hT = GMJS.C.REMOVE(hT, tutorialId);
            $content.slideDown(function() {
                $tutorial.addClass('is-visible');
            });
        }
        window.localStorage.setItem('hiddenTutorials', JSON.stringify(hT));
    });
    $('body').on('click', '.video-tutorial-content .video-container .start-video', function() {
        if ($("script[src='https://www.youtube.com/iframe_api']").length <= 0) {
            var tag = document.createElement('script');
            tag.src = "https://www.youtube.com/iframe_api";
            var firstScriptTag = document.getElementsByTagName('script')[0];
            firstScriptTag.parentNode.insertBefore(tag, firstScriptTag);
        }
        else {
            onYouTubeIframeAPIReady();
        }
        return false;
    });
};
GMJS.C.SHOW_VIDEO_TUTORIAL = function () {
    var $tutorial = $('.video-tutorial');
    var tutorialId = $tutorial.data('tutorial-id');
    if (!tutorialId) {
        return;
    }
    if (!$tutorial.hasClass('hideable')) {
        $tutorial.addClass('is-visible');
        return;
    }
    var hiddenTutorials = window.localStorage.getItem('hiddenTutorials');
    if (!hiddenTutorials) {
        $tutorial.addClass('is-visible');
        return;
    }
    hiddenTutorials = JSON.parse(hiddenTutorials);
    var isHidden = hiddenTutorials.find(function(id) {return id === tutorialId;});
    if (!isHidden) {
        $tutorial.addClass('is-visible');
    }

    if ($.urlParam('video') !== null && $('.video-tutorial-handle').length > 0 && $('.video-container .start-video').length > 0) {
        if (!$('.video-tutorial').hasClass('is-visible')) {
            $('.video-tutorial-handle')[0].click();
        }
        $('.video-container .start-video')[0].click();
    }
};
GMJS.C.MANAGE_DASHBOARD_CAROUSEL = function() {
    var ITEM_WIDTH = 160;
    $('body').on('click', '.dashboard-jars-scroll', function() {
        if (!$(this).is('.active')) { return; }
        var $carousel = $('.dashboard-jars-carousel');
        var $carouselBody = $('.dashboard-jars-carousel-wrapper');
        var maxOffset = -((ITEM_WIDTH * $carouselBody.find('.dashboard-jars-jar').length) - $carousel.width());
        var currentOffset = parseInt($carouselBody.css('margin-left'));
        if ($(this).is('.dashboard-jars-scroll-left')) {
            var newOffset = currentOffset + ITEM_WIDTH;
            if (newOffset > -(ITEM_WIDTH / 2)) {
                $carouselBody.animate({"margin-left": 0});
                $('.dashboard-jars-scroll-left').removeClass('active');
            } else {
                $carouselBody.animate({"margin-left": '+=' + ITEM_WIDTH});
            }
            $('.dashboard-jars-scroll-right').addClass('active');
        } else {
            var newOffset = currentOffset - ITEM_WIDTH;
            if (newOffset < (maxOffset + (ITEM_WIDTH / 2))) {
                $carouselBody.animate({"margin-left": maxOffset});
                $('.dashboard-jars-scroll-right').removeClass('active');
            } else {
                $carouselBody.animate({"margin-left": '-=' + ITEM_WIDTH});
            }
            $('.dashboard-jars-scroll-left').addClass('active');
        }
    });
};
GMJS.C.SELECT_ALL_ON_FOCUS = function() {
    $('body').on('focus', "input[type='text']:not([readonly])", function() {
        $(this).select();
    });
};
