$(document).ready(function() {

    var isSubmitting = false;
    var mainNav = $('#side-bar, #profile-dropdown-menu'); // main navigation bar
    var loadedCont = $('#loaded-content'); // container for loaded content
    var loadingBodyHtml = '<div class="loading-content-block">Loading...</div>';
    var loadingContentHtml = '<div class="loading-content-block">Loading...</div>';
    var loadingTitle = loadingTitle;
    var ajaxSubmitSelector = 'input[type="submit"]:not(.disable-default), button[type="submit"]:not(.close-modal):not(.disable-default)';
    var ajaxAutoSubmitSelector = 'form.auto-submit-form input, form.auto-submit-form textarea, form.auto-submit-form select';
    var chatRefreshInterval = 60000;
    var notificationsRefreshInterval = 120000;
    var subscriptionStatus = parseInt($('body').data('subscription-status'));
    window.lastLoadedPageType = false; // helps to determine whether a full page load is necessary
    window.navigationsCount = 0;
    var pageUrls = {// urls used in this script
        'avatars': baseUrl + '/uploads/avatars',
        'jars': baseUrl + '/jars/index',
        'expenseJarHeaderInfo': baseUrl + '/jars/expense-jar-header-info',
        'debtJarHeaderInfo': baseUrl + '/jars/debt-jar-header-info',
        'expenseJarRecurringExpensesTableInfo': baseUrl + '/expenses/expense-jar-recurring-expenses-table-info',
        'expenseJarEstimatedExpensesTableInfo': baseUrl + '/expenses/expense-jar-estimated-expenses-table-info',
        'expenseJarOnetimeExpensesTableInfo': baseUrl + '/expenses/expense-jar-onetime-expenses-table-info',
        'expenseJarTransactionsTableInfo': baseUrl + '/transactions/expense-jar-transactions-table-info',
        'debtJarDebtPaymentsTableInfo': baseUrl + '/debt-payments/debt-jar-debt-payments-table-info',
        'interestsInterestPaymentsTableInfo': baseUrl + '/debt-payments/interests-interest-payments-table-info',
        'expenses': baseUrl + '/expenses/index',
        'transactions-table': baseUrl + '/transactions/transactions-table',
        'debt-payments': baseUrl + '/debt-payments/index',
        'accounts': baseUrl + '/accounts/index',
        'accountDetailInfo': baseUrl + '/accounts/account-detail-info',
        'accountExpenseTransactionsTableInfo': baseUrl + '/money-operations/account-expense-transactions-table-info',
        'accountIncomeTransactionsTableInfo': baseUrl + '/income-transactions/account-income-transactions-table-info',
        'balanceSheetAdjustmentsTable': baseUrl + '/accounts/balance-sheet-adjustments-table',
        'editAccount': baseUrl + '/accounts/edit-account',
        'debts': baseUrl + '/debts/index',
        'debts-table': baseUrl + '/debts/debts-table',
        'debts-table-full': baseUrl + '/debts/debts-table-full',
        'debts-table-info': baseUrl + '/debts/debts-table-info',
        'debtPaymentsTableInfo': baseUrl + '/debt-payments/debt-payments-table-info',
        'incomes': baseUrl + '/incomes/index',
        'incomes-table-info': baseUrl + '/incomes/incomes-table-info',
        'incomeTransactionsTableInfo': baseUrl + '/income-transactions/income-transactions-table-info',
        'account-balances-graph-data': baseUrl + '/account-balances/account-balances-graph-data',
        'moneyOperationsTableInfo': baseUrl + '/money-operations/money-operations-table-info',
        'editUser': baseUrl + '/users/edit-user',
        'mockBudgets': baseUrl + '/mock-budgets',
        'eoms': baseUrl + '/budget/end-of-month-summary',
        'eomsEquationNumbers': baseUrl + '/budget/end-of-month-summary-equation-numbers',
        'eomsMonths': baseUrl + '/budget/end-of-month-summary-months',
        'addConversationMessage': baseUrl + '/conversations/add-conversation-message',
        'conversationMessagesHtml': baseUrl + '/conversations/get-conversation-messages-html',
        'conversationsListData': baseUrl + '/conversations/get-conversations-list-data',
        'messagingUpdatesData': baseUrl + '/conversations/get-messaging-updates-data',
        'notificationUpdatesData': baseUrl + '/notifications/get-notification-updates-data',
        'dayAppointmentData': baseUrl + '/appointments/get-day-appointment-data',
        'coach': baseUrl + '/coach',
        'removeNoteAttachment': baseUrl + '/admin/notes/remove-note-attachment',
        'checkMoneyOperation': baseUrl + '/money-operations/check-money-operation',
        'addEsTransaction': baseUrl + '/transactions/add-es-transaction'
    };
    var detailPages = {
        'jarDetail': {
            'urls': [
                'jars/index',
                'jars/expense-jar-detail',
                'jars/debt-jar-detail',
                'jars/interest-jar-detail'
            ],
            'containerSelector': '.jar-container',
            'idAttr': 'jar-id'
        },
        'lessonDetail': {
            'urls': [
                'lessons'
            ],
            'containerSelector': '.lesson-container',
            'idAttr': 'lesson-id'
        },
        'accountDetail': {
            'urls': [
                'accounts/index',
                'accounts/account-detail'
            ],
            'containerSelector': '.account-container',
            'idAttr': 'account-id'
        },
        'debtDetail': {
            'urls': [
                'debts/index',
                'debts/debt-detail'
            ],
            'containerSelector': '.debt-container',
            'idAttr': 'debt-id'
        },
        'transferDetail': {
            'urls': [
                'transfers/index',
                'transfers/transfer-detail'
            ],
            'containerSelector': '.transfer-container',
            'idAttr': 'transfer-id'
        },
        'incomeDetail': {
            'urls': [
                'incomes/index',
                'incomes/income-detail'
            ],
            'containerSelector': '.income-container',
            'idAttr': 'income-id'
        },
        'deletedJarDetail': {
            'urls': [
                'jars/deleted-jars',
                'jars/deleted-expense-jar-detail',
                'jars/deleted-debt-jar-detail'
            ],
            'containerSelector': '.jar-container',
            'idAttr': 'jar-id'
        },
        'mockBudgetDetail': {
            'urls': [
                'mock-budgets/budget-detail'
            ],
            'containerSelector': '.income-container',
            'idAttr': 'income-id'
        },
        'conversationDetail': {
            'urls': [
                'admin/coach/index',
                'admin/coach/conversation-detail'
            ],
            'containerSelector': '.conversation-container',
            'idAttr': 'user-id'
        },
        'reportDetail': {
            'urls': [
                'reports/report-detail',
                'reports/transactions-by-month-report',
                'reports/monthly-transaction-totals-by-year-report',
                'reports/monthly-transaction-totals-by-jar-and-year-report',
                'reports/incomes-and-expenses-changes-report',
                'reports/usage-history-report',
                'reports/total-budgeted-vs-total-spent-report',
                'reports/tax-report',
                'repots/end-of-month-summary-report',
                'reports/end-of-month-bank-account-balances-report',
                'reports/end-of-month-debt-amounts-report',
                'reports/transactions-chart-report',
                'reports/end-of-month-summary-report'
            ],
            'containerSelector': '.report-container',
            'idAttr': 'report-id'
        },
        'noteDetail': {
            'urls': [
                'admin/notes/index',
                'admin/notes/client-detail'
            ],
            'containerSelector': '.notes-container',
            'idAttr': 'user-id'
        },
        'step5JarDetail': {
            'urls': [
                'first-time-setup/step-5',
                'first-time-setup/step-5-jar-detail'
            ],
            'containerSelector': '.step-5-jar-container',
            'idAttr': 'jar-id'
        },
        'searchResultsDetail': {
            'urls': [
                'search/results'
            ],
            'containerSelector': function(url, popData) {
                if (url.indexOf('pageLoadRequest') > 0) {
                    if (popData) {
                        return '#' + popData.id;
                    }
                }
                return '#loaded-content';
            },
            'idAttr': 'jar-id'
        }
    };
    window.nextUrlChangeCallback = false; // use this to set callbacks for URL changes

    // Hack for allowing links to anchors
    $(document).on('click', 'a.pageLink[href^="#"]', function(e) {

        if (!$(this).data('no-scroll')) {

            e.preventDefault();
            var url = $(this).attr('href');
            $(url)[0].scrollIntoView();
            //History.pushState(null, '', url);
            e.stopPropagation();
            return false;

        }

    });

    //********************
    // GLOBAL PAGE BEHAVIOR
    //********************
    // load content from URL on page load
    if (loadedCont.is(':empty')) {

        loadConentForUrl(window.location.href, loadedCont, loadingBodyHtml, false, true);

    }

    // handle navigation clicks
    mainNav.find('a').not('.skipHistory, .skip-history').click(function() {

        var link = $(this).attr('href');

        History.pushState(null, loadingTitle, link);

        closeTopScreenNotification();

        return false;

    });

    $('body').on('click', '.system-link', function() {
        var link = $(this).attr('href');
        History.pushState(null, loadingTitle, link);
        closeTopScreenNotification();
        return false;
    });

    // search field and search results handling
    var searchSubmit = function($form, $input) {
        if ($input.val().length <= 0) {
            topScreenNotification('Provide search query.', 'error');
            return false;
        }
        var link = $form.attr('action') + '?q=' + $input.val();

        History.pushState(null, loadingTitle, link);
        closeTopScreenNotification();

        return false;
    };

    $('body').on('keyup', '#search-bar [name=q]', function(e) {
        if (e.which == 13) {
            searchSubmit($('#search-form'), $(this));
        }
    });

    $('body').on('click', '#search-bar .search-trigger', function() {
        var $form = $('#search-form');
        return searchSubmit($form, $form.find('[name=q]'));
    });

    $('body').on('click', '.search-results .pagination a', function() {
        History.pushState([{
            id: $(this).parents('.list-view').attr('id'),
            page: $(this).data('page')
        }], loadingTitle, $(this).attr('href'));
        return false;
    });

    // set initial loaded page type
    var url = window.location.href;
    $.each(detailPages, function(detailName, detailData) {

        $.each(detailData.urls, function(index, detailUrl) {

            if (url.indexOf(detailUrl) > 0) {

                window.lastLoadedPageType = detailName;
                return;

            }

        });

    });

    // event fires on browser history change (see above)
    $(window).on('popstate', function() {

        var url = window.location.href;
        var forceFullLoad = false;
        var isDetailPage = false;
        var pageState = History.getState();

        $.each(detailPages, function(detailName, detailData) {

            $.each(detailData.urls, function(index, detailUrl) {

                if (url.indexOf(detailUrl) > 0) {

                    if ((window.lastLoadedPageType != detailName) || (url.indexOf('/index') > -1)) {

                        url += ((url.indexOf('?') > -1) ? '&' : '?') + 'full_load=1';
                        forceFullLoad = true;

                    }

                    var containerSelector;
                    if (typeof detailData.containerSelector === 'string') {
                        containerSelector = detailData.containerSelector;
                    }
                    else {
                        // for certain cases we need additional logic for the selector
                        containerSelector = detailData.containerSelector(url, pageState.data ? pageState.data[0] : null);
                    }

                    loadConentForUrl(url, (forceFullLoad ? loadedCont : $(containerSelector)), loadingContentHtml, window.nextUrlChangeCallback, false, pageState.data ? pageState.data[0] : null);
                    window.lastLoadedPageType = detailName;
                    isDetailPage = true;
                    return false;

                }

            });

        });

        if (!isDetailPage) {

            loadConentForUrl(url, loadedCont, loadingBodyHtml, window.nextUrlChangeCallback);
            window.lastLoadedPageType = false;

        }

    });

    //********************
    // SUB-PAGE BEHAVIOR
    //********************
    // GENERAL
    // open a detail page
    $('body').on('click', 'ul#secondary-side-bar-nav:not(.lessons) > li > a, ul.detail-tab-nav > li > a, ul#secondary-side-bar-nav.lessons ul > li > a', function() {

        var link = $(this).attr('href');

        History.pushState(null, loadingTitle, link);

        $(this).closest('ul').find('li.active').removeClass('active');
        $(this).closest('li').addClass('active');

        return false;

    });

    // open/close dashboard panel "view more"
    $('body').on('click', '.panel.panel-dashboard .view-more', function() {

        var panel = $(this);

        if (!panel.hasClass('open')) {

            panel.closest('.panel-dashboard').animate({'height': panel.data('expand-height') + 'px'}, 500, function() {

                panel.text(panel.data('view-less-text')).addClass('open');

            });

        }
        else {

            panel.closest('.panel-dashboard').animate({'height': panel.data('orig-height') + 'px'}, 500, function() {

                panel.text(panel.data('view-more-text')).removeClass('open');

            });

        }

    });

    $('body').on('click', '.lessons-side-bar-item.group > a', function() {
        var group = $(this).parent();
        if (group.hasClass('opened')) {
            group.removeClass('opened');
            group.find('.group-items').slideUp(function () {
                group.removeClass('active');
            });
        }
        else {
            $('.lessons-side-bar-item.group.opened > a').each(function() {
                $(this).trigger('click');
            });
            group.addClass('opened');
            group.find('.group-items').slideDown(function () {
                group.addClass('active');
                group.find('li:first a').trigger('click');
            });
        }
        return false;
    });

    // COACH / APPOINTMENTS
    $('body').on('change', '#addtimeslot-frequency', function () {
        var $addon = $(this).parents('form').find('.field-addtimeslot-repeatevery .input-group-addon');
        switch ($(this).val()) {
            case 'daily':
                $addon.text('days');
                break;
            case 'weekly':
                $addon.text('weeks');
                break;
            case 'monthly':
                $addon.text('months');
                break;
            case 'annually':
                $addon.text('years');
                break;
        }
    });
    $('body').on('change', '#addtimeslot-repeat', function() {
        if ($(this).is(':checked')) {
            $('#addtimeslot-repeat-box').slideDown();
            $('#edit-option-box').slideUp();
        }
        else {
            $('#addtimeslot-repeat-box').slideUp();
            $('#edit-option-box').slideDown();
        }
    });
    $('body').on('change', '#add-time-slot-form input, #add-time-slot-form select', function() {
        $.post(
            $('#add-time-slot-form').data('summary-url'),
            $('#add-time-slot-form').serialize(),
            function(result) {
                $('#summary-text').html(result.text);
            }, 'json'
        );
    });

    // DEBTS
    // show/hide interest free end date field in form
    $('body').on('change', '#adddebt-has_interest_free_period', function() {
        $('.field-adddebt-formattedinterestfreeenddate').toggleClass('hidden');
    });

    // show/hide "tax deductible"
    $('body').on('change', '#adddebt-debt_type_id', function() {
        if ($(this).val() == 1) {
            $('#adddebt-tax_deductible').prop('checked', false);
            $('.field-adddebt-tax_deductible').hide();
        }
        else {
            $('.field-adddebt-tax_deductible').show();
        }
    });

    // INCOMES
    $('body').on('change', '#addincome-adjust_start_date', function() {
        $('.field-addincome-start_date').toggleClass('hidden');
    });
    $('body').on('change', '#addincome-frequency', function() {
        if ($(this).val() == 'one-time') {
            $('.field-addincome-jar_id').removeClass('hidden');
        }
        else {
            $('.field-addincome-jar_id').addClass('hidden');
        }
    });

    // TRANSACTIONS
    $('body').on('change', '#add-transaction-form #addtransaction-jar_id', function() {
        var debtJar = $("#add-transaction-form #addtransaction-jar_id option[value='" + $(this).val() + "']").data('debt');
        $.ajax({
            url: pageUrls['addEsTransaction'],
            method: 'get',
            data: {
                'jar': $(this).val()
            },
            complete: function(result, status) {
                if (status == 'success') {
                    $('#add-transaction-form #addtransaction-expense_id').html(
                        $(result.responseText).find('#addtransaction-expense_id').html()
                    );
                    if (debtJar) {
                        $('#add-transaction-form .field-addtransaction-expense_id').hide();
                        $('#add-transaction-form .field-addtransaction-debt_id').show();
                    }
                    else {
                        $('#add-transaction-form .field-addtransaction-expense_id').show();
                        $('#add-transaction-form .field-addtransaction-debt_id').hide();
                    }
                }
            }
        });
    });
    $('body').on('change', '#add-transaction-form #addtransaction-expense_id', function() {
        var $selected = $("#add-transaction-form #addtransaction-expense_id option[value='" + $(this).val() + "']");
        $("#add-transaction-form #addtransaction-account_id option[value='" + $selected.data('default-account') + "']").prop('selected', true);
        if ($selected.data('recurring')) {
            $(this).next('.help-block').show();
        }
        else {
            $(this).next('.help-block').hide();
        }
    });

    // EOMS
    // update readonly fields
    $('body').on('keyup change', '.eoms-accounts input:not([readonly])', function() {

        var readonlyInput = $(this).closest('tr').find('input[readonly]');

        if (!isNaN($(this).val())) {

            readonlyInput.val($(this).val());

        }

    });

    $('body').on('keyup change', '.eoms-cc-debts .cc-debt-amount input', function() {

        var inputValue = parseFloat($(this).val());

        if (!isNaN(inputValue)) {

            var initInputValue = parseFloat($(this).closest('td').data('init-value'));
            var inputDifference = inputValue - initInputValue;
            var initThisMonthsValue = parseFloat($(this).closest('tr').find('.cc-debt-this-months-amount').data('init-value'));
            var thisMonthsValue = initThisMonthsValue - inputDifference;
            $(this).closest('tr').find('.cc-debt-this-months-amount input').val(thisMonthsValue);

        }

    });

    // NOTES
    // remove attachment
    $('body').on('click', '.remove-attachment', function() {

        var attachmentId = $(this).closest('.attachment').data('attachment-id');
        var modalUrl = $(this).closest('.attachment').data('modal-url');

        $.ajax({
            url: pageUrls['removeNoteAttachment'],
            method: 'get',
            data: {
                'note_attachment_id': attachmentId
            },
            complete: function(result, status) {

                if (status == 'success') {

                    $.ajax({
                        url: modalUrl,
                        method: 'post',
                        complete: function(result) {

                            $('.attachments-container').html($(result.responseText).find('.attachments-container'));

                        }
                    });
                    $('#cn-table-1').DataTable().ajax.reload();

                }

            }
        });

        return false;

    });

    // ACCOUNTS
    // Bank account statement checking
    $('body').on('change', '.bank-statement-check input[type="checkbox"]', function() {
        var input = $(this);
        var cont = input.closest('div.checkbox');
        var checked = input.is(':checked');

        $.ajax({
            url: pageUrls['checkMoneyOperation'],
            method: 'get',
            data: {
                'checked': checked * 1,
                'operation_type': cont.data('operation-type'),
                'operation_id': cont.data('operation-id')
            },
            complete: function(result, status) {
                var response = $.parseJSON(result.responseText);
                if (response.status == 'error') {
                    input.prop('checked', !checked);
                    topScreenNotification(response.message, response.status);
                }
            }
        });
    });

    // show/hide interest free end date field in form
    $('body').on('change', '#addaccount-has_interest_free_period', function() {
        $('.field-addaccount-formattedinterestfreeenddate').toggleClass('hidden');
    });
    $('body').on('change', '#addccaccount-has_interest_free_period', function() {
        $('.field-addccaccount-interest_free_end_date').toggleClass('hidden');
    });

    // ADMIN - USERS
    $('body').on('keyup change', '#admin-add-user-form #adduser-user_role_id', function() {

        if ($(this).val() == 3) {

            $('#admin-add-user-form .field-adduser-user_parent_id').addClass('hidden');
            $('#admin-add-user-form .field-adduser-coach_id').removeClass('hidden');

        }
        else if ($(this).val() == 4) {

            $('#admin-add-user-form .field-adduser-user_parent_id').removeClass('hidden');
            $('#admin-add-user-form .field-adduser-coach_id').addClass('hidden');

        }
        else {

            $('#admin-add-user-form .field-adduser-user_parent_id').addClass('hidden');
            $('#admin-add-user-form .field-adduser-coach_id').addClass('hidden');

        }

    });


    // date selector functionality
    // months change
    $('body').on('change', '.eoms-date-selector select[name="month"]', function() {

        var callback = $(this).closest('.eoms-date-selector').data('js-callback');
        var month = $(this).closest('.eoms-date-selector').find('[name="month"]').val();
        var year = $(this).closest('.eoms-date-selector').find('[name="year"]').val();

        if (month > 0) {

            callbacks[callback](month, year);

        }

    });

    // year change
    $('body').on('change', '.eoms-date-selector select[name="year"]', function() {

        var callback = $(this).closest('.eoms-date-selector').data('js-callback-months');
        var year = $(this).closest('.eoms-date-selector').find('[name="year"]').val();
        callbacks[callback](year);

    });

    // copy address from main user
    $('body').on('change', '#add-user-form #adduser-copy_address, #edit-user-form #adduser-copy_address', function() {

        var checked = $(this).is(':checked');
        if (checked) {

            $('#adduser-address_line_1').val($('#adduser-address_line_1').data('main-user-value'));
            $('#adduser-address_line_2').val($('#adduser-address_line_2').data('main-user-value'));
            $('#adduser-country_id').val($('#adduser-country_id').data('main-user-value'));

        }
        else {

            if ($(this).closest('form').attr('id') == 'add-user-form') {

                $('#adduser-address_line_1').val('');
                $('#adduser-address_line_2').val('');
                $('#adduser-country_id').val(false);

            }
            else {

                $('#adduser-address_line_1').val($('#adduser-address_line_1').data('orig-value'));
                $('#adduser-address_line_2').val($('#adduser-address_line_2').data('orig-value'));
                $('#adduser-country_id').val($('#adduser-country_id').data('orig-value'));

            }

        }

    });

    // MESSAGES
    // submit message
    $('body').on('keydown', '.messages-input', function() {
        if (event.which == 13) {
            submitMessage($(this), $(this).hasClass('conversations-page'));
            return false;
        }
    });
    $('body').on('click', '.send-message', function() {
        var $textarea = $(this).prev();
        submitMessage($textarea, $textarea.hasClass('conversations-page'));
        return false;
    });

    function submitMessage(input, conversationPage) {
        var message = input.val();
        var conversationId = input.data('conversation-id');

        if (message.length > 0) {
            $.ajax({
                url: pageUrls['addConversationMessage'],
                method: 'post',
                data: {
                    message: message,
                    conversation_id: conversationId
                },
                complete: function(result, status) {
                    var response = $.parseJSON(result.responseText);
                    input.val('');
                    if (response.status == 'success') {
                        if (conversationPage) {
                            $('.messages-list').append(
                                '<li class="mine" data-message-id="' + response.id + '">' +
                                    '<img class="avatar" src="' + response.avatar + '" />' +
                                    '<div class="message-part">' +
                                    '<span class="name">' + response.name + '</span>' +
                                    '<span class="date">' + response.date + '</span>' +
                                    '<p class="message">' + response.message + '</p>' +
                                    '<div class="clear"></div>' +
                                    '</div>' +
                                '</li>'
                            );
                            // scroll to bottom
                            messagesHistoryScrollDown();
                        }
                        else {
                            $('#message-alert-dropdown').append(
                                '<li style="display:none" id="alert-message" class="alert-msg-item clear" data-message-id="' + response.id + '" data-conversation-id="' + response.conversationId + '">' +
                                    '<div id="alert-message-' + response.id + '-canvas" class="clear">' +
                                    '<span class="name">' + response.name + '</span>' +
                                    '<span class="date">' + response.date + '</span>' +
                                    '<p>' + response.message + '</p>' +
                                    '</div>' +
                                '</li>'
                            );
                            $('#message-alert-dropdown li').last().slideDown();
                            if ($('#message-alert-dropdown li').length > 3) {
                                $('#message-alert-dropdown li').first().slideUp(function() {
                                    $(this).remove();
                                });
                            }
                        }
                    }
                    else if (response.status == 'error') {
                        topScreenNotification(response.message, response.status);
                    }
                }
            });
        }
    }

    if (subscriptionStatus > 0) {
        // needs to have a valid subscription first
        setInterval(function() {
            // load messages
            if ($('ul.messages-history').length > 0) {
                var conversationId = $('textarea.messages-input').data('conversation-id');
                var lastMessageId = $('ul.messages-history li.their:last').data('message-id');

                $.ajax({
                    url: pageUrls['conversationMessagesHtml'],
                    method: 'post',
                    data: {
                        last_message_id: lastMessageId,
                        conversation_id: conversationId
                    },
                    complete: function(result, status) {
                        var response = $.parseJSON(result.responseText);
                        if (response.html.length > 0) {
                            $('ul.messages-history').append(response.html);
                            messagesHistoryScrollDown();
                            $.playSound(baseUrl + '/audio/soft_1');
                        }
                    }
                });
            }
        }, chatRefreshInterval);
    }

    // load a conversation from list
    $('body').on('click', 'ul.messages-contacts-list li', function() {
        $('ul.messages-contacts-list li').removeClass('active');
        $(this).addClass('active');
        var conversationId = $(this).data('conversation-id');
        $('textarea.messages-input').val('').data('conversation-id', conversationId);
        $('ul.messages-history').html('');

        $.ajax({
            url: pageUrls['conversationMessagesHtml'],
            method: 'post',
            data: {
                conversation_id: conversationId,
                init_load: 1
            },
            complete: function(result, status) {
                var response = $.parseJSON(result.responseText);
                if (response.html.length > 0) {
                    $('ul.messages-history').append(response.html);
                    messagesHistoryScrollDown();
                }
            }
        });
    });

    // allow to click inside the textarea
    $('body').on('click', '#menu-new-message', function(e) {
        e.stopPropagation();
    });

    // refresh list of conversations
    if (subscriptionStatus > 0) {
        // needs to have a valid subscription first
        setInterval(function() {
            // load messages
            if ($('ul.messages-contacts-list').length > 0) {
                var activeConversationId = $('textarea.messages-input').data('conversation-id');
                $.ajax({
                    url: pageUrls['conversationsListData'],
                    method: 'post',
                    data: {
                        conversation_id: activeConversationId
                    },
                    complete: function(result, status) {
                        var response = $.parseJSON(result.responseText);
                        if (Object.keys(response.data).length) {
                            $.each(response.data, function(index, value) {
                                var listItem = $('ul.messages-contacts-list li[data-conversation-id=' + index + ']');
                                var newUnreadMessagesCount = parseInt(value.unreadMessagesCount);
                                var countCont = listItem.find('.messages-unread-count');
                                var oldUnreadMessagesCount = (countCont.length > 0) ? parseInt(countCont.find('.number').text()) : 0;

                                if (newUnreadMessagesCount > oldUnreadMessagesCount) {
                                    // show the number of unread messages
                                    if (countCont.length > 0) {
                                        countCont.html('<span class="number">' + newUnreadMessagesCount + '</span> unread message(s)');
                                    }
                                    else {
                                        listItem.append('<span class="messages-unread-count"><span class="number">' + newUnreadMessagesCount + '</span> unread message(s)</span>');
                                    }
                                    $('ul.messages-contacts-list').prepend(listItem);
                                    $.playSound(baseUrl + '/audio/soft_1');
                                }
                                // hide unread messages count if shown and 0 now
                                if ((countCont.length > 0) && (newUnreadMessagesCount < 1)) {
                                    countCont.remove();
                                }
                            });
                        }
                    }
                });
            }
        }, chatRefreshInterval);
    }

    // refresh header messages updates
    if (subscriptionStatus > 0) {
        // needs to have a valid subscription first
        setInterval(function() {
            if (!GMJS.POLL_FOR_UPDATES) { return; }
            // load messages - only if we're not on the messaging page
            if (($('ul.messages-input').length == 0) && ($('ul#alert-menu').length > 0)) {
                $.ajax({
                    url: pageUrls['messagingUpdatesData'],
                    method: 'post',
                    complete: function(result, status) {
                        if (result.responseText.length > 0) {
                            var response = $.parseJSON(result.responseText);
                            var newEntry = false;
                            var conversationsIds = [];
                            // change counter
                            $('#message-alert .alert-count').text(response.unread);
                            if (Object.keys(response.data).length > 0) {
                                $.each(response.data, function(index, alertBoxData) {
                                    conversationsIds.push(alertBoxData.conversationId);
                                    var message = $('#message-alert-dropdown').find('li[data-message-id="' + alertBoxData.messageId + '"]');
                                    if (message.length < 1) {
                                        newEntry = true;
                                        var conversation = $('#message-alert-dropdown').find('li[data-conversation-id="' + alertBoxData.conversationId + '"]');
                                        var messageAlertBoxHtml =
                                            '<li class="alert-msg-item clear" data-message-id="' + alertBoxData.messageId + '" data-conversation-id="' + alertBoxData.conversationId + '">' +
                                                '<div id="alert-message-' + alertBoxData.messageId + '-canvas" class="clear">' +
                                                    '<span class="name">' + alertBoxData.name + '</span>' +
                                                    '<span class="date">' + alertBoxData.date + '</span>' +
                                                    '<p>' + alertBoxData.text + '</p>';

                                        /* FIXME
                                        if (alertBoxData.isBudgetConversation) {
                                            messageAlertBoxHtml += '<a href="' + alertBoxData.url + '" class="go-to-budget system-link">' +
                                                'Go to budget ' +
                                                '<i class="glyphicon glyphicon-share-alt"></i>' +
                                                '</a>';
                                        }*/
                                        messageAlertBoxHtml +=
                                                '</div>' +
                                            '</li>';

                                        var messageAlertBox = $(messageAlertBoxHtml);
                                        if (conversation.length > 0) {
                                            conversation.replaceWith(messageAlertBox);
                                        }
                                        else {
                                            $('#message-alert-dropdown').prepend(messageAlertBox);
                                        }
                                    }
                                });
                                // remove conversations that are no longer in the list
                                $('#message-alert-dropdown').find('li.alert-msg-item').each(function() {
                                    if ($.inArray($(this).data('conversation-id'), conversationsIds) < 0) {
                                        $(this).remove();
                                    }
                                });
                            }
                            else {
                                // change counter and drop-down content
                                $('#message-alert .alert-count').text(0);
                                $('#message-alert-dropdown').find('li.alert-msg-item').remove();
                            }
                            if (newEntry) {
                                $.playSound(baseUrl + '/audio/soft_1');
                            }
                        }
                    }
                });
            }
            else {
                // reset alerts, since we're on the messaging page
                $('#message-alert .alert-count').removeClass('red').text(0);
            }
        }, chatRefreshInterval);
    }

    // mark message as read
    $('body').on('click', '.alert-msg-item a.mark-as-read, .alert-ntf-item a.mark-as-read', function() {
        var $this = $(this);
        $.ajax({
            url: $(this).attr('href'),
            method: 'post',
            complete: function(result, status) {
                var response = $.parseJSON(result.responseText);
                topScreenNotification(response.message, response.status);
                if (response.status === 'success') {
                    $this.parents('li.alert-ntf-item, li.alert-msg-item').remove();
                }
            }
        });
        return false;
    });
    $('body').on('click', '.notifications-list a.mark-as-read', function() {
        var $this = $(this);
        $.ajax({
            url: $(this).attr('href'),
            method: 'post',
            complete: function(result, status) {
                var response = $.parseJSON(result.responseText);
                topScreenNotification(response.message, response.status);
                if (response.status === 'success') {
                    $this.parents('tr').remove();
                    callbacks['reloadPjaxMain']();
                }
            }
        });
        return false;
    });

    // scroll to bottom of messages history box
    function messagesHistoryScrollDown() {
        setTimeout(function() {
            $('#body').scrollTop($('#body').prop("scrollHeight"));
        }, 300);
    }

    // NOTIFICATIONS
    // refresh header notifications updates
    if (subscriptionStatus > 0) {
        // this makes no sense if there's no valid subscription
        setInterval(function() {
            if (!GMJS.POLL_FOR_UPDATES) { return; }
            if ($('ul#alert-menu').length > 0) {
                // load notifications - only if we're not on the messaging page
                var notificationIds = [];
                var newEntry = false;

                $.ajax({
                    url: pageUrls['notificationUpdatesData'],
                    method: 'post',
                    complete: function(result, status) {
                        if (result.responseText.length > 0) {
                            var response = $.parseJSON(result.responseText);
                            var alertsNumber = Object.keys(response.data).length;

                            if (alertsNumber > 0) {
                                // change counter
                                $('#notification-alert .alert-count').text(alertsNumber);
                                $.each(response.data, function(index, alertBoxData) {
                                    var notification = $('#notification-alert-dropdown').find('li[data-notification-id="' + alertBoxData.notificationId + '"]');
                                    notificationIds.push(alertBoxData.notificationId);

                                    if (notification.length < 1) {
                                        newEntry = true;

                                        var notificationAlertBox = $(
                                            '<li id="alert-notification" class="alert-ntf-item clear" data-notification-id="' + alertBoxData.notificationId + '">' +
                                                '<div id="alert-notification-' + alertBoxData.notificationId + '-canvas" class="option-canvas clear">' +
                                                    '<div id="alert-notification-' + alertBoxData.notificationId + '-options" class="alert-options navmenu-fixed-left offcanvas">' +
                                                        '<a class="btn btn-primary mark-as-read" href="' + alertBoxData.markAsReadUrl + '">Mark as Read</a>' +
                                                        '<a class="btn btn-danger system-link" href="' + alertBoxData.viewUrl + '">View</a>' +
                                                        '<button id="alert-notification-' + alertBoxData.notificationId + '-options-close" class="menu-btn pull-right" data-toggle="offcanvas" data-canvas="#alert-notification-' + alertBoxData.notificationId + '-canvas" data-target="#alert-notification-' + alertBoxData.notificationId + '-options" type="button">' +
                                                            '<span class="glyphicon glyphicon-remove" aria-hidden="true"></span>' +
                                                        '</button>' +
                                                    '</div>' +
                                                    '<div class="alert-ntf-left">' +
                                                        '<div class="alert-ntf-right">' +
                                                            '<div class="notification-icon notification-category-' + alertBoxData.categoryId + '">' +
                                                                '<i class="glyphicon ' + alertBoxData.iconClass + '"></i>' +
                                                            '</div>' +
                                                            '<p>' +
                                                                alertBoxData.content +
                                                                '<span class="date">' + alertBoxData.notificationDate + '</span>' +
                                                            '</p>' +
                                                        '</div>' +
                                                        '<button id="alert-notification-' + alertBoxData.notificationId + '-options-open" class="menu-btn btn-options-open pull-right" data-toggle="offcanvas" data-canvas="#alert-notification-' + alertBoxData.notificationId + '-canvas" data-target="#alert-notification-' + alertBoxData.notificationId + '-options" type="button">' +
                                                            '<span class="glyphicon glyphicon-cog" aria-hidden="true"></span>' +
                                                        '</button>' +
                                                    '</div>' +
                                                '</div>' +
                                            '</li>'
                                        );
                                        $('#notification-alert-dropdown').prepend(notificationAlertBox);
                                    }
                                });

                                // remove notifications that are no longer in the list
                                $('#notification-alert-dropdown').find('li.alert-ntf-item').each(function() {
                                    if ($.inArray($(this).data('notification-id'), notificationIds) < 0) {
                                        $(this).remove();
                                    }
                                });
                            }
                            else {
                                // change counter and drop-down content
                                $('#notification-alert .alert-count').text(0);
                                $('#notification-alert-dropdown').find('li.alert-ntf-item').remove();
                            }
                            if (newEntry) {
                                $.playSound(baseUrl + '/audio/soft_6');
                            }
                        }
                    }
                });
            }
        }, notificationsRefreshInterval);
    }


    // APPOINTMENTS
    // add time-slot input row
    $('body').on('click', '#add-appointment-form .add-time-slot', function() {

        var timeSlot = $('#add-appointment-form .time-slot:first').clone();
        timeSlot.find('input').val('');
        timeSlot.find('div').removeClass('has-error').removeClass('has-success');
        timeSlot.find('.help-block.help-block-error').text('');

        var timeSlotIndex = $('#add-appointment-form .time-slot').length;
        var timeSlotHtml = $('<div>').append(timeSlot).html();
        timeSlotHtml = timeSlotHtml.replace(/\[0\]/g, '[' + timeSlotIndex + ']');
        timeSlotHtml = timeSlotHtml.replace(/-0/g, '-' + timeSlotIndex);

        $('#add-appointment-form .add-time-slot').closest('div').before($(timeSlotHtml));

        this.scrollIntoView();

        return false;

    });

    // remove time-slot input row
    $('body').on('click', '#add-appointment-form .remove-time-slot', function() {

        if ($('#add-appointment-form .time-slot').length > 1) {

            $(this).closest('.time-slot').remove();

        }

        return false;

    });


    // open detail for calendar day

    //********************
    // FORMS
    //********************
    // prevent forms from being submitted
    $('body').on('keydown', 'form', function() {

        if (event.which == 13) {

            if (!$('textarea').is(":focus") && !$('.filters input').is(':focus')) {

                event.preventDefault();

                if ($(ajaxSubmitSelector).is(':focus')) {

                    $(':focus').trigger('click');

                }

            }

        }

    });

    // disable default form functionality
    $('body').on('submit', 'form', function() {

        if (!$(this).hasClass('gridview-filter-form')) {

            return false;

        }

    });

    // AJAX form submission
    $('body').on('click', ajaxSubmitSelector, function() {

        if (isSubmitting) {
            return false;
        }
        isSubmitting = true;
        setTimeout(function() {
            isSubmitting = false;
        }, 1000);

        var url = $(this).data('submit-url') ? $(this).data('submit-url') : window.location.href;
        var thisForm = $(this).closest('form');
        var thisSubmitBtn = $(this);

        // tinyMCE submission hack
        $('.mce-tinymce iframe').each(function() {

            var content = $(this).contents().find('body').html();
            $(this).closest('.mce-tinymce').siblings('text, textarea').val(content);

        });

        var data = new FormData(thisForm[0]);

        // trigger validation - kinda a "hack"
        checkIfFormValid(thisForm, function() {

            var valid = window.formValid;

            if (valid) {

                // show overlay
                thisForm.blockloader();

                $.ajax({
                    url: url,
                    method: 'post',
                    processData: false,
                    contentType: false,
                    data: data,
                    complete: function(result, status) {

                        var message = '';
                        var response = $.parseJSON(result.responseText);
                        thisForm.blockloader('hide');

                        if ((result == '') || (typeof response.status == 'undefined')) {

                            message = '<p class="error">An error occurred.</p>';

                        }
                        else {

                            if (response.status == 'success') {
                                // look for JS callback
                                var jsCallback = thisSubmitBtn.data('js-callback');
                                if (jsCallback && jsCallback.match(/^[a-z0-9]+$/i)) {
                                    // the string matching prevents users from fiddling with the JS callback
                                    callbacks[jsCallback](thisForm);
                                }
                            }
                            else if (response.status == 'redirect') {
                                // allow redirecting only to the current host
                                if (response.url.substring(0, 1) == '/' && response.url.substring(1, 2) != '/') {
                                    window.location.href = response.url;
                                }
                            }
                            else if (response.status == 'error') {
                                message = '<p class="error">' + response.message + '</p>';
                                $('.modal-body').animate({
                                    scrollTop: 0
                                }, 400);
                            }

                        }

                        if (message.length > 0) {

                            if (thisForm.find('.message').length > 0) {
                                thisForm.find('.message').html(message).show();
                            }
                            else {
                                topScreenNotification(response.message, response.status);
                            }

                        }

                        if ((response.status == 'success') && (typeof response.message != 'undefined') && (response.message.length > 0)){

                            topScreenNotification(response.message, response.status);

                        }

                    }
                });

            }

        });

        return false;

    });


    // auto AJAX form submission
    $('body').on('change', ajaxAutoSubmitSelector, function() {

        var thisForm = $(this).closest('form');
        var url = thisForm.data('submit-url') ? thisForm.data('submit-url') : window.location.href;
        var data = new FormData(thisForm[0]);

        // trigger validation - kinda a "hack"
        checkIfFormValid(thisForm, function() {

            var valid = window.formValid;

            if (valid) {

                $.ajax({
                    url: url,
                    method: 'post',
                    processData: false,
                    contentType: false,
                    data: data,
                    complete: function(result, status) {

                        var message = '';
                        var response = $.parseJSON(result.responseText);

                        if ((result == '') || (typeof response.status == 'undefined')) {

                            message = '<p class="error">An error occurred.</p>';

                        }
                        else {

                            if (response.status == 'success') {

                                // look for JS callback
//                                if (jsCallback && jsCallback.match(/^[a-z0-9]+$/i)) {
//                                    // the string matching prevents users from fiddling with the JS callback
//                                    callbacks[jsCallback](thisForm);
//
//                                }

                            }
                            else if (response.status == 'error') {

                                message = '<p class="error">' + response.message + '</p>';

                            }

                        }

                        if (message.length > 0) {

                            thisForm.find('.message').show().html(message);

                        }

                        if ((response.status == 'success') && (typeof response.message != 'undefined') && (response.message.length > 0)){

                            topScreenNotification(response.message, response.status);

                        }

                    }
                });

            }

        });

        return false;

    });

    // close click
    $('body').on('click', '#top-screen-notification i.glyphicon', function() {

        closeTopScreenNotification();

    });

    // check if an Yii active record form is valid
    function checkIfFormValid(form, callback) {

        window.formValidated = false;
        window.formValidCounter = 0;
        var checkInt, endRepeating;

        var formGroups = form.find('.form-group');
        if (formGroups.length > 0) {

            form.yiiActiveForm('submitForm');

            checkInt = setInterval(function() {

                window.formValid = true;

                endRepeating = true;
                window.formValidCounter++;

                formGroups.each(function() {

                    if (!$(this).hasClass('has-success') && !$(this).hasClass('has-error')) {

                        endRepeating = false;
                        return false;

                    }

                    window.formValid *= $(this).hasClass('has-success');

                });

                if (endRepeating || (window.formValidCounter == 20)) {

                    clearInterval(checkInt);
                    callback();
                    return;

                }

            }, 100);

        }
        else {

            window.formValid = true;
            callback();

        }

    }

    //********************
    // MODALS
    //********************
    // open a modal
    $('body').on('click', '.open-modal', function() {

        var url = $(this).data('modal-url');
        openModal(url, !($(this).data('modal-closable') == 0), $(this).data('with-graph') == 1);
        return false;

    });

    //********************
    // FUNCTIONS
    //********************
    function loadConentForUrl(url, container, loadingMessage, callback, pageLoadRequest, popData) {

        popData = popData || null;
        if (container.data('block-loading')) {
            if (container.find('.jqblock-loader').length) {
                container.blockloader('show');
            }
            else {
                if (container.find('> #body').length > 0) {
                    container.blockloader('> #body');
                }
                else {
                    container.blockloader();
                }
            }
        }
        else {
            container.children().hide();
            if (!container.find('.loading-message').length) {
                container.prepend(loadingMessage);
            }
            else {
                container.find('.loading-message').show();
            }
        }

        if (typeof pageLoadRequest == 'undefined' || (pageLoadRequest == false)) {
            pageLoadRequest = 0;
        }
        else {
            pageLoadRequest = 1;
        }

        $.ajax({
            url: url,
            method: 'get',
            data: {pageLoadRequest: pageLoadRequest},
            complete: function(result, status) {

                var body = $('<div>' + result.responseText + '</div>').find('#body');
                if (!body.length) {

                    body = $('<div>' + result.responseText + '</div>').find('div[role="tabpanel"]');

                }

                // main left menu items hide/show
                if (body.is('#body')) {

                    if (body.hasClass('is-mock-budget')) {

                        $('#side-bar-nav ul, #side-bar-nav li').not('.mock-budget-visible').addClass('hidden');
                        $('#side-bar-nav li.only-mock-budget-visible').removeClass('hidden');
                        $('#side-bar-nav li.mock-budget-visible > a, #side-bar-nav li.mock-budget-visible > div > a').each(function() {
                            if ($(this).attr('href').indexOf('budget_id') == -1) {
                                $(this).attr('href', $(this).attr('href') + '?budget_id=' + body.data('mock-budget-id'));
                            }
                        });
                    }
                    else {
                        $('#side-bar-nav ul, #side-bar-nav li').removeClass('hidden');
                        $('#side-bar-nav li.only-mock-budget-visible').addClass('hidden');
                        $('#side-bar-nav li.mock-budget-visible > a, #side-bar-nav li.mock-budget-visible > div > a').each(function() {
                            if ($(this).attr('href').indexOf('?') > -1) {
                                $(this).attr('href', $(this).attr('href').substr(0,$(this).attr('href').indexOf('?')));
                            }
                        });
                    }
                }

                // look whether this is a partial load or not
                var partials = body.find('[data-partial-load="1"]');
                if (partials.length) {

                    partials.each(function() {

                        $('.content-container').find($(this).data('target-selector')).replaceWith($(this).prop('outerHTML'));

                    });

                    if (window.lastLoadedPageType) {

                        $('#body').data(detailPages[window.lastLoadedPageType]['idAttr'], body.data(detailPages[window.lastLoadedPageType]['idAttr']));

                    }

                }
                // selector can be passed also via popState data field
                else if (popData) {

                    $('.content-container').find('#' + popData.id).replaceWith(body.find('#' + popData.id).prop('outerHTML'));

                }
                else {

                    container.html(result.responseText);

                }

                if (container.data('block-loading')) {

                    container.blockloader('hide');

                }
                else {

                    container.children().show();
                    container.find('.loading-message').hide();

                }

                if (body.length > 0) {

                    // look for JS callback
                    var jsCallback = body.data('js-callback');
                    if (jsCallback) {

                        callbacks[jsCallback]();

                    }

                    // look for menu link to activate
                    mainNav.find('li.active').removeClass('active');

                    var selectMenu = body.data('select-menu');
                    if (selectMenu) {

                        var newItem = mainNav.find(selectMenu);
                        newItem.addClass('active');

                        if (!newItem.hasClass('panel')) {
                            newItem.closest('li.panel').addClass('active').children('ul').addClass('in');
                            newItem.closest('li.panel').find('.glyphicon-plus').addClass('glyphicon-minus');
                            mainNav.find('li.panel ul').not(newItem.closest('li.panel ul')).removeClass('in');
                            mainNav.find('li.panel').not(newItem.closest('li.panel')).find('.glyphicon-plus').removeClass('glyphicon-minus');
                        }
                        else {
                            mainNav.find('li.panel ul').removeClass('in');
                        }

                    }

                    // look for page title
                    var pageTitle = body.data('page-title');
                    if (pageTitle) {
                        document.title = pageTitle;
                    }

                    // callback
                    if ((typeof callback != 'undefined') && callback) {
                        callback();
                        window.nextUrlChangeCallback = false;
                    }
                }

                if (subscriptionStatus == 0) {
                    topScreenNotification('Your subscription has expired.', 'error');
                }
                else if (subscriptionStatus == -1) {
                    topScreenNotification('Please select your subscription.', 'error');
                }

                if ($('body').data('no-userdetails') == '1') {
                    openModal(pageUrls['editUser'] + '?no_close=1&user-details=1', false);
                }

                if (url.indexOf('delete=1') > 0) {
                    topScreenNotification(
                        'Please now confirm deletion of the associated account first.<br/>' +
                        'Only after the account is removed, the debt will be removed as well.',
                        'success'
                    );
                    $('.open-modal.delete-btn').trigger('click');
                }

                if ($('#secondary-side-bar-nav.lessons').length) {
                    setTimeout(function () {
                        $('#secondary-side-bar-nav.lessons .group .expand').addClass('animated');
                    }, 300);
                }
            }
        });

    }

    //********************
    // LIB INITS
    //********************
    // dataTables
    function initDataTables() {

        //check if there's something to initialize first
        if (!$('.data-table.dataTable').length) {

            $('.data-table').each(function() {

                var table = $(this);

                // get sorting info
                var sortOrder = 0;
                var sortDir = 'asc';
                var sortColumn = table.find('th.sort-by');
                if (sortColumn.length) {
                    sortOrder = sortColumn.index();
                    if (sortColumn.hasClass('sort-desc')) {
                        sortDir = 'desc';
                    }
                }
                var paginate = true;
                if (table.data('no-paging')) {
                    table.parent().addClass('no-paging');
                    paginate = false;
                }

                table.DataTable({
                    "sPaginationType": "listbox",
                    "bPaginate": paginate,
                    "oLanguage": {
                        "sLengthMenu": '<a href="#" class="showRecords active" data-page="5">5</a>' +
                                '<a href="#" class="showRecords" data-page="10">10</a>' +
                                '<a href="#" class="showRecords" data-page="20">20</a>' +
                                '<a href="#" class="showRecords" data-page="50">50</a>' +
                                '<a href="#" class="showRecords all" data-page="-1">All</a>',
                        "sProcessing": '<img src="' + baseUrl + '/imgs/dt-loading.gif" alt="loading" />'
                    },
                    "sDom": '<"table-head-paging"pr<"previous"><"next">>rt<"table-foot-paging"i<"legend">l><"clear">',
                    "iDisplayLength": 5,
                    "lengthChange": true,
                    "processing": true,
                    "serverSide": true,
                    "autoWidth": false,
                    "order": [[sortOrder, sortDir]],
                    "footerCallback": function(row, data, start, end, display) {
                        var tapi = this.api();
                        if (table.data('ajax-footer') && table.data('footer-column')) {
                            $.get(table.data('ajax-footer'), function(result) {
                                $(tapi.column(table.data('footer-column')).footer()).html(result);
                            });
                        }
                    },
                    "preDrawCallback": function() {
                        $('.dataTables_wrapper').each(function() {
                            // resize container
                            var contHeight = $(this).find('tbody').height() - 17;
                            var cont = $(this).children('.dataTables_processing');
                            cont.height(contHeight);
                            // position loading gif
                            var gifMarginTop = contHeight / 2 - 12;
                            $(cont).children('img').css('margin-top', gifMarginTop + 'px');
                            // position loading container
                            var headPagingHeight = $(this).find('.table-head-paging').height();
                            var headerHeight = $(this).find('thead tr:first').height();
                            cont.css('top', (headPagingHeight + headerHeight + 27) + 'px');
                        });
                        return true;
                    },
                    "fnRowCallback": function(nRow, aData) {
                        // Following changes row/cell based on <span> elements containing extra data
                        // row backgrounds
                        if ((aData[0].indexOf('row-bg-blue') != -1) && (!$(nRow).hasClass('blue-bg'))) {
                            $(nRow).css('background-color', 'rgb(233, 245, 255)').addClass('blue-bg');
                        }
                        if ((aData[0].indexOf('row-bg-red') != -1) && (!$(nRow).hasClass('red-bg'))) {
                            $(nRow).css('background-color', 'rgb(255, 233, 233)').addClass('red-bg');
                        }
                        if ((aData[0].indexOf('row-bg-green') != -1) && (!$(nRow).hasClass('green-bg'))) {
                            $(nRow).css('background-color', 'rgb(218, 255, 219)').addClass('green-bg');
                        }
                        if ((aData[0].indexOf('row-bg-grey') != -1) && (!$(nRow).hasClass('grey-bg'))) {
                            $(nRow).css('background-color', 'rgb(248, 248, 250)').addClass('grey-bg');
                        }

                        var i = 0;
                        $.each(aData, function(index, content) {
                            var thisTd = $(nRow).find('td').eq(i);
                            // inline inputs
                            if (String(content).indexOf('inline-input-text') != -1) {
                                // add classes & data
                                thisTd.addClass($('<div>' + content + '</div>').find('span.inline-input-text').attr('class')).addClass('inline-input');
                                thisTd.attr('data-ajax', $('<div>' + content + '</div>').find('span.inline-input-text').data('ajax'));
                                thisTd.attr('data-name', $('<div>' + content + '</div>').find('span.inline-input-text').data('name'));
                                thisTd.attr('data-name-before', $('<div>' + content + '</div>').find('span.inline-input-text').data('name-before'));
                                // remove span
                                thisTd.find('span.inline-input-text').remove();
                            }
                            // center content
                            if (String(content).indexOf('center-content') != -1) {
                                // add classes & data
                                thisTd.css('text-align', 'center');
                                // remove span
                                thisTd.find('span.center-content').remove();
                            }
                            i++;
                        });
                    },
                    "fnDrawCallback": function() {
                        if ($(this).siblings('.table-head-paging').find('.dataTables_paginate .form-control option').length < 2) {
                            $(this).siblings('.table-head-paging').find('.dataTables_paginate .form-control').hide();
                        }
                        else {
                            $(this).siblings('.table-head-paging').find('.dataTables_paginate .form-control').show();
                        }
                    }
                });

                // so only the table can be scrolled (not the header and footer)
                setTimeout(function() {
                    table.wrap('<div class="table-scroll-container"></div>');
                }, 500);
            });

            // table navigation
            $(".dataTables_wrapper .previous").html('<a href="#"><span class="glyphicon glyphicon-triangle-left"></span></a>');
            $(".dataTables_wrapper .next").html('<a href="#"><span class="glyphicon glyphicon-triangle-right"></span></a>');
            $(".dataTables_wrapper .legend").html('<span class="glyphicon glyphicon-triangle-bottom ico-spend"></span>Spend<span class="glyphicon glyphicon-triangle-top ico-receive"></span>Receive<span class="glyphicon glyphicon-triangle-right ico-transfer"></span>Transfer');
        }

        // special case for secondary sorting feature
        $('body').on('preXhr.dt', '.secondary-date-sorting', function(e, settings, data) {
            var table = $('.secondary-date-sorting').DataTable(),
                theOrder = table.order();
            if (theOrder.length == 1 && theOrder[0][0] != 0) {
                theOrder.push([0, 'desc']);
                table.order(theOrder);
                data['order[1][column]'] = 0;
                data['order[1][dir]'] = 'desc';
            }
        });
    }

    // DataTables navigation
    // next/prev buttons
    $('body').on('click', '.dataTables_wrapper .next', function() {
        var tableSelector = '#' + $(this).closest('.dataTables_wrapper').find('table').attr('id');
        $(tableSelector).DataTable().page('next').draw('page');
        return false;
    });

    $('body').on('click', '.dataTables_wrapper .previous', function() {
        var tableSelector = '#' + $(this).closest('.dataTables_wrapper').find('table').attr('id');
        $(tableSelector).DataTable().page('previous').draw('page');
        return false;
    });

    // show X records per table
    $('body').on('click', '.dataTables_wrapper .showRecords', function() {
        var qtd = $(this).attr('data-page');
        var tableSelector = '#' + $(this).closest('.dataTables_wrapper').find('table').attr('id');
        $(tableSelector).DataTable().page.len(qtd).draw();
        $(tableSelector).find('.showRecords').removeClass('active');
        $(this).siblings().removeClass('active');
        $(this).addClass('active');
        if ($(this).hasClass('all')) {
            $(tableSelector).closest('.dataTables_wrapper').find('.table-head-paging .form-control').hide();
        }
        else {
            $(tableSelector).closest('.dataTables_wrapper').find('.table-head-paging .form-control').show();
        }
        return false;
    });

    // table search
    $('body').on('keyup', '.table-search', function() {
        var searchId = $(this).attr('data-search-id');
        $("table[data-table-id='" + searchId + "']").DataTable().search(this.value).draw();
    });

    // table date limit
    $('body').on('change', 'input[name=bs_start], input[name=bs_end]', function() {
        var params =
            '&bs_start=' + $('input[name=bs_start]').val() +
            '&bs_end=' + $('input[name=bs_end]').val();
        $('#bsh-table-1').DataTable().ajax.url($('#bsh-table-1').data('ajax') + params);
        $('#bsh-table-1').DataTable().ajax.reload();
    });

    // DataTables inline input functionality
    // text input
    var contentBefore;
    $('body').on('click', '.dataTables_wrapper td.inline-input-text', function() {

        $(this).attr('data-old-value', content);

        if (!$(this).hasClass('open')) {

            $val = $(this).find('span[data-value]');

            if ($val) {
                var content = $val.text();
            } else {
                var content = $(this).html();
            }
            $(this).addClass('open');

            if ($(this).hasClass('numeric')) {
                content = content.replace(/[^\d.-]/g, '');
            }
            contentBefore = content;

            $(this).html('<input type="text" value="' + content + '">').find('input').focus();
        }

    });

    // submit inline input
    $('body').on('blur keyup', 'td.inline-input.open input', function(e) {

        if ((e.type == 'focusout' || (e.type == 'keyup' && e.keyCode == 13)) && !$(this).closest('td').hasClass('processing')) {

            $(this).closest('td').addClass('processing');

            var input = $(this);
            var dataName = $(this).closest('td').data('name');
            var dataNameBefore = $(this).closest('td').data('name-before');
            var data = {};
            data[dataName] = $(this).val();
            data[dataNameBefore] = contentBefore;

            $.ajax({
                url: $(this).closest('td').data('ajax'),
                method: 'post',
                data: data,
                complete: function(result) {

                    var response = $.parseJSON(result.responseText);

                    input.closest('td').removeClass('open processing');

                    // check if message
                    if (typeof response.message != 'undefined') {

                        input.closest('td').html(input.closest('td').data('old-value'));
                        topScreenNotification(response.message, response.status);

                    }
                    else {


                        input.closest('td').html(response.value);

                        if ((typeof response.jsCallback != 'undefined') && response.jsCallback.length) {

                            callbacks[response.jsCallback]();

                        }

                    }

                }
            });

        }

    });

    function initDynamicContent(id) {

        var selector = '.dynamic-content';
        if (typeof id != 'undefined') {
            selector += '#' + id;
        }

        if ($(selector).length <= 0) {
            return;
        }
        $(selector).each(function() {
            var $this = $(this);
            $this.blockloader();
            $.get($this.data('ajax'),
                function(result) {
                    $this.html(result);
                    var elementId = $this.parent().attr('id');
                    if (elementId.length > 0) {
                        dashboardPanelViewMore(elementId);
                    }
                }
            );
        });

    }

    // graph arrows functionality
    $('body').on('click', '.data-graph .carousel-control', function() {

        var firstYear, lastYear, firstMonth = 0, lastMonth = 0;
        var slider = $(this).closest('.data-graph');
        if (!slider.hasClass('loaded')) {
            return false;
        }
        var loadNewPage = false;
        var thisElem = $(this);

        if (thisElem.hasClass('right')) {
            if (slider.find('.item:last').hasClass('active')) {
                loadNewPage = true;
                // month/year handling
                if (slider.data('last-month')) {
                    lastMonth = parseInt(slider.data('last-month')) + 1;
                    lastYear = parseInt(slider.data('last-year'));
                    if (lastMonth > 12) {
                        lastMonth = 1;
                        lastYear++;
                    }
                }
                else {
                    lastYear = parseInt(slider.data('last-year')) + 1;
                }
            }
        }
        else {
            if (slider.find('.item').index(slider.find('.item.active')) == 0) {
                loadNewPage = true;
                firstYear = parseInt(slider.data('first-year')) - 1;
                // month/year handling
                if (slider.data('first-month')) {
                    firstMonth = parseInt(slider.data('first-month')) - 1;
                    firstYear = parseInt(slider.data('first-year'));
                    if (firstMonth == 0) {
                        firstMonth = 12;
                        firstYear--;
                    }
                }
                else {
                    firstYear = parseInt(slider.data('first-year')) - 1;
                }
            }
        }

        if (loadNewPage) {
            if (!slider.hasClass('loaded')) {
                return;
            }

            // @todo show loading overlay
            $.ajax({
                url: slider.data('ajax'),
                method: 'get',
                data: {
                    'year': (thisElem.hasClass('right')) ? lastYear : firstYear,
                    'month': (thisElem.hasClass('right')) ? lastMonth : firstMonth,
                    'account_id': slider.data('account-id')
                },
                complete: function(result) {

                    var response = $.parseJSON(result.responseText);

                    if (response) {

                        slider.removeClass('loaded');

                        var item = '<div class="item"><div class="chart-title">' + response.title + '</div><div class="ct-chart"></div></div>';

                        if (thisElem.hasClass('right')) {

                            slider.find('.carousel-inner').append(item);
                            slider.find('.item:last').css({
                                'opacity': 0,
                                'display': 'block',
                                'position': 'absolute',
                                'width': '100%'
                            });

                        }
                        else {

                            slider.find('.carousel-inner').prepend(item);
                            slider.find('.item:first').css({
                                'opacity': 0,
                                'display': 'block',
                                'position': 'absolute',
                                'width': '100%'
                            });

                        }

                        if (thisElem.hasClass('right')) {

                            slider.data('last-year', response.year);
                            lastYear = response.year

                            if (lastMonth) {

                                slider.data('last-month', response.month);
                                lastMonth = response.month;

                            }

                        }
                        else {

                            slider.data('first-year', response.year);
                            firstYear = response.year

                            if (firstMonth) {

                                slider.data('first-month', response.month);
                                firstMonth = response.month;

                            }

                        }

                        var newGraph = (thisElem.hasClass('right')) ? slider.find('.ct-chart:last') : slider.find('.ct-chart:first');

                        if (slider.hasClass('line-graph')) {

                            new Chartist.Line(newGraph[0], {
                                labels: response.labels,
                                series: response.series,
                            },
                                    {
                                        axisX: {
                                            showGrid: false
                                        },
                                        high: response.max + 100,
                                        low: response.min - 100,
                                        plugins: [
                                            Chartist.plugins.legend()
                                       ]
                                    }
                            ).on('created', function() {

                                if (thisElem) {

                                    if (thisElem.hasClass('right')) {

                                        slider.find('.item:last').css({
                                            'opacity': '',
                                            'display': '',
                                            'position': '',
                                            'width': ''
                                        }).find('.ct-chart').addClass('loaded');

                                        setTimeout(function() {

                                            slider.addClass('loaded');
                                            slider.carousel('next');

                                        }, 100);

                                    }
                                    else {

                                        slider.find('.item:first').css({
                                            'opacity': '',
                                            'display': '',
                                            'position': '',
                                            'width': ''
                                        }).find('.ct-chart').addClass('loaded');

                                        setTimeout(function() {

                                            slider.addClass('loaded');
                                            slider.carousel('prev');

                                        }, 100);

                                    }

                                }

                                thisElem = false;

                            });

                        }
                        else if (slider.hasClass('bar-graph-1')) {

                            new Chartist.Bar(newGraph[0], {
                                labels: response.labels,
                                series: response.series
                            },
                            {
                                stackBars: true,
                                axisX: {
                                    showGrid: false
                                },
                                height: 250,
                                plugins: [
                                    Chartist.plugins.legend(),
                                    Chartist.plugins.tooltip({
                                        currency: currencySymbol
                                    })
                               ]
                            }).on('draw', function(data) {

                                // responsive bar width
                                if (slider.width() > 750) {

                                    if (data.type === 'bar') {
                                        data.element.attr({
                                            style: 'stroke-width: 50px'
                                        });
                                    }

                                }
                                else if (slider.width() > 510) {

                                    if (data.type === 'bar') {
                                        data.element.attr({
                                            style: 'stroke-width: 30px'
                                        });
                                    }

                                }
                                else {

                                    if (data.type === 'bar') {
                                        data.element.attr({
                                            style: 'stroke-width: 15px'
                                        });
                                    }

                                }

                            }).on('created', function() {

                                if (thisElem) {

                                    if (thisElem.hasClass('right')) {

                                        slider.find('.item:last').css({
                                            'opacity': '',
                                            'display': '',
                                            'position': '',
                                            'width': ''
                                        }).find('.ct-chart').addClass('loaded');

                                        setTimeout(function() {

                                            slider.addClass('loaded');
                                            slider.carousel('next');

                                        }, 100);

                                    }
                                    else {

                                        slider.find('.item:first').css({
                                            'opacity': '',
                                            'display': '',
                                            'position': '',
                                            'width': ''
                                        }).find('.ct-chart').addClass('loaded');

                                        setTimeout(function() {

                                            slider.addClass('loaded');
                                            slider.carousel('prev');

                                        }, 100);

                                    }

                                }

                                thisElem = false;

                            });

                        }
                        else if (slider.hasClass('bar-graph-2')) {

                            new Chartist.Bar(newGraph[0], {
                                labels: response.labels,
                                series: response.series
                            },
                            {
                                seriesBarDistance: 10,
                                axisX: {
                                    showGrid: false
                                },
                                height: 250,
                                plugins: [
                                    Chartist.plugins.legend(),
                                    Chartist.plugins.tooltip({
                                        currency: currencySymbol
                                    })
                               ]
                            }).on('created', function() {

                                if (thisElem) {

                                    if (thisElem.hasClass('right')) {

                                        slider.find('.item:last').css({
                                            'opacity': '',
                                            'display': '',
                                            'position': '',
                                            'width': ''
                                        }).find('.ct-chart').addClass('loaded');

                                        setTimeout(function() {

                                            slider.addClass('loaded');
                                            slider.carousel('next');

                                        }, 100);

                                    }
                                    else {

                                        slider.find('.item:first').css({
                                            'opacity': '',
                                            'display': '',
                                            'position': '',
                                            'width': ''
                                        }).find('.ct-chart').addClass('loaded');

                                        setTimeout(function() {

                                            slider.addClass('loaded');
                                            slider.carousel('prev');

                                        }, 100);

                                    }

                                }

                                thisElem = false;

                            });

                        }

                    }
                    else {

                        slider.addClass('loaded');

                    }

                }
            });

        }
        else {

            if (thisElem.hasClass('right')) {

                slider.carousel('next');

            }
            else {

                slider.carousel('prev');

            }

        }

    });

    // reload graphs after resize
    var resizeTimeout;
    $(window).resize(function() {
        clearTimeout(resizeTimeout);
        resizeTimeout = setTimeout(function() {

            $('.data-graph').each(function() {

                if (!$(this).is(':visible')) {
                    // we're assuming this graph would be a hidden tab
                    $(this).closest('.tab-pane').not(':visible').css({
                        display: 'block',
                        position: 'absolute',
                        left: '-100%',
                        top: 0,
                        width: $(this).closest('.tab-content').width() + 'px'
                    });

                    $(this).find('.item.active').css({
                        'opacity': 0,
                        'display': 'block',
                        'position': 'absolute',
                        'width': '100%'
                    });

                }

                $(this).find('.item:not(.active)').css({
                    'opacity': 0,
                    'display': 'block',
                    'position': 'absolute',
                    'width': '100%'
                });

                $(this).find('.ct-chart').each(function(index, e) {

                    var item = $(this).closest('.item');

                    e.__chartist__.update().on('created', function() {

                        item.css({
                            'opacity': '',
                            'display': '',
                            'position': '',
                            'width': ''
                        });

                    });

                    // fallback because retarded update doesn't trigger "created" unless something changes
                    setTimeout(function() {
                        item.css({
                            'opacity': '',
                            'display': '',
                            'position': '',
                            'width': ''
                        });
                    }, 100);

                });

                var graph = $(this);

                graph.closest('.tab-pane').css({
                    display: '',
                    position: '',
                    left: '',
                    top: '',
                    width: ''
                });

            });

        }, 300);

    });

    // RESPONSE CALLBACKS
    var callbacks = [];
    callbacks['bodyLoaded'] = function(loadGraphs) {

        if (typeof loadGraphs == 'undefined') {
            loadGraphs = true; // default to true
        }

        $("body").trigger("click");
        initDataTables();

        // Initialize tooltips when new data is loaded into the page via ajax
        $('[data-toggle="tooltip"]').tooltip();

        // report tooltips only on smaller screens
        if($(window).width() < 1280) {
            $('ul.reports li a').tooltip();
        }

        // Make all tabbed layout's nav column scrollable and conform to the content's height
        $('.tabpanel-secondary').each(function() {
            var $tab = $(this);
            setTimeout(function() {
                var $nav = $tab.find('.tab-col');
                var contentHeight = $tab.find('.tab-content').outerHeight();
                var navHeight = $nav.outerHeight();
                if (navHeight > contentHeight) {
                    $nav.css({'max-height': contentHeight});
                }
            }, 500);
        });

        if ($('#secondary-side-bar').length) {
            $('#content').addClass('secondary-nav');
        }
        else {
            $('#content').removeClass('secondary-nav');
        }

        if (loadGraphs) {
            initGraphs();
        }

        initDynamicContent();

        // opening specific faq question
        if ($('.row.faqs').length > 0 && window.location.hash.length > 0) {
            $("[href='" + window.location.hash + "'].pageLink.collapsed").removeClass('collapsed');
            $(window.location.hash).addClass('in');
            $('html, body').animate({
                scrollTop: $(window.location.hash).offset().top
            }, 500);
        }

        // dashboard styling
        dashboardPanelViewMore();

        GMJS.C.SHOW_VIDEO_TUTORIAL();
    };
    callbacks['clearForm'] = function(form) {
        form.find('input, textarea, select').val('');
    };
    callbacks['ftsTransactionsAdded'] = function(form) {
        window.location.href = $('.fts-next-step').attr('href');
    };
    callbacks['lessonsMainPageLoaded'] = function() {
        callbacks['bodyLoaded']();
        if ($('ul#secondary-side-bar-nav.lessons .group').length && $('ul#secondary-side-bar-nav.lessons .group li').length) {
            History.replaceState(null, loadingTitle, $('ul#secondary-side-bar-nav.lessons .group:first li:first a').attr('href'));
        }
    };
    callbacks['lessonsPageLoaded'] = function() {
        callbacks['bodyLoaded']();
        var currentHref = window.location.href.split(window.location.host)[1],
            $link = $('ul#secondary-side-bar-nav.lessons a[href="' + currentHref + '"]');
        if ($link.length) {
            $link.parent().addClass('active');
            $link.parents('.group').addClass('active opened');
        }
    };
    callbacks['jarsLoaded'] = function() {
        callbacks['bodyLoaded']();
        if ($('ul#secondary-side-bar-nav.jars li').length) {
            History.replaceState(null, loadingTitle, $('ul#secondary-side-bar-nav.jars li:first a').attr('href'));
            $('ul#secondary-side-bar-nav > li').removeClass('active');
            $('ul#secondary-side-bar-nav.jars li:first').addClass('active');
        }
    };
    callbacks['jarDetailLoaded'] = function() {
        $('ul#secondary-side-bar-nav.jars li').removeClass('active');
        $('ul#secondary-side-bar-nav.jars li[data-jar-id="' + $('#body').data('jar-id') + '"]').addClass('active');
        callbacks['bodyLoaded']();
    };
    callbacks['conversationsLoaded'] = function() {
        callbacks['bodyLoaded']();
        if ($('ul#secondary-side-bar-nav.conversation-clients li').length) {
            History.replaceState(null, loadingTitle, $('ul#secondary-side-bar-nav.conversation-clients li:first a').attr('href'));
            $('ul#secondary-side-bar-nav > li').removeClass('active');
            $('ul#secondary-side-bar-nav.conversation-clients li:first').addClass('active');
        }
    };
    callbacks['closeModal'] = function(callback) {
        $('#appModal').modal('hide');
        if ((typeof callback == 'string') || (typeof callback == 'function')) {
            callback();
        }
    };
    callbacks['reloadJarSummary'] = function(callback) {

        // close modal
        callbacks['closeModal']();
        if (typeof callback == 'undefined' || typeof callback == 'function') {
            callback();
        }
        callbacks['reloadPage']();

    };
    callbacks['reloadJarsAfterModal'] = function(callback) {
        // close modal
        callbacks['closeModal']();
        // reload jars panel
        var activeJar = $('#secondary-side-bar ul.jars li.active');
        var activeJarId = (activeJar.length > 0) ? activeJar.data('jar-id') : false;
        data = {};
        if ($('#body').is('.is-mock-budget')) {
            data['budget_id'] = $('#body').data('mock-budget-id');
        }
        $.ajax({
            url: pageUrls['jars'],
            data: data,
            method: 'get',
            complete: function(result, status) {
                var jarsList = $('<div>' + result.responseText + '</div>').find('#secondary-side-bar-nav');
                if (activeJarId) {
                    jarsList.find('li[data-jar-id="' + activeJarId + '"]').addClass('active');
                }
                $('#secondary-side-bar ul.jars').html(jarsList);
                if (typeof callback != 'undefined') {
                    callback();
                }
            }
        });
    };
    callbacks['reloadJarsInfo'] = function(callback) {

        // reload jars panel
        var activeJar = $('#secondary-side-bar ul.jars li.active');
        var activeJarId = (activeJar.length > 0) ? activeJar.data('jar-id') : false;

        $.ajax({
            url: pageUrls['jars'],
            method: 'post',
            complete: function(result, status) {

                var newJars = $('<div>' + result.responseText + '</div>').find('#secondary-side-bar-nav.jars li');

                var jarsList = $('#secondary-side-bar-nav.jars');

                newJars.each(function() {

                    jarsList.find('li[data-jar-id="' + $(this).data('jar-id') + '"] .info').html($(this).find('.info').html());

                });

                if (typeof callback != 'undefined') {

                    callback();

                }

            }

        });

    };
    callbacks['reloadJarsAfterCreate'] = function() {

        var jarIds = [];

        $('.jars li[data-jar-id]').each(function() {

            jarIds.push($(this).data('jar-id'));

        });

        callbacks['reloadJarsAfterModal'](function() {

            $('.jars li[data-jar-id]').each(function() {

                if (jarIds.indexOf($(this).data('jar-id')) < 0) {

                    $('.jars li[data-jar-id]').removeClass('active');
                    $(this).addClass('active');
                    History.pushState(null, loadingTitle, $(this).find('a').attr('href'));

                }

            });

        });

    };
    callbacks['reloadJarsAfterEdit'] = function() {

        callbacks['reloadJarsAfterModal'](function() {

            $('.jar-container h3:not(.mock-budget-header h3):first').html($('ul.nav.jars li.active h4').html());
            callbacks['reloadExpenseJarHeaderInfo']();

        });

    };
    callbacks['reloadJarsAfterRemove'] = function() {

        callbacks['reloadJarsAfterModal'](function() {

            $('ul#secondary-side-bar-nav.jars li:first a').trigger('click');
            callbacks['reloadExpenseJarHeaderInfo']();

        });

    };
    callbacks['reloadJarsAfterRestore'] = function() {

        var jarId = $('#restore-jar-form').data('jar-id');

        window.nextUrlChangeCallback = function() {

            $('ul#secondary-side-bar-nav.jars li[data-jar-id="' + jarId + '"] a').trigger('click');

        }

        callbacks['closeModal']();
        History.pushState(null, loadingTitle, pageUrls['jars']);

    };
    callbacks['reloadExpenseJarRecurringExpenses'] = function(reloadRelated) {

        callbacks['reloadJarsAfterModal'](function() {

            callbacks['reloadExpenseJarHeaderInfo']();
            callbacks['reloadExpenseJarRecurringExpensesTableInfo']();
            $('#re-table-1').DataTable().ajax.reload();
            $('#t-table-1').DataTable().ajax.reload();

        });

    };
    callbacks['reloadExpenseJarEstimatedExpenses'] = function(reloadRelated) {

        callbacks['reloadJarsAfterModal'](function() {

            callbacks['reloadExpenseJarHeaderInfo']();
            callbacks['reloadExpenseJarEstimatedExpensesTableInfo']();
            $('#ee-table-1').DataTable().ajax.reload();
            $('#t-table-1').DataTable().ajax.reload();

        });

    };
    callbacks['reloadExpenseJarOnetimeExpenses'] = function(reloadRelated) {

        callbacks['reloadJarsAfterModal'](function() {

            callbacks['reloadExpenseJarHeaderInfo']();
            callbacks['reloadExpenseJarOnetimeExpensesTableInfo']();
            $('#oe-table-1').DataTable().ajax.reload();
            $('#t-table-1').DataTable().ajax.reload();

        });

    };
    callbacks['reloadExpenseJarExpenses'] = function() {

        callbacks['reloadJarsAfterModal'](function() {

            callbacks['reloadExpenseJarHeaderInfo']();
            callbacks['reloadExpenseJarRecurringExpensesTableInfo']();
            callbacks['reloadExpenseJarOnetimeExpensesTableInfo']();
            callbacks['reloadExpenseJarEstimatedExpensesTableInfo']();
            callbacks['reloadExpenseJarTransactionsTableInfo']();
            $('#oe-table-1').DataTable().ajax.reload();
            $('#re-table-1').DataTable().ajax.reload();
            $('#ee-table-1').DataTable().ajax.reload();
            $('#t-table-1').DataTable().ajax.reload();

        });

    }
    callbacks['reloadExpenseJarTransactions'] = function() {

        callbacks['reloadJarsAfterModal'](function() {

            callbacks['reloadExpenseJarHeaderInfo']();
            callbacks['reloadExpenseJarRecurringExpensesTableInfo']();
            callbacks['reloadExpenseJarOnetimeExpensesTableInfo']();
            callbacks['reloadExpenseJarEstimatedExpensesTableInfo']();
            $('#t-table-1').DataTable().ajax.reload();
            callbacks['reloadExpenseJarTransactionsTableInfo']();

        });

    }
    callbacks['reloadExpenseJarInfoAfterTransactionAmountUpdate'] = function() {

        callbacks['reloadJarsAfterModal'](function() {

            callbacks['reloadExpenseJarHeaderInfo']();
            $('#oe-table-1').DataTable().ajax.reload();
            callbacks['reloadExpenseJarOnetimeExpensesTableInfo']();
            callbacks['reloadExpenseJarTransactionsTableInfo']();
            callbacks['reloadExpenseJarEstimatedExpensesTableInfo']();

        });

    }
    callbacks['reloadExpenseJarHeaderInfo'] = function() {

        var activeJarId = $('.jar-container #body').data('jar-id');

        updateElementsHtmlFromSource(pageUrls['expenseJarHeaderInfo'], {
            'id': activeJarId
        });

    }
    callbacks['reloadExpenseJarRecurringExpensesTableInfo'] = function() {

        var activeJarId = $('.jar-container #body').data('jar-id');

        updateElementsHtmlFromSource(pageUrls['expenseJarRecurringExpensesTableInfo'], {
            'jar_id': activeJarId
        });

    }
    callbacks['reloadExpenseJarEstimatedExpensesTableInfo'] = function() {

        var activeJarId = $('.jar-container #body').data('jar-id');

        updateElementsHtmlFromSource(pageUrls['expenseJarEstimatedExpensesTableInfo'], {
            'jar_id': activeJarId
        });

    }
    callbacks['reloadExpenseJarOnetimeExpensesTableInfo'] = function() {

        var activeJarId = $('.jar-container #body').data('jar-id');

        updateElementsHtmlFromSource(pageUrls['expenseJarOnetimeExpensesTableInfo'], {
            'jar_id': activeJarId
        });

    }
    callbacks['reloadExpenseJarTransactionsTableInfo'] = function() {

        var activeJarId = $('.jar-container #body').data('jar-id');

        updateElementsHtmlFromSource(pageUrls['expenseJarTransactionsTableInfo'], {
            'jar_id': activeJarId
        });

    }
    callbacks['reloadDebtJarAfterDebtAdd'] = function() {

        callbacks['reloadJarsAfterModal'](function() {

            callbacks['reloadDebtJarHeaderInfo']();
            $('#d-table-1').DataTable().ajax.reload();
            callbacks['reloadDebtsTableInfo']();
            $('#dp-table-1').DataTable().ajax.reload();

        });

    };
    callbacks['reloadDebtJarAfterDebtPause'] = function() {

        callbacks['closeModal']();
        $('#d-table-1').DataTable().ajax.reload();
        callbacks['reloadDebtsTableInfo']();

    };
    callbacks['reloadDebtJarAfterDebtPaymentAdd'] = function() {

        callbacks['reloadJarsAfterModal'](function() {

            callbacks['reloadDebtJarHeaderInfo']();
            $('#d-table-1').DataTable().ajax.reload();
            $('#dp-table-1').DataTable().ajax.reload();
            callbacks['reloadDebtsTableInfo']();

        });

    };
    callbacks['reloadDebtJarAfterDebtPaymentDelete'] = function() {

        callbacks['reloadJarsAfterModal'](function() {

            callbacks['reloadDebtJarHeaderInfo']();
            $('#d-table-1').DataTable().ajax.reload();
            $('#dp-table-1').DataTable().ajax.reload();
            callbacks['reloadDebtsTableInfo']();
            callbacks['reloadDebtJarDebtPaymentsTableInfo']();

        });

    };
    callbacks['reloadDebtJarHeaderInfo'] = function() {

        var activeJarId = $('.jar-container #body').data('jar-id');

        updateElementsHtmlFromSource(pageUrls['debtJarHeaderInfo'], {
            'id': activeJarId
        });

    }
    callbacks['reloadDebtJarAfterDebtPaymentAmountEdit'] = function() {

        callbacks['reloadJarsAfterModal'](function() {

            callbacks['reloadDebtJarHeaderInfo']();
            $('#d-table-1').DataTable().ajax.reload();
            callbacks['reloadDebtsTableInfo']();
            callbacks['reloadDebtJarDebtPaymentsTableInfo']();

        });

    }
    callbacks['reloadDebtJarDebtPaymentsTableInfo'] = function() {

        var budgetId = 0;
        if ($('#body').data('mock-budget-id')) {

            budgetId = $('#body').data('mock-budget-id');

        }

        updateElementsHtmlFromSource(pageUrls['debtJarDebtPaymentsTableInfo'], {
            'budget_id': budgetId
        });

    }
    callbacks['reloadInterestsAfterDebtAdd'] = function() {

        callbacks['reloadJarsAfterModal'](function() {

            $('#d-table-1').DataTable().ajax.reload();

        });

    }
    callbacks['reloadInterestsAfterDebtPause'] = function() {

        callbacks['closeModal']();
        $('#d-table-1').DataTable().ajax.reload();

    }
    callbacks['reloadInterestsAfterInterestPaymentAdd'] = function() {

        callbacks['reloadJarsAfterModal'](function() {

            $('#d-table-1').DataTable().ajax.reload();
            $('#dp-table-1').DataTable().ajax.reload();
            callbacks['reloadDebtsTableInfo']();
            callbacks['reloadInterestsInterestPaymentsTableInfo']();

        });

    }
    callbacks['reloadInterestsAfterInterestPaymentDelete'] = function() {

        callbacks['reloadJarsAfterModal'](function() {

            $('#d-table-1').DataTable().ajax.reload();
            $('#dp-table-1').DataTable().ajax.reload();
            callbacks['reloadDebtsTableInfo']();
            callbacks['reloadInterestsInterestPaymentsTableInfo']();

        });

    }
    callbacks['reloadInterestsAfterDebtPaymentAmountEdit'] = function() {

        callbacks['reloadJarsAfterModal'](function() {

            $('#d-table-1').DataTable().ajax.reload();
            callbacks['reloadDebtsTableInfo']();
            callbacks['reloadInterestsInterestPaymentsTableInfo']();

        });

    }
    callbacks['reloadInterestsInterestPaymentsTableInfo'] = function() {

        var budgetId = 0;
        if ($('#body').data('mock-budget-id')) {

            budgetId = $('#body').data('mock-budget-id');

        }

        updateElementsHtmlFromSource(pageUrls['interestsInterestPaymentsTableInfo'], {
            'budget_id': budgetId
        });

    }

    // ACCOUNTS
    callbacks['accountsLoaded'] = function() {

        callbacks['bodyLoaded']();

        if ($('ul#secondary-side-bar-nav.accounts li').length) {

            var link = $('ul#secondary-side-bar-nav.accounts li:first a').attr('href');
            History.replaceState(null, loadingTitle, link);
            $('ul#secondary-side-bar-nav > li').removeClass('active');
            $('ul#secondary-side-bar-nav.accounts li:first').addClass('active');

        }

    };
    callbacks['accountDetailLoaded'] = function() {

        $('ul#secondary-side-bar-nav.accounts li').removeClass('active');
        $('ul#secondary-side-bar-nav.accounts li[data-account-id="' + $('#body').data('account-id') + '"]').addClass('active');
        callbacks['bodyLoaded']();

    };
    callbacks['reloadAccountsAfterModal'] = function(callback) {

        // close modal
        callbacks['closeModal']();

        // reload accounts panel
        var activeAccount = $('#secondary-side-bar ul.accounts li.active');
        var activeAccountId = (activeAccount.length > 0) ? activeAccount.data('account-id') : false;

        data = {};
        if ($('#body').data('mock-budget-id')) {

            data['budget_id'] = $('#body').data('mock-budget-id');

        }

        $.ajax({
            url: pageUrls['accounts'],
            data: data,
            method: 'get',
            complete: function(result, status) {

                var accountsList = $('<div>' + result.responseText + '</div>').find('#secondary-side-bar-nav');

                if (activeAccountId) {

                    accountsList.find('li[data-account-id="' + activeAccountId + '"]').addClass('active');

                }

                $('#secondary-side-bar ul.accounts').html(accountsList);

                if (typeof callback != 'undefined') {

                    callback();

                }

            }
        });

        callbacks['reloadAccountDetailInfo']();

    };
    callbacks['reloadAccountDetailInfo'] = function() {

        var activeAccountId = $('.account-container .secondary-nav').data('account-id');

        updateElementsHtmlFromSource(pageUrls['accountDetailInfo'], {
            'id': activeAccountId
        });

    }
    callbacks['reloadAccountsAfterAdd'] = function(callback) {

        callbacks['reloadAccountsAfterModal']();

    }
    callbacks['reloadAccountsAfterEdit'] = function() {

        callbacks['reloadAccountsAfterModal'](function() {

            $('.account-container h3:first').html($('ul.nav.accounts li.active h4').html());

        });

    };
    callbacks['reloadAccountsAfterRemove'] = function() {

        callbacks['reloadAccountsAfterModal'](function() {

            $('ul#secondary-side-bar-nav.accounts li:first a').trigger('click');

        });

    };
    callbacks['reloadAccountsAfterExpenseTransactionEditAmount'] = function() {

        callbacks['reloadAccountsAfterModal'](function() {

            callbacks['reloadAccountDetailInfo']();
            callbacks['realoadAccountExpenseTransactionsTableInfo']();

        });

    }
    callbacks['reloadAccountsAfterBalanceEditAmount'] = function() {

        callbacks['reloadAccountsAfterModal'](function() {

            callbacks['reloadAccountDetailInfo']();
            callbacks['realoadAccountExpenseTransactionsTableInfo']();
            callbacks['realoadBalanceSheetAdjustmentsTable']();

        });

    }
    callbacks['reloadAccountsAfterExpenseTransactionDelete'] = function() {

        callbacks['reloadAccountsAfterModal'](function() {

            callbacks['reloadAccountDetailInfo']();
            callbacks['realoadAccountExpenseTransactionsTableInfo']();
            $('#aet-table-1').DataTable().ajax.reload();

        });

    };
    callbacks['realoadAccountExpenseTransactionsTableInfo'] = function() {

        var activeAccountId = $('.account-container .secondary-nav').data('account-id');

        updateElementsHtmlFromSource(pageUrls['accountExpenseTransactionsTableInfo'], {
            'account_id': activeAccountId
        });

    }
    callbacks['realoadBalanceSheetAdjustmentsTable'] = function() {

        $('#bsa-table-1').DataTable().ajax.reload();;

    }
    callbacks['reloadAccountsAfterTransferEventEditAmount'] = function() {

        callbacks['reloadAccountsAfterModal'](function() {

            callbacks['reloadAccountDetailInfo']();

        });

    }
    callbacks['reloadAccountsAfterTransferEventDelete'] = function() {

        callbacks['reloadAccountsAfterModal'](function() {

            callbacks['reloadAccountDetailInfo']();
            $('#tfe-table-1').DataTable().ajax.reload();

        });

    };
    callbacks['reloadAccountsAfterIncomeTransactionEditAmount'] = function() {

        callbacks['reloadAccountsAfterModal'](function() {

            callbacks['reloadAccountDetailInfo']();
            callbacks['realoadAccountIncomeTransactionsTableInfo']();

        });

    }
    callbacks['realoadAccountIncomeTransactionsTableInfo'] = function() {

        var activeAccountId = $('.account-container .secondary-nav').data('account-id');

        updateElementsHtmlFromSource(pageUrls['accountIncomeTransactionsTableInfo'], {
            'account_id': activeAccountId
        });

    }
    callbacks['reloadAccountsAfterIncomeTransactionDelete'] = function() {

        callbacks['reloadAccountsAfterModal'](function() {

            callbacks['reloadAccountDetailInfo']();
            $('.data-table').DataTable().ajax.reload();
            callbacks['realoadAccountIncomeTransactionsTableInfo']();

        });

    };

    // INCOMES
    callbacks['incomesLoaded'] = function() {

        callbacks['bodyLoaded']();

        if ($('ul.detail-tab-nav li').length) {

            var link = $('ul.detail-tab-nav li:first a').attr('href');
            History.replaceState(null, loadingTitle, link);
            $('ul.detail-tab-nav > li').removeClass('active');
            $('ul.detail-tab-nav li:first').addClass('active');

        }

    };
    callbacks['incomeDetailLoaded'] = function() {

        callbacks['bodyLoaded'](window.navigationsCount <= 2);

        // change income transactions URL
        var incomeId = $('div[role="tabpanel"]').data('income-id');
        $('ul.detail-tab-nav > li').removeClass('active');
        $('ul.detail-tab-nav li[data-income-id=' + incomeId + ']').addClass('active');

    };
    callbacks['reloadIncomesAfterModal'] = function(callback) {

        // close modal
        callbacks['closeModal']();

        // reload incomes panel
        if ($('ul.nav-tabs.incomes li.active').length) {

            var activeIncome = $('ul.nav-tabs.incomes li.active');
            var activeIncomeId = (activeIncome.length > 0) ? activeIncome.data('income-id') : false;
            var activeIncomeUrl = activeIncome.find('a').attr('href') + '&full_load=1';

            $.ajax({
                url: activeIncomeUrl,
                method: 'post',
                complete: function(result, status) {

                    var incomesList = $('<div>' + result.responseText + '</div>').find('ul.nav-tabs.incomes');

                    if (activeIncomeId) {

                        incomesList.find('li[data-income-id="' + activeIncomeId + '"]').addClass('active');

                    }

                    $('ul.nav-tabs.incomes').html(incomesList.html());
                    $('.income-container').html($(result.responseText).find('.income-container').html());


                    if (typeof callback != 'undefined') {

                        callback();

                    }

                }

            });

        }
        else {

            $.ajax({
                url: pageUrls['incomes'],
                method: 'post',
                complete: function(result, status) {

                    $('.income-row').html($('<div>' + result.responseText + '</div>').find('.income-row').html());

                        $('ul.nav-tabs.incomes li a').trigger('click');

                        if (typeof callback != 'undefined') {

                            callback();

                        }

                }
            });

        }

    };
    callbacks['reloadIncomesAfterAdd'] = function(callback) {

        callbacks['reloadIncomesAfterModal'](function() {

            $('.data-table').each(function() {

                $(this).DataTable().ajax.reload();

            });

        });

    }
    callbacks['reloadIncomesAfterEdit'] = function() {

        callbacks['reloadIncomesAfterModal'](function() {

            $('.data-table').each(function() {

                $(this).DataTable().ajax.reload();

            });

        });

        callbacks['reloadIncomesTableInfo']();

    };
    callbacks['reloadIncomesAfterRemove'] = function() {

        var activeItem = $('ul.nav-tabs.incomes li.active');

        if ($('ul.nav-tabs.incomes li').length > 1) {

            $('ul.nav-tabs.incomes li:not(.active)').eq(0).addClass('active');

        }

        activeItem.removeClass('active');

        callbacks['reloadIncomesAfterModal'](function() {

            $('.data-table').each(function() {

                $(this).DataTable().ajax.reload();

            });

        });

        callbacks['reloadIncomesTableInfo']();

    };
    callbacks['reloadIncomesAfterPause'] = function() {

        callbacks['closeModal']();
        $('#i-table-1').DataTable().ajax.reload();
        callbacks['reloadIncomesTableInfo']();

    };
    callbacks['reloadIncomesTableInfo'] = function() {

        var budgetId = 0;
        if ($('#body').data('mock-budget-id')) {

            budgetId = $('#body').data('mock-budget-id');

        }

        updateElementsHtmlFromSource(pageUrls['incomes-table-info'], {
            budget_id: budgetId
        });

    };
    callbacks['reloadIncomesAfterIncomeTransactionEditAmount'] = function() {

        callbacks['reloadIncomeTransactionsTableInfo']();

    };
    callbacks['reloadIncomesAfterIncomeTransactionDelete'] = function() {

        callbacks['reloadIncomesAfterModal'](function() {

            callbacks['closeModal']();
            $('.data-table').DataTable().ajax.reload();
            callbacks['reloadIncomeTransactionsTableInfo']();

        });

    };
    callbacks['reloadIncomeTransactionsTableInfo'] = function() {

        var activeIncomeId = $('.income-container .tab-pane').data('income-id');

        updateElementsHtmlFromSource(pageUrls['incomeTransactionsTableInfo'], {
            'income_id': activeIncomeId
        });

    };

    // DEBTS
    callbacks['debtsLoaded'] = function() {

        callbacks['bodyLoaded']();

        if ($('ul.detail-tab-nav li').length) {

            var link = $('ul.detail-tab-nav li:first a').attr('href');
            History.replaceState(null, loadingTitle, link);
            $('ul.detail-tab-nav > li').removeClass('active');
            $('ul.detail-tab-nav li:first').addClass('active');

        }

    };
    callbacks['debtDetailLoaded'] = function() {

        callbacks['bodyLoaded']();

        var debtId = $('div[role="tabpanel"]').data('debt-id');
        $('ul.detail-tab-nav > li').removeClass('active');
        $('ul.detail-tab-nav li[data-debt-id=' + debtId + ']').addClass('active');

        callbacks['reloadDebtPaymentsTableInfo']();

    };
    callbacks['reloadDebtsAfterModal'] = function(callback) {

        // close modal
        callbacks['closeModal']();

        // reload debts panel
        if ($('ul.nav-tabs.debts li.active').length) {

            var activeDebt = $('ul.nav-tabs.debts li.active');
            var activeDebtId = (activeDebt.length > 0) ? activeDebt.data('debt-id') : false;
            var activeDebtUrl = activeDebt.find('a').attr('href') + '&full_load=1';

            $.ajax({
                url: activeDebtUrl,
                method: 'post',
                complete: function(result, status) {

                    var debtsList = $('<div>' + result.responseText + '</div>').find('ul.nav-tabs.debts');

                    if (activeDebtId) {

                        debtsList.find('li[data-debt-id="' + activeDebtId + '"]').addClass('active');

                    }

                    $('ul.nav-tabs.debts').html(debtsList.html());
                    $('.debt-container').html($(result.responseText).find('.debt-container').html());

                    if (typeof callback != 'undefined') {

                        callback();

                    }

                }
            });

        }
        else {

            $.ajax({
                url: pageUrls['debts'],
                method: 'post',
                complete: function(result, status) {

                    $('.debt-row').html($('<div>' + result.responseText + '</div>').find('.debt-row').html());

                        $('ul.nav-tabs.debts li a').trigger('click');

                        if (typeof callback != 'undefined') {

                            callback();

                        }

                }
            });

        }

    };
    callbacks['reloadDebtsAfterAdd'] = function(callback) {

        callbacks['reloadDebtsAfterModal'](function() {

            $('#d-table-1').DataTable().ajax.reload();

        });

        callbacks['reloadDebtsTableInfo']();

    }
    callbacks['reloadDebtsAfterEdit'] = function() {

        callbacks['reloadDebtsAfterModal'](function() {

            $('#d-table-1').DataTable().ajax.reload();

        });

        callbacks['reloadDebtsTableInfo']();

    };
    callbacks['reloadDebtsAfterRemove'] = function() {

        var activeItem = $('ul.nav-tabs.debts li.active');

        if ($('ul.nav-tabs.debts li').length > 1) {

            $('ul.nav-tabs.debts li:not(.active)').eq(0).addClass('active');

        }

        activeItem.removeClass('active');

        callbacks['reloadDebtsAfterModal'](function() {

            $('#d-table-1').DataTable().ajax.reload();

        });

        callbacks['reloadDebtsTableInfo']();

    };
    callbacks['reloadDebtsAfterPause'] = function() {

        callbacks['closeModal']();
        $('#d-table-1').DataTable().ajax.reload();
        callbacks['reloadDebtsTableInfo']();

    };
    callbacks['reloadDebtsTableInfo'] = function() {

        var budgetId = 0;
        if ($('#body').data('mock-budget-id')) {

            budgetId = $('#body').data('mock-budget-id');

        }

        updateElementsHtmlFromSource(pageUrls['debts-table-info'], {
            'budget_id': budgetId
        });

    };
    callbacks['reloadDebtsAfterDebtPaymentAdd'] = function() {

        callbacks['reloadDebtsAfterModal'](function() {

            $('.data-table').DataTable().ajax.reload();

        });

        callbacks['reloadDebtsTableInfo']();

    };
    callbacks['reloadDebtsAfterDebtPaymentRemove'] = function() {

        callbacks['reloadDebtsAfterModal'](function() {

            $('.data-table').DataTable().ajax.reload();

        });

        callbacks['reloadDebtsTableInfo']();
        callbacks['reloadDebtPaymentsTableInfo']();

    };
    callbacks['reloadDebtsAfterDebtPaymentAmountEdit'] = function() {

        callbacks['reloadDebtsAfterModal'](function() {

            callbacks['reloadDebtsTableInfo']();

        });

        callbacks['reloadDebtPaymentsTableInfo']();

    };
    callbacks['reloadDebtPaymentsTableInfo'] = function() {

        var activeDebtId = $('.debt-container .tab-pane').data('debt-id');

        updateElementsHtmlFromSource(pageUrls['debtPaymentsTableInfo'], {
            'debt_id': activeDebtId
        });

    };

    // TRANSFERS
    callbacks['transfersLoaded'] = function() {

        callbacks['bodyLoaded']();

        if ($('ul.detail-tab-nav li').length) {

            var link = $('ul.detail-tab-nav li:first a').attr('href');
            History.replaceState(null, loadingTitle, link);
            $('ul.detail-tab-nav > li').removeClass('active');
            $('ul.detail-tab-nav li:first').addClass('active');

        }

    };
    callbacks['transferDetailLoaded'] = function() {

        callbacks['bodyLoaded']();

        var transferId = $('div[role="tabpanel"]').data('transfer-id');
        $('ul.detail-tab-nav > li').removeClass('active');
        $('ul.detail-tab-nav li[data-transfer-id=' + transferId + ']').addClass('active');

    };
    callbacks['reloadTransfersAfterModal'] = function(callback) {

        // close modal
        callbacks['closeModal']();

        // reload transfers panel
        if ($('ul.nav-tabs.transfers li.active').length) {

            var activeTransfer = $('ul.nav-tabs.transfers li.active');
            var activeTransferId = (activeTransfer.length > 0) ? activeTransfer.data('transfer-id') : false;
            var activeTransferUrl = activeTransfer.find('a').attr('href') + '&full_load=1';

            $.ajax({
                url: activeTransferUrl,
                method: 'post',
                complete: function(result, status) {

                    var transfersList = $('<div>' + result.responseText + '</div>').find('ul.nav-tabs.transfers');

                    if (activeTransferId) {

                        transfersList.find('li[data-transfer-id="' + activeTransferId + '"]').addClass('active');

                    }

                    $('ul.nav-tabs.transfers').html(transfersList.html());
                    $('.transfer-container').html($(result.responseText).find('.transfer-container').html());

                    if (typeof callback != 'undefined') {

                        callback();

                    }

                }
            });

        }
        else {

            $.ajax({
                url: pageUrls['transfers'],
                method: 'post',
                complete: function(result, status) {

                    $('.transfer-row').html($('<div>' + result.responseText + '</div>').find('.transfer-row').html());

                        $('ul.nav-tabs.transfers li a').trigger('click');

                        if (typeof callback != 'undefined') {

                            callback();

                        }

                }
            });

        }

    };
    callbacks['reloadTransfersAfterAdd'] = function(callback) {

        callbacks['reloadTransfersAfterModal'](function() {

            $('#tf-table-1').DataTable().ajax.reload();
            $('#tfe-table-1').DataTable().ajax.reload();

        });

    }
    callbacks['reloadTransfersAfterEdit'] = function() {

        callbacks['reloadTransfersAfterModal'](function() {

            $('#tf-table-1').DataTable().ajax.reload();

        });

    };
    callbacks['reloadTransfersAfterRemove'] = function() {

        var activeItem = $('ul.nav-tabs.transfers li.active');

        if ($('ul.nav-tabs.transfers li').length > 1) {

            $('ul.nav-tabs.transfers li:not(.active)').eq(0).addClass('active');

        }

        activeItem.removeClass('active');

        callbacks['reloadTransfersAfterModal'](function() {

            $('#tf-table-1').DataTable().ajax.reload();

        });

    };
    callbacks['reloadTransfersAfterPause'] = function() {
        callbacks['closeModal']();
        $('#tf-table-1').DataTable().ajax.reload();
    };
    callbacks['reloadTransfersAfterTransferEventDeleted'] = function() {
        callbacks['reloadTransfersAfterModal'](function() {
            $('#tfe-table-1').DataTable().ajax.reload();
        });
    };
    callbacks['reloadTransfersAfterTransferEventEdit'] = function() {
        callbacks['reloadTransfersAfterModal'](function() {
            $('#tfe-table-1').DataTable().ajax.reload();
        });
    };

    // MONEY OPERATIONS
    callbacks['moneyOperationsLoaded'] = function() {

        callbacks['bodyLoaded']();

    };
    callbacks['reloadMoneyOperationsTable'] = function() {

        callbacks['closeModal']();
        $('#mo-table-1').DataTable().ajax.reload();
        callbacks['reloadMoneyOperationsTableInfo']();

    }
    callbacks['reloadMoneyOperationsTableInfo'] = function() {

        updateElementsHtmlFromSource(pageUrls['moneyOperationsTableInfo']);

    }

    // USERS
    callbacks['usersLoaded'] = function() {

        callbacks['bodyLoaded']();
        $(window).trigger('load.bs.select.data-api');

    }

    callbacks['reloadUsers'] = function() {

        var userId = $('.users-panel .nav.nav-tabs li.active').data('user-id');
        callbacks['closeModal']();

        $.ajax({
            complete: function(result, status) {

                var response = $(result.responseText);

                if (response.find('.users-panel .nav.nav-tabs li[data-user-id="' + userId + '"]').length > 0) {

                    response.find('.users-panel .nav.nav-tabs li').removeClass('active');
                    response.find('.users-panel .nav.nav-tabs li[data-user-id="' + userId + '"]').addClass('active');
                    response.find('.users-panel .tab-content .tab-pane').removeClass('active');
                    response.find('.users-panel .tab-content .tab-pane[data-user-id="' + userId + '"]').addClass('active');

                }

                // replace tabs & tab panels
                $('.users-panel .nav.nav-tabs').html(response.find('.users-panel .nav.nav-tabs').html());
                $('.users-panel .tab-content').html(response.find('.users-panel .tab-content').html());

            }
        });

    }

    // BUDGET
    callbacks['budgetPositionSummaryLoaded'] = callbacks['bodyLoaded'];

    callbacks['budgetEomSummaryLoaded'] = function() {
        callbacks['bodyLoaded']();
        /*$('.budget-selectors .item .slider').bootstrapSlider({
            formatter: function(value) {
                return 'Current value: ' + value;
            }
        });*/
        $('#submit-balance').click(function() {
            $('#eom-step2').removeClass('hidden');
            return false;
        });
        $(window).trigger('load.bs.select.data-api');
    };

    callbacks['budgetMockBudgetsLoaded'] = callbacks['bodyLoaded'];

    callbacks['budgetMockBudgetDetailLoaded'] = callbacks['bodyLoaded'];

    callbacks['budgetMockBudgetOverviewLoaded'] = callbacks['bodyLoaded'];

    callbacks['reloadBudgets'] = function() {
        callbacks['closeModal']();
        $.ajax({
            url: pageUrls['mockBudgets'],
            complete: function(result, status) {
                var response = $(result.responseText);
                $('.mock-budgets').html(response.find('.mock-budgets').html());
            }
        });
    };

    callbacks['eomsSubmitted'] = function() {
        window.location.href = '/';
    };

    callbacks['balancesSubmitted'] = function() {
        window.location.href = '/budget/end-of-month-summary?summary=1';
    };

    // REPORTS
    callbacks['reportsLoaded'] = function() {

        if ($('ul#secondary-side-bar-nav.reports li').length) {

            var link = $('ul#secondary-side-bar-nav.reports li:first a').attr('href');
            History.replaceState(null, 'loading...', link);
            $('ul#secondary-side-bar-nav > li').removeClass('active');
            $('ul#secondary-side-bar-nav.reports li:first').addClass('active');

        }

        callbacks['bodyLoaded']();
    }
    callbacks['reportDetailLoaded'] = function() {

        $('ul#secondary-side-bar-nav.accounts li').removeClass('active');
        $('ul#secondary-side-bar-nav.accounts li[data-account-id="' + $('#body').data('account-id') + '"]').addClass('active');

        callbacks['bodyLoaded']();
        $(window).trigger('load.bs.select.data-api');

        if ($('#chart14').length > 0) {
            var data = [16, 26, 24, 20, 28, 30, 4, 20, 16, 24, 25, 27];
            var series = [{data: data}];

            for (var i = 10; i <= 140; i += 10) {
                series.push({
                    data: $.map(data, function(a) {
                        return a + i;
                    })
                });
            }

            new Chartist.Line('#chart14', {
                labels: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'],
                series: series
            }, {
                axisX: {
                    showGrid: false
                },
                chartPadding: {
                    top: 40
                },
                height: 300
            });
        }
    }

    // SUBSCRIPTION
    callbacks['subscriptionLoaded'] = function() {

        $('.static-popover').popover('show');
        callbacks['bodyLoaded']();

    }

    // FIRST TIME SETUP
    callbacks['firstTimeSetupStep1Loaded'] = function() {

        callbacks['bodyLoaded']();
        $(window).trigger('load.bs.select.data-api');
        $('a.btn').show();
    }
    callbacks['firstTimeSetupStep1Valid'] = function() {

        callbacks['closeModal']();
        $('.fts-next-button').fadeIn();
        callbacks['reloadUsers']();

    }
    callbacks['firstTimeSetupStep2Loaded'] = callbacks['bodyLoaded'];

    callbacks['firstTimeSetupStep2Valid'] = function() {

        callbacks['closeModal']();
        $('.fts-next-button').fadeIn();
        callbacks['reloadFirstTimeSetupAccounts']();

    }
    callbacks['reloadFirstTimeSetupAccounts'] = function() {

        var accountId = $('.accounts-panel .nav.nav-tabs li.active').data('account-id');
        callbacks['closeModal']();

        $.ajax({
            complete: function(result, status) {

                var response = $(result.responseText);

                if (response.find('.accounts-panel .nav.nav-tabs li[data-account-id="' + accountId + '"]').length > 0) {

                    response.find('.accounts-panel .nav.nav-tabs li').removeClass('active');
                    response.find('.accounts-panel .nav.nav-tabs li[data-account-id="' + accountId + '"]').addClass('active');
                    response.find('.accounts-panel .tab-content .tab-pane').removeClass('active');
                    response.find('.accounts-panel .tab-content .tab-pane[data-account-id="' + accountId + '"]').addClass('active');

                }

                // replace tabs & tab panels
                $('.accounts-panel .nav.nav-tabs').html(response.find('.accounts-panel .nav.nav-tabs').html());
                $('.accounts-panel .tab-content').html(response.find('.accounts-panel .tab-content').html());

            }
        });

    }
    callbacks['firstTimeSetupStep3Loaded'] = callbacks['bodyLoaded'];

    callbacks['reloadFirstTimeSetupDebts'] = function() {

        var debtId = $('.debts-panel .nav.nav-tabs li.active').data('debt-id');
        callbacks['closeModal']();

        $.ajax({
            complete: function(result, status) {

                var response = $(result.responseText);

                if (($('.debts-panel .nav.nav-tabs li').length > 0) && (response.find('.debts-panel .nav.nav-tabs li').length > 0)) {

                    if (response.find('.debts-panel .nav.nav-tabs li[data-debt-id="' + debtId + '"]').length > 0) {

                        response.find('.debts-panel .nav.nav-tabs li').removeClass('active');
                        response.find('.debts-panel .nav.nav-tabs li[data-debt-id="' + debtId + '"]').addClass('active');
                        response.find('.debts-panel .tab-content .tab-pane').removeClass('active');
                        response.find('.debts-panel .tab-content .tab-pane[data-debt-id="' + debtId + '"]').addClass('active');

                    }

                    // replace tabs & tab panels
                    $('.debts-panel .nav.nav-tabs').html(response.find('.debts-panel .nav.nav-tabs').html());
                    $('.debts-panel .tab-content').html(response.find('.debts-panel .tab-content').html());

                    // balance bars
                    $('.debts-panel .balance-bar').remove();
                    $('.debts-panel .container-fluid').after($('<div>').append(response.find('.debts-panel .balance-bar')).html());

                }
                else {

                    $('.debts-panel .container-fluid').html(response.find('.debts-panel .container-fluid').html());
                    // balance bars
                    $('.debts-panel .balance-bar').remove();
                    if (response.find('.debts-panel .balance-bar').length > 0) {
                        $('.debts-panel .container-fluid').after($('<div>').append(response.find('.debts-panel .balance-bar')).html());
                    }

                }

            }
        });

    }
    callbacks['firstTimeSetupStep4Loaded'] = callbacks['bodyLoaded'];

    callbacks['reloadFirstTimeSetupIncomes'] = function() {

        var incomeId = $('.incomes-panel .nav.nav-tabs li.active').data('income-id');
        callbacks['closeModal']();

        $.ajax({
            complete: function(result, status) {

                var response = $(result.responseText);

                if (($('.incomes-panel .nav.nav-tabs li').length > 0) && (response.find('.incomes-panel .nav.nav-tabs li').length > 0))  {

                    if (response.find('.incomes-panel .nav.nav-tabs li[data-income-id="' + incomeId + '"]').length > 0) {

                        response.find('.incomes-panel .nav.nav-tabs li').removeClass('active');
                        response.find('.incomes-panel .nav.nav-tabs li[data-income-id="' + incomeId + '"]').addClass('active');
                        response.find('.incomes-panel .tab-content .tab-pane').removeClass('active');
                        response.find('.incomes-panel .tab-content .tab-pane[data-income-id="' + incomeId + '"]').addClass('active');

                    }

                    // replace tabs & tab panels
                    $('.incomes-panel .nav.nav-tabs').html(response.find('.incomes-panel .nav.nav-tabs').html());
                    $('.incomes-panel .tab-content').html(response.find('.incomes-panel .tab-content').html());

                    // balance bars
                    $('.incomes-panel .balance-bar').remove();
                    $('.incomes-panel .container-fluid').after($('<div>').append(response.find('.incomes-panel .balance-bar')).html())

                }
                else {

                    $('.incomes-panel .container-fluid').html(response.find('.incomes-panel .container-fluid').html());

                }

            }
        });

    }
    callbacks['firstTimeSetupStep5Loaded'] = function() {

        callbacks['bodyLoaded']();

        if ($('.nav.nav-tabs').length > 0) {

            History.replaceState(null, loadingTitle, $('.nav.nav-tabs li:first a').attr('href'));
            $('.nav.nav-tabs > li').removeClass('active');
            $('.nav.nav-tabs li:first').addClass('active');

        }

    }
    callbacks['firstTimeSetupStep5DetailLoaded'] = function() {

        callbacks['bodyLoaded']();

        var jarId = $('div[role="tabpanel"]').data('jar-id');
        $('.nav.nav-tabs > li').removeClass('active');
        $('.nav.nav-tabs li[data-jar-id=' + jarId + ']').addClass('active');

    }
    callbacks['reloadFirstTimeSetupJars'] = function() {

        var jarId = $('.jars-panel .nav.nav-tabs li.active').data('jar-id');
        callbacks['closeModal']();

        $.ajax({
            url: window.location.href + '&full_load=1',
            complete: function(result, status) {

                var response = $(result.responseText);

                if (($('.jars-panel .nav.nav-tabs li').length > 0) && (response.find('.jars-panel .nav.nav-tabs li').length > 0)) {

                    if (response.find('.jars-panel .nav.nav-tabs li[data-jar-id="' + jarId + '"]').length > 0) {

                        response.find('.jars-panel .nav.nav-tabs li').removeClass('active');
                        response.find('.jars-panel .nav.nav-tabs li[data-jar-id="' + jarId + '"]').addClass('active');
                        response.find('.jars-panel .tab-content .tab-pane').removeClass('active');
                        response.find('.jars-panel .tab-content .tab-pane[data-jar-id="' + jarId + '"]').addClass('active');

                    }

                    // replace tabs & tab panels
                    $('.jars-panel .nav.nav-tabs').html(response.find('.jars-panel .nav.nav-tabs').html());
                    $('.jars-panel .tab-content').html(response.find('.jars-panel .tab-content').html());

                    // balance bars
                    $('.jars-panel .balance-bar').remove();
                    $('.jars-panel .container-fluid').after($('<div>').append(response.find('.jars-panel .balance-bar')).html())

                }
                else {

                    $('.jars-panel .container-fluid').html(response.find('.jars-panel .container-fluid').html());

                }
                // reload data tables
                callbacks['bodyLoaded']();

            }
        });

    }
    callbacks['reloadFirstTimeSetupJarsAfterRemove'] = function() {

        $('.jars-panel .nav.nav-tabs li.active').remove();
        $('.jars-panel .nav.nav-tabs li:first').addClass('active');
        $('.jars-panel .nav.nav-tabs li:first a').trigger('click');
        callbacks['closeModal']();

    }
    callbacks['firstTimeSetupStep6Loaded'] = callbacks['bodyLoaded'];
    callbacks['firstTimeSetupStep7Loaded'] = callbacks['bodyLoaded'];

    // SUPPORT
    callbacks['supportMainLoaded'] = callbacks['bodyLoaded'];
    callbacks['supportFaqLoaded'] = callbacks['bodyLoaded'];

    // POSITION SUMMARY
    callbacks['positionSummaryLoaded'] = callbacks['bodyLoaded'];

    // EOMS
    callbacks['showEomsEquation'] = function() {

        // show top warning
        if ($('#body').hasClass('this-months-eoms')) {

            $('body').addClass('top-warning');
            $('.eoms-warning').removeClass('hidden');

        }

        updateElementsHtmlFromSource(pageUrls['eomsEquationNumbers'], {}, function() {

            // highlight result
            var equationResult = parseFloat($('.equation-result').text().substr(1));
            if (equationResult > 0) {
                $('.equation-result').addClass('value-green').removeClass('value-red');
            }
            else {
                $('.equation-result').addClass('value-red').removeClass('value-green');
            }

            if ($('#eom-step2').hasClass('hidden')) {

                $('#eom-step2').hide().removeClass('hidden').slideDown(400, function() {

                    var elmsHeight = 0;
                    $('#body >').each(function() {

                        elmsHeight += $(this).height();

                    });

                    $('#body').animate({
                        scrollTop: elmsHeight
                    }, 400);

                });

            }
            else {

                var elmsHeight = 0;
                $('#body >').each(function() {

                    elmsHeight += $(this).height();

                });

                $('#body').animate({
                    scrollTop: elmsHeight
                }, 400);

            }

        });

    };
    callbacks['eomsDetailForDate'] = function(month, year) {

        var href = pageUrls['eoms'] + '?year=' + year + '&month=' + month;

        History.pushState(null, loadingTitle, href);

    };
    callbacks['eomsMonths'] = function(year) {

        $.ajax({
            url: pageUrls['eomsMonths'],
            data: {
                year: year
            },
            complete: function(result, status) {

                var response = $.parseJSON(result.responseText);
                $('.eoms-date-selector [name="month"]').html('');
                $.each(response['months'], function(index, value) {
                    $('.eoms-date-selector [name="month"]').append('<option value="' + index + '">' + value + '</option>');

                });
                $('.eoms-date-selector [name="month"]').selectpicker('refresh');

            }

        });

    };

    // MESSAGES
    callbacks['messagingLoaded'] = function() {
        callbacks['bodyLoaded']();
        messagesHistoryScrollDown();
        if ($('#secondary-side-bar').length) {
            $('#content').addClass('secondary-nav');
        }
        else {
            $('#content').removeClass('secondary-nav');
        }
        //loadAppointmentsDayData($('.appointments #appointments-calendar').val());
    };
    callbacks['reloadAppointmentsDay'] = function() {

        callbacks['closeModal'](function() {
            $('#slots-calendar').fullCalendar('refetchEvents');
            $('#slots-summary').fullCalendar('refetchEvents');
        });

        /*$.ajax({
            url: pageUrls['coach'],
            complete: function(result, status) {
                var response = result.responseText;
                $('.appointments .bookings').html($(response).find('.appointments .bookings'));
                $('.next-appointment-date').html($(response).find('.next-appointment-date').text());
            }
        });*/

    };

    // NOTES
    callbacks['notesLoaded'] = function() {

        callbacks['bodyLoaded']();

        if ($('ul#secondary-side-bar-nav.clients li').length) {

            History.replaceState(null, loadingTitle, $('ul#secondary-side-bar-nav.clients li:first a').attr('href'));
            $('ul#secondary-side-bar-nav > li').removeClass('active');
            $('ul#secondary-side-bar-nav.clients li:first').addClass('active');

        }

    };
    callbacks['notesClientDetailLoaded'] = function() {

        $('ul#secondary-side-bar-nav.clients li').removeClass('active');
        $('ul#secondary-side-bar-nav.clients li[data-user-id="' + $('#body').data('user-id') + '"]').addClass('active');
        callbacks['bodyLoaded']();

    };
    callbacks['reloadNotesAfterModal'] = function(callback) {

        // close modal
        callbacks['closeModal']();
        $('#cn-table-1').DataTable().ajax.reload();

    };

    // ADMIN
    callbacks['reloadAdminUserPlans'] = function() {

        callbacks['closeModal'](function() {

            $.pjax.reload({container:'#pjax-UserPlans'});

        });

    }

    // GENERAL
    callbacks['reloadPage'] = function($form) {

        window.location.reload(true);

    };
    callbacks['reloadPjaxMain'] = function() {
        callbacks['closeModal'](function() {
            $.pjax.reload({container:'#pjax-main'});
        });
    };
    callbacks['reloadPageSoft'] = function() {
        callbacks['closeModal'](function() {
            loadConentForUrl(window.location.href, loadedCont, loadingBodyHtml, false, true);
        });
    };

    /**
     * Loads data from URL and updates HTML of elements.
     * @param {string} url
     * @param {object} data
     */
    function updateElementsHtmlFromSource(url, data, callback) {

        if (typeof data == 'undefined') {

            data = {};

        }

        $.ajax({
            url: url,
            data: data,
            method: 'get',
            async: false,
            complete: function(result, status) {

                var response = $.parseJSON(result.responseText);

                updateElementsHtml(response, function() {

                    // callback
                    if (typeof callback != 'undefined') {

                        callback();

                    }

                });

            }
        });

    }

    /**
     * This serves to update HTML of elements from an object {class: HTML, class: HTML,...}
     */
    function updateElementsHtml(data, callback) {

        $.each(data, function(htmlClass, html) {

            // special case for EoMS surplus/deficit section
            if ($('.' + htmlClass).find('input.currency-field').length > 0) {
                $('.' + htmlClass).find('input.currency-field').val(html.replace(/[^0-9\.]+/g, ''));
            }
            else {
                $('.' + htmlClass).html(html);
            }

        });

        // callback
        if (typeof callback != 'undefined') {

            callback();

        }

    }

    // show "View more" for too long dashboard panel content
    function dashboardPanelViewMore(id) {

        var selector = '.panel.panel-dashboard';
        if (typeof id != 'undefined') {
            selector += '#' + id;
        }
        var panelHeight = $(selector).height();
        var viewMore = $('<div class="view-more" data-view-more-text="View more" data-view-less-text="View less" data-orig-height="' + $('.panel.panel-dashboard').outerHeight() + '">'
            + 'View more</div>');

        $(selector).each(function() {

            var contentHeight = 0;
            $(this).children().each(function() {

                contentHeight += $(this).outerHeight();

            });

            if (contentHeight > panelHeight || typeof id != 'undefined') {

                $(this).append(viewMore.clone().attr('data-expand-height', contentHeight + 47));

            }

        });
    }

    $('.static-popover').popover('show');
    // Initialize tooltips
    $('[data-toggle="tooltip"]').tooltip();
    /* timepicker */
    $('.date').datetimepicker({
        allowInputToggle: true, format: "MM/DD/YYYY"
    });
    GMJS.C.DISABLE_BACK_BY_BACKSPACE();
    // reorder jars
    $('body').on('click', '.reorder-jars', function () {
        var $el = $(this);
        var $list = $('.reorder-jars-list');
        var jarOrder = [];
        $('.reorder-jars-list li').each(function() {
            jarOrder.push($(this).data('jar-id'));
        });
        if($el.is('.active')) {
            $el.removeClass('active');
            $.ajax({
                'url': '/jars/reorder-jars',
                'method': 'post',
                'data': { 'jarOrder': jarOrder, budgetId: $el.data('budget-id') },
                'complete': function (response, status) {
                    response = JSON.parse(response['responseText']);
                    topScreenNotification(response['message'], response['status']);
                }
            });
            $list.sortable('destroy');
        } else {
            $el.addClass('active');
            $list.sortable();
        }
    });
    // edit table row
    $('body').on('click', "a[data-action='edit-transaction']", function() {
        var $row = $(this).parents('tr');
        $row.find(".menu-column .cog-menu").dropdown('toggle');
        $row.addClass('is-editing');
        $row.find("[data-editable]").each(function() {
            var type = $(this).data('editable-type');
            if (type == 'date') {
                $(this).find('input').datepicker();
            }
        });
        return false;
    });
    $('body').on('click', ".save-editing", function() {
        var $row = $(this).parents('tr');
        var actionUrl = $(this).data('action-url');
        var actionCb = $(this).data('action-callback');
        var requestData = {id:null,type:null,fields:[]};
        requestData['id'] = $(this).data('action-id');
        requestData['type'] = $(this).data('action-type');
        $row.find("[data-editable]").each(function() {
            var fieldProps = {type:null,value:null};
            fieldProps['type'] = $(this).data('editable-field');
            fieldProps['value'] = $(this).find('input').length > 0 ?
                $(this).find('input').val() : $(this).find('select').val();
            if (typeof fieldProps['value'] == 'undefined') { return; }
            var type = $(this).data('editable-type');
            if (type === 'currency') {
                fieldProps['value'] = Math.abs(fieldProps['value']);
            } else if (type === 'date') {
                var momentFormat = $(this).find('input').data('moment-format');
                fieldProps['value'] = moment(fieldProps['value'], momentFormat).format('YYYY-MM-DD');
            }
            requestData['fields'].push(fieldProps);
        });
        $.ajax({
            'url': actionUrl,
            'method': 'post',
            'data': requestData,
            'complete': function (response, status) {
                response = JSON.parse(response['responseText']);
                topScreenNotification(response['message'], response['status']);
                callbacks[actionCb]();
            }
        });
        return false;
    });
    $('body').on('click', ".cancel-editing", function() {
        var $row = $(this).parents('tr');
        $row.removeClass('is-editing');
        var actionCb = $(this).data('action-callback');
        callbacks[actionCb]();
        return false;
    });
    // admin/coach dashboard
    $('body').on('change', '#new-users-months', function() {
        var $this = $(this),
            $panel = $(this).parents('.panel'),
            $content = $panel.find('.dynamic-content');
        if ($content) {
            $content.data('ajax',
                $content.data('ajax-base') + '?months=' + $this.val()
            );
            var $viewMore = $panel.find('.view-more');
            if ($panel.outerHeight() > $viewMore.data('orig-height')) {
                $viewMore.trigger('click');
            }
            $viewMore.remove();
            initDynamicContent($content.attr('id'));
        }
    });
    GMJS.C.MANAGE_VIDEO_TUTORIAL();
    GMJS.C.MANAGE_DASHBOARD_CAROUSEL();
    GMJS.C.SELECT_ALL_ON_FOCUS();
});