var tsNotificationTimeout = false; // will help with the timer
var baseUrl = $('body').data('base-url'); // get base url of app
var dateFormat = $('body').data('date-format'); // get base url of app
var currencySymbol = $('body').data('currency-symbol'); // get base url of app

// Top bar dropdown animation
// Add slideup & fadein animation to dropdown
$('.top-bar-dropdown-menu').on(
    'show.bs.dropdown', function (e) {
        var $dropdown = $(this).find('.dropdown-menu');
        $dropdown.stop(true, false).css({'margin-top': '0px'});
        var orig_margin_top = parseInt($dropdown.css('margin-top'));
        $dropdown.css({'margin-top': (orig_margin_top - 10) + 'px', opacity: 0})
            .animate(
                {'margin-top': orig_margin_top + 'px', opacity: 1}, 300,
                function () {
                    $(this).css({'margin-top': ''});
                }
            );
    }
);
// Add slidedown & fadeout animation to dropdown
$('.top-bar-dropdown-menu').on(
    'hide.bs.dropdown', function (e) {
        var $dropdown = $(this).find('.dropdown-menu');
        $dropdown.stop(true, false).css({'margin-top': '0px'});
        var orig_margin_top = parseInt($dropdown.css('margin-top'));
        $dropdown.css(
            {'margin-top': orig_margin_top + 'px', opacity: 1, display: 'block'}
        ).animate(
            {'margin-top': (orig_margin_top - 10) + 'px', opacity: 0}, 300,
            function () {
                $(this).css({'margin-top': '', display: ''});
            }
        );
    }
);

/* add and remove + - on sidebar */
$('#side-bar-nav .panel').on(
    'show.bs.collapse', function (e) {
        $(this).find('.glyphicon').addClass('glyphicon-minus');
    }
);
$('#side-bar-nav .panel').on(
    'hide.bs.collapse', function (e) {
        $(this).find('.glyphicon').removeClass('glyphicon-minus');
    }
);

$(document).on(
    'click', '#secondary-side-bar #mobile-nav-toggle-reports',
    function() {
        $(this).parents('#secondary-side-bar').toggleClass('contracted');
        return false;
    }
);

$('#search-bar input[type=text]').focus(
    function () {
        var $input = $(this);
        var $top_bar = $input.closest('#top-bar');

        $top_bar.addClass('search-focus');
    }
).blur(
    function () {
        var $input = $(this);
        var $top_bar = $input.closest('#top-bar');

        $top_bar.removeClass('search-focus');
    }
);


var $tooltip = $('<div class="tooltip tooltip-hidden"></div>')
    .appendTo($('.ct-chart'));

$(document).on(
    'mouseenter', '.ct-point', function () {
        var seriesName = $(this).closest('.ct-series')
            .attr('ct:series-name'), value = $(this).attr('ct:value');

        $tooltip.text(seriesName + ': ' + value);
        $tooltip.removeClass('tooltip-hidden');
    }
);

$(document).on(
    'mouseleave', '.ct-point', function () {
        $tooltip.addClass('tooltip-hidden');
    }
);

$(document).on(
    'mousemove', '.ct-point', function (event) {
        //  console.log(event);
        $tooltip.css(
            {
                left: (event.offsetX || event.originalEvent.layerX)
                      - $tooltip.width() / 2,
                top: (event.offsetY || event.originalEvent.layerY)
                      - $tooltip.height() + 15
            }
        );
    }
);

$(document).on(
    'change', '#addappointment-timeslotitemid', function() {
        var $that = $(this);
        $.get('/admin/coach/hours-list?id=' + $that.val(),
            function(result) {
                var $hours = $that.parents('form').find('#addappointment-startdatetime');
                $hours.html('');
                for (var key in result) {
                    if (result.hasOwnProperty(key)) {
                        $hours.append('<option value="' + key + '">' + result[key] + '</option>');
                    }
                }
            }, 'json');
        return true;
    }
);


/* center modal */
function centerModals() {
    $('.modal').each(
        function (i) {
            var $clone = $(this).clone().css('display', 'block')
                .appendTo('body');
            var top = Math.round(
                ($clone.height() - $clone.find('.modal-content').height()) / 2
            );
            top = top > 0 ? top : 0;
            $clone.remove();
            $(this).find('.modal-content').css("margin-top", top);
        }
    );
}

$('.modal').on('show.bs.modal', centerModals);
$(window).on('resize', function() {
    centerModals();
});
$(window).ready(function() {
    document.body.classList.remove('no-js');
});

/*
 Reusable function to display a loading state for elements
 */
$.fn.blockloader = function (option) {
    return this.each(
        function () {
            var container = $(this);
            if (option == 'hide') {
                container.find('.jqblock-loader').hide();
            } else if (option == 'show' && container.find(
                    '.jqblock-loader'
                ).length) {
                container.find('.jqblock-loader').show();
            } else {
                var container = $(this);

                var $blockloader = $(
                    '<div class="jqblock-loader"><div class="jqblock-loader-content"></div></div>'
                );

                if (container.find('.jqblock-loader').length) {
                    container.find('.jqblock-loader').show();
                } else {
                    var $parent;
                    // optional selector within the container
                    if (typeof option != 'undefined' && option.length > 0) {
                        $parent = container.find(option);
                    }
                    else {
                        $parent = container;
                    }
                    $parent.prepend($blockloader);

                    $blockloader.css('top', $parent.css('padding-top'));
                    $blockloader.css('bottom', $parent.css('padding-bottom'));
                    $blockloader.css('left', $parent.css('padding-left'));
                    $blockloader.css('right', $parent.css('padding-right'));
                }
            }
        }
    )
};

/*
 Notification message. A wrapper for the noty plugin
 */
var cn_notif = function (message, options) {
    var opts = $.extend(
        {
            type: 'success', layout: 'topRight', text: message
        }, options
    );

    noty(opts);
};

// Browser detection
$(document).ready(function () {
    if ((!readCookie('cn-supported-browser')) || readCookie(
            'cn-supported-browser'
        ) != bowser.name) {
        var ver = bowser.version.split('.').slice(0, 2).join('.');
        var is_win = /windows/i.test(navigator.userAgent);
        var supported_browser_link = '';
        var browser_is_unsupported = false;

        // Internet Explorer unsupported: version 8 and below
        if (bowser.msie && ver < 9) {
            supported_browser_link
                = 'http://windows.microsoft.com/en-ph/internet-explorer/download-ie';
        } else if (bowser.chrome && ver < 4.3) {
            supported_browser_link
                = 'https://www.google.com/chrome/browser/desktop/';
        } else if (bowser.firefox && ver < 40) {
            supported_browser_link
                = 'https://www.mozilla.org/en-US/firefox/desktop/';
        } else if (bowser.safari || bowser.ios) {
            if (is_win && ver < 5.1) {
                // No reliable download link available for Safari, so download link will be for chrome
                supported_browser_link
                    = 'https://www.google.com/chrome/browser/desktop/';
            } else if (!is_win && ver < 5) {
                // No reliable download link available for Safari, so download link will be for chrome
                supported_browser_link
                    = 'https://www.google.com/chrome/browser/desktop/';
            }
        } else if (bowser.android && ver < 5.1) {
            browser_is_unsupported = true;
        } else if (!bowser.msie && !bowser.chrome && !bowser.firefox
            && !bowser.safari && !bowser.android) {
            browser_is_unsupported = true;
        }


        if (supported_browser_link) {
            browser_is_unsupported = true;
        }

        if (!supported_browser_link || !browser_is_unsupported) {
            createCookie('cn-supported-browser', bowser.name, 31);
        }

        if (browser_is_unsupported) {
            var browser_warning = 'You are using an unsupported browser. Some functionality may not work as expected and we suggest that you use the latest Chrome/Firefox version or upgrade to the latest version.';
            if (supported_browser_link) {
                browser_warning
                    += '<br /><br />Click <a target="_blank" href="'
                    + supported_browser_link
                    + '">here</a> to download the latest version of a supported browser.';
            }

            cn_notif(browser_warning, {type: 'warning'});
        }

    }


    /** element autodestroy feature **/
    $('.autodestroy').each(function() {
        var element = $(this),
            timeout = element.data('timeout');
        if (typeof timeout != 'undefined' && parseInt(timeout) > 0) {
            setTimeout(function() {
                element.slideUp(function() {
                    element.remove();
                });
            }, timeout * 1000);
        }
    });
});


function createCookie(name, value, days) {
    var expires;

    if (days) {
        var date = new Date();
        date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
        expires = "; expires=" + date.toGMTString();
    } else {
        expires = "";
    }
    document.cookie = encodeURIComponent(name) + "=" + encodeURIComponent(value)
        + expires + "; path=/";
}

function readCookie(name) {
    var nameEQ = encodeURIComponent(name) + "=";
    var ca = document.cookie.split(';');
    for (var i = 0; i < ca.length; i++) {
        var c = ca[i];
        while (c.charAt(0) === ' ') {
            c = c.substring(1, c.length);
        }
        if (c.indexOf(nameEQ) === 0) {
            return decodeURIComponent(
                c.substring(nameEQ.length, c.length)
            );
        }
    }
    return null;
}

function eraseCookie(name) {
    createCookie(name, "", -1);
}

function showLoadingAfterPayment() {
    var container = $('#loaded-content'),
        loadingMessage = '<div class="loading-content-block">Loading...</div>';
    container.children().hide();
    if (!container.find('.loading-message').length) {
        container.prepend(loadingMessage);
    }
    else {
        container.find('.loading-message').show();
    }
}

function hideLoadingAfterPayment() {
    var container = $('#loaded-content');
    container.children().show();
    container.find('.loading-message').hide();
}

function isJson(text) {
    if (typeof text != 'string')
        text = JSON.stringify(text);
    try {
        JSON.parse(text);
        return true;
    }
    catch (e) {
        return false;
    }
}

// open a normal modal window
function openModal(url, closable, withGraph) {
    var modal = $('#appModal');
    if (typeof closable == 'undefined') {
        closable = true;
    }

    $.ajax({
        url: url,
        method: 'get',
        processData: false,
        contentType: false,
        complete: function(result, status) {
            // check if message or actual modal
            if (isJson(result.responseText)) {
                var response = $.parseJSON(result.responseText);
                topScreenNotification(response.message, response.status);
            }
            else {
                var backdrop = (closable) ? true : 'static';

                if (typeof ($('#appModal').data('bs.modal')) == 'undefined') {
                    $('#appModal').modal({
                        backdrop: backdrop,
                        keyboard: closable,
                        show: false
                    });
                }
                else {
                    $('#appModal').data('bs.modal').options.backdrop = backdrop;
                    $('#appModal').data('bs.modal').options.keyboard = closable;
                }

                modal.find('.modal-content').html(result.responseText);

                if (closable) {
                    modal.find('.close').show();
                }
                else {
                    modal.find('.close').hide();
                }

                modal.on('show.bs.modal', function () {
                    if (modal !== this) { return; } // ignore modal in modal (datepicker)
                    var $modalForm = modal.find('form');
                    if (!$modalForm.length) { return; }
                    setTimeout(function() {
                        var $firstInput = $modalForm.find("input[type='text']").not('[readonly]').first();
                        $firstInput.focus();
                    }, 500);
                });
                modal.modal('show');

                modal.on('hidden.bs.modal', function() {
                    modal.find('.modal-content').html(null);
                    tinyMCE.remove();
                });

                // initialize tooltips
                $('[data-toggle="tooltip"]').tooltip();

                // initialize graphs
                if (withGraph) {
                    initGraphs();
                }

                $(window).trigger('load.bs.select.data-api');
            }
        }
    });
    return false;
}

// show a top screen notification
function topScreenNotification(message, status) {

    if (tsNotificationTimeout) {
        clearTimeout(tsNotificationTimeout);
    }

    var note = $('#top-screen-notification');
    note.removeClass('success');
    note.removeClass('error');

    if (typeof status != 'undefined') {
        note.addClass(status);
    }

    note.find('p').html(message);
    note.css({
        'display': 'block'
    });
    note.css({
        'margin-left': '-' + note.width() / 2 + 'px'
    });
    note.animate({
        'opacity': 1
    }, 500);

    tsNotificationTimeout = setTimeout(function() {
        $('#top-screen-notification').fadeOut(500, function() {
            note.animate({
                'opacity': 0
            }, 500);
        });
        tsNotificationTimeout = false;
    }, 8000);

}

// close top screen notification
function closeTopScreenNotification() {
    $('#top-screen-notification').fadeOut(500);
    tsNotificationTimeout = false;
}


// chartist js
function initGraphs() {

    if (!$('.data-graph.loaded').length) {

        // line graph
        $('.data-graph.line-graph').each(function() {

            var graph = $(this);
            var data = graph.data();
            if (typeof data['firstYear'] != 'undefined') {
                data['year'] = data['firstYear'];
            }
            if (typeof data['firstMonth'] != 'undefined') {
                data['month'] = data['firstMonth'];
            }
            if (typeof data['accountId'] != 'undefined') {
                data['account_id'] = data['accountId']; // backwards compatibility
            }

            graph.css('min-height', '150px').blockloader();

            $.ajax({
                url: $(this).data('ajax'),
                method: 'get',
                data: data,
                complete: function(result) {

                    graph.blockloader('hide');

                    var response = $.parseJSON(result.responseText);

                    if (response) {
                        var item = '<div class="item active"><div class="chart-title">' + response.title + '</div><div class="ct-chart"></div></div>';
                        if (graph.find('.carousel-inner').length > 0) {
                            graph.find('.carousel-inner').append(item);
                        }
                        else {
                            graph.append(item);
                        }

                        if (!graph.is(':visible')) {
                            graph.closest('.tab-pane').not(':visible').css({
                                display: 'block',
                                position: 'absolute',
                                left: '-100%',
                                top: 0,
                                width: graph.closest('.tab-content').width() + 'px'
                            });
                        }

                        var chart = new Chartist.Line(graph.find('.ct-chart')[0], {
                                labels: response.labels,
                                series: response.series
                            },
                            {
                                axisX: {
                                    showGrid: false
                                },
                                high: response.max + 100,
                                low: response.min - 100,
                                plugins: [
                                    Chartist.plugins.legend(),
                                    Chartist.plugins.tooltip({
                                        currency: currencySymbol
                                    })
                                ]
                            }
                        ).on('created', function() {
                            graph.addClass('loaded');
                            graph.find('.ct-chart').addClass('loaded');

                            graph.closest('.tab-pane').css({
                                display: '',
                                position: '',
                                left: '',
                                top: '',
                                width: ''
                            });
                        });

                        // wipe any other item that might be present
                        graph.find('.item.active:gt(0)').remove();

                    }
                    else {
                        var item = '<div class="item active no-data"><span class="chart-no-data">No data found.</span></div>';
                        if (graph.find('.carousel-inner').length > 0) {
                            graph.find('.carousel-inner').append(item).addClass('data-empty');

                        }
                        else {
                            graph.append(item).addClass('data-empty');
                        }
                    }
                }
            });
        });

        // bar graph 1 (year/graph)
        $('.data-graph.bar-graph-1').each(function() {

            var graph = $(this);
            var data = graph.data();
            if (typeof data['firstYear'] != 'undefined') {

                data['year'] = data['firstYear'];

            }
            if (typeof data['firstMonth'] != 'undefined') {

                data['month'] = data['firstMonth'];

            }

            graph.css('min-height', '150px').blockloader();

            $.ajax({
                url: $(this).data('ajax'),
                method: 'get',
                data: data,
                complete: function(result) {

                    graph.blockloader('hide');

                    var response = $.parseJSON(result.responseText);

                    if (response) {

                        var item = '<div class="item active"><div class="chart-title">' + response.title + '</div><div class="ct-chart"></div></div>';
                        if (graph.find('.carousel-inner').length > 0) {

                            graph.find('.carousel-inner').append(item);

                        }
                        else {

                            graph.append(item);

                        }

                        if (!graph.is(':visible')) {

                            graph.closest('.tab-pane').not(':visible').css({
                                display: 'block',
                                position: 'absolute',
                                left: '-100%',
                                top: 0,
                                width: graph.closest('.tab-content').width() + 'px'
                            });

                        }

                        var chart = new Chartist.Bar(graph.find('.ct-chart')[0], {
                                labels: response.labels,
                                series: response.series
                            },
                            {
                                stackBars: true,
                                axisX: {
                                    showGrid: false
                                },
                                height: 250,
                                plugins: [
                                    Chartist.plugins.legend(),
                                    Chartist.plugins.tooltip({
                                        currency: currencySymbol
                                    })
                                ]
                            }).on('draw', function(data) {

                            // responsive bar width
                            if (graph.width() > 750) {

                                if (data.type === 'bar') {
                                    data.element.attr({
                                        style: 'stroke-width: 50px'
                                    });
                                }

                            }
                            else if (graph.width() > 510) {

                                if (data.type === 'bar') {
                                    data.element.attr({
                                        style: 'stroke-width: 30px'
                                    });
                                }

                            }
                            else {

                                if (data.type === 'bar') {
                                    data.element.attr({
                                        style: 'stroke-width: 15px'
                                    });
                                }

                            }

                        }).on('created', function() {

                            graph.addClass('loaded');
                            graph.find('.ct-chart').addClass('loaded');

                            graph.closest('.tab-pane').css({
                                display: '',
                                position: '',
                                left: '',
                                top: '',
                                width: ''
                            });

                        });

                        // wipe any other item that might be present
                        graph.find('.item.active:gt(0)').remove();

                    }
                    else {

                        var item = '<div class="item active"><span class="chart-no-data">No data found.</span></div>';
                        if (graph.find('.carousel-inner').length > 0) {

                            graph.find('.carousel-inner').append(item).addClass('data-empty');

                        }
                        else {

                            graph.append(item).addClass('data-empty');

                        }

                    }

                }
            });

        });

        // bar graph 2 (month/graph)
        $('.data-graph.bar-graph-2').each(function() {

            var graph = $(this);
            var data = graph.data();
            if (typeof data['firstYear'] != 'undefined') {

                data['year'] = data['firstYear'];

            }
            if (typeof data['firstMonth'] != 'undefined') {

                data['month'] = data['firstMonth'];

            }

            graph.css('min-height', '150px').blockloader();

            $.ajax({
                url: $(this).data('ajax'),
                method: 'get',
                data: data,
                complete: function(result) {

                    graph.blockloader('hide');

                    var response = $.parseJSON(result.responseText);

                    if (response) {

                        var item = '<div class="item active"><div class="chart-title">' + response.title + '</div><div class="ct-chart"></div></div>';
                        if (graph.find('.carousel-inner').length > 0) {

                            graph.find('.carousel-inner').append(item);

                        }
                        else {

                            graph.append(item);

                        }

                        if (!graph.is(':visible')) {

                            graph.closest('.tab-pane').not(':visible').css({
                                display: 'block',
                                position: 'absolute',
                                left: '-100%',
                                top: 0,
                                width: graph.closest('.tab-content').width() + 'px'
                            });

                        }

                        var chart = new Chartist.Bar(graph.find('.ct-chart')[0], {
                                labels: response.labels,
                                series: response.series
                            },
                            {
                                seriesBarDistance: 10,
                                axisX: {
                                    showGrid: false
                                },
                                height: 250,
                                plugins: [
                                    Chartist.plugins.legend(),
                                    Chartist.plugins.tooltip({
                                        currency: currencySymbol
                                    })
                                ]
                            }).on('created', function() {

                            // show hidden graphs;
                            graph.closest('.tab-pane').css({
                                display: '',
                                position: '',
                                left: '',
                                top: '',
                                width: ''
                            });

                            graph.addClass('loaded');
                            graph.find('.ct-chart').addClass('loaded');

                        });

                        // wipe any other item that might be present
                        graph.find('.item.active:gt(0)').remove();

                    }
                    else {

                        var item = '<div class="item active"><span class="chart-no-data">No data found.</span></div>';
                        if (graph.find('.carousel-inner').length > 0) {

                            graph.find('.carousel-inner').append(item).addClass('data-empty');

                        }
                        else {

                            graph.append(item).addClass('data-empty');

                        }
                        graph.addClass('loaded');

                    }

                }
            });

        });

        // bar graph 3 (month/graph, red line on 0)
        $('.data-graph.bar-graph-3').each(function() {

            var graph = $(this);
            var data = graph.data();
            if (typeof data['firstYear'] != 'undefined') {

                data['year'] = data['firstYear'];

            }
            if (typeof data['firstMonth'] != 'undefined') {

                data['month'] = data['firstMonth'];

            }

            graph.css('min-height', '138px').blockloader();

            $.ajax({
                url: $(this).data('ajax'),
                method: 'get',
                data: data,
                complete: function(result) {

                    graph.blockloader('hide');

                    var response = $.parseJSON(result.responseText);

                    if (response) {

                        var item = '<div class="item active"><div class="chart-title">' + response.title + '</div><div class="ct-chart"></div></div>';
                        if (graph.find('.carousel-inner').length > 0) {

                            graph.find('.carousel-inner').append(item);

                        }
                        else {

                            graph.append(item);

                        }

                        if (!graph.is(':visible')) {

                            graph.closest('.tab-pane').not(':visible').css({
                                display: 'block',
                                position: 'absolute',
                                left: '-100%',
                                top: 0,
                                width: graph.closest('.tab-content').width() + 'px'
                            });

                        }

                        var chart = new Chartist.Bar(graph.find('.ct-chart')[0], {
                                labels: response.labels,
                                series: response.series
                            },
                            {
                                seriesBarDistance: 10,
                                axisX: {
                                    showGrid: false
                                },
                                high: response.max + 100,
                                low: response.min - 100,
                                height: 138,
                                plugins: [
                                    Chartist.plugins.legend(),
                                    Chartist.plugins.tooltip({
                                        currency: currencySymbol
                                    })
                                ]
                            }).on('created', function() {

                            // show hidden graphs;
                            graph.closest('.tab-pane').css({
                                display: '',
                                position: '',
                                left: '',
                                top: '',
                                width: ''
                            });

                            graph.addClass('loaded');
                            graph.find('.ct-chart').addClass('loaded');

                            // highlight 0 hack
                            var labelCount = graph.find('.ct-labels foreignobject').length;
                            var zeroLabelIndex;
                            graph.find('.ct-labels foreignobject').each(function(index) {

                                if ($(this).text() == '0') {

                                    zeroLabelIndex = index;
                                    return;

                                }

                            });

                            var lineCount = graph.find('.ct-grids line').length;
                            var zeroLineIndex = lineCount - (labelCount - zeroLabelIndex);
                            graph.find('.ct-grids line').eq(zeroLineIndex).css('stroke', '#555');

                            // replace label color
                            if (graph.find('.ct-series-0').text() == 'Surplus') {
                                graph.find('.ct-series-0').switchClass('ct-series-0', 'ct-series-5');
                            }
                            if (graph.find('.ct-series-1').text() == 'Deficit') {
                                graph.find('.ct-series-1').switchClass('ct-series-1', 'ct-series-8');
                            }

                        });

                        // wipe any other item that might be present
                        graph.find('.item.active:gt(0)').remove();

                    }
                    else {

                        var item = '<div class="item active"><span class="chart-no-data">No data found.</span></div>';
                        if (graph.find('.carousel-inner').length > 0) {

                            graph.find('.carousel-inner').append(item).addClass('data-empty');

                        }
                        else {

                            graph.append(item).addClass('data-empty');

                        }
                        graph.addClass('loaded');

                    }

                }
            });

        });

        // pie chart
        $('.data-graph.pie-chart').each(function() {

            var graph = $(this);
            var data = graph.data();
            if (typeof data['firstYear'] != 'undefined') {
                data['year'] = data['firstYear'];
            }
            if (typeof data['firstMonth'] != 'undefined') {
                data['month'] = data['firstMonth'];
            }
            if (typeof data['accountId'] != 'undefined') {
                data['account_id'] = data['accountId']; // backwards compatibility
            }

            graph.css('min-height', '150px').blockloader();

            $.ajax({
                url: $(this).data('ajax'),
                method: 'get',
                data: data,
                complete: function(result) {

                    graph.blockloader('hide');

                    var response = $.parseJSON(result.responseText);

                    if (response) {
                        var item = '<div class="item active"><div class="chart-title">' + response.title + '</div><div class="ct-chart"></div></div>';
                        if (graph.find('.carousel-inner').length > 0) {
                            graph.find('.carousel-inner').append(item);
                        }
                        else {
                            graph.append(item);
                        }

                        if (!graph.is(':visible')) {
                            graph.closest('.tab-pane').not(':visible').css({
                                display: 'block',
                                position: 'absolute',
                                left: '-100%',
                                top: 0,
                                width: graph.closest('.tab-content').width() + 'px'
                            });
                        }

                        var chart = new Chartist.Pie(graph.find('.ct-chart')[0], {
                                labels: response.labels,
                                series: response.series
                            },
                            {
                                labelInterpolationFnc: function(value) {
                                    return value[0];
                                },
                                plugins: [
                                    Chartist.plugins.legend(),
                                    Chartist.plugins.tooltip({
                                        currency: (data['noCurrency'] == 1 ? undefined : currencySymbol)
                                    })
                                ],
                                height: graph.width() * 0.75
                            },
                            [
                                ['screen and (min-width: 640px)', {
//                                        chartPadding: 30,
//                                        labelOffset: 100,
//                                        labelDirection: 'explode',
                                    labelInterpolationFnc: function (value) {
                                        return value;
                                    }
                                }],
                                ['screen and (min-width: 1024px)', {
                                    labelOffset: 80,
                                    chartPadding: 20
                                }]
                            ]).on('created', function() {
                            graph.addClass('loaded');
                            graph.find('.ct-chart').addClass('loaded');

                            graph.closest('.tab-pane').css({
                                display: '',
                                position: '',
                                left: '',
                                top: '',
                                width: ''
                            });
                        });

                        // wipe any other item that might be present
                        graph.find('.item.active:gt(0)').remove();
                    }
                    else {
                        var item = '<div class="item active no-data"><span class="chart-no-data">No data found.</span></div>';
                        if (graph.find('.carousel-inner').length > 0) {
                            graph.find('.carousel-inner').append(item).addClass('data-empty');
                        }
                        else {
                            graph.append(item).addClass('data-empty');
                        }
                    }
                }
            });

        });

    }

    $('.tab-pane.data-graph.static-graph').each(function() {

        var $tab = $(this);

        $tab.blockloader();

        /*
         Load chart data via ajax
         */
        $.ajax({
            url: $tab.data('ajax'),
            method: 'post',
            dataType: 'json',
            complete: function(result) {

                if (result.responseJSON) {

                    result = result.responseJSON;

                    var chartOptions = $.extend({
                        height: 250,
                        plugins: [
                            Chartist.plugins.legend()
                        ]
                    }, result.chartOptions);


                    var chartist = new Chartist[result.type]('#' + $tab.attr('id') + ' .ct-chart', result.chartData, chartOptions, result.responsiveChartOptions);

                    if (result.chartEvents) {
                        for (var i in result.chartEvents) {
                            if (result.chartEvents[i].eventName == 'strokeWidth') {
                                chartist.on('draw', function(data) {
                                    if (data.type === 'bar') {
                                        data.element.attr({
                                            style: 'stroke-width: ' + result.chartEvents[i].data
                                        });
                                    }
                                })
                            }

                        }
                    }

                    $tab.blockloader('hide');
                }
                else {

                    var item = '<p class="chart-no-data">No data found.</p>';
                    $tab.append(item).addClass('data-empty');
                    $tab.blockloader('hide');

                }
            }
        });
    });

    $('a[data-toggle="tab"]').on('shown.bs.tab', function(e) {

        $('.tabpanel').find('.ct-chart').each(function(i, e) {

            if ($(this).find('svg').length > 0) {

                e.__chartist__.update();

            }

        });

    });

}