<?php

namespace backend\widgets;

use yii\base\Widget;

class RadiolistInlineTemplate extends Widget {

    public $index, $label, $name, $checked, $value;

    public function run() {

        $out = '<label class="radio-inline">
            <input type="radio" id="' . $this->name . $this->index . '" name="' . $this->name . '" tabindex="' . $this->index . '" value="' . $this->value . '"' . (($this->checked) ? 'checked="checked"' : '')  . '/>
            <label for="' . $this->name . $this->index . '">' . $this->label . '</label>
        </label>';

        return $out;

    }


    static public function populateWidget($index, $label, $name, $checked, $value) {

        return self::widget([
            'index' => $index,
            'label' => $label,
            'name' => $name,
            'checked' => $checked,
            'value' => $value
        ]);

    }

}
