<?php

namespace backend\widgets;

use backend\models\db\ConversationMessage;
use backend\models\db\ConversationToUser;
use Yii;
use yii\base\Widget;

use backend\models\db\Conversation;
use backend\models\db\User;

use yii\helpers\Url;
use backend\components\helpers\Formatter;

class UnreadConversationMessages extends Widget
{
    public $userId;
    public $user;
    public $limit = 3;

    public function run()
    {
        $out = '';
        $this->user = User::findOne($this->userId);
        $timezone = $this->user->getTimeZone();
        $messages = [];

        /** @var Conversation $c */
        // for coaches just show last X messages sent from any of the users
        if ($this->user->user_role_id == 2) {
            $messages = ConversationMessage::find()
                ->joinWith('conversation')
                ->joinWith('conversation.conversationsToUsers')
                ->where([ConversationToUser::tableName() . '.user_id' => $this->userId])
                ->orderBy(ConversationMessage::tableName() . '.id DESC')
                ->limit($this->limit)
                ->all();
        }
        else {
            $c = $this->user->getMainConversation();
            if ($c) {
                $messages = $c->getMessages($this->userId, $this->limit, false, true);
            }
        }

        foreach ($messages as $message) {
            /** @var User $user */
            $user = $message->user;
            $out .=
                '<li class="alert-msg-item clear" data-message-id="' . $message->id . '" data-conversation-id="' . $c->id . '">' .
                    '<div id="alert-message-' . $message->id . '-canvas" class="clear">' .
                        '<span class="name">' . $user->getFullName(true) . '</span>' .
                        '<span class="date">' . Formatter::datetime(Formatter::utcDatetimeToLocalDatetime($message->time, $timezone->code, 'Y-m-d H:i:s')) . '</span>' .
                        '<p>' . $message->text . '</p>';

            // if budget conversation, add budget link
            /* FIXME
             * if (substr($c->name, 0, 7) == 'budget_') {
                $out .= '<a href="' . $this->_getConversationUrl($c->name, $c->id, Yii::$app->user) . '" class="go-to-budget system-link">
                    Go to budget
                    <i class="glyphicon glyphicon-share-alt"></i>
                </a>';
            }*/

            $out .=
                    '</div>' .
                '</li>';
        }

        return $out;
    }

    /**
     * Return the conversation's URL.
     * @param string $name Name of the conversation logged in DB.
     * @param integer $conversationId ID of the conversation from DB.
     * @param object $user The user object.
     * @return string URL to conversation.
     */
    private function _getConversationUrl($name, $conversationId, $user)
    {
        if ($name == 'main') {
            if (!$user->isSuperadmin && !$user->isCoach) {
                return Url::toRoute('/coach');
            }
            else {
                if (in_array($this->user->user_role_id, [1, 2])) {
                    $url = Url::toRoute(['/admin/conversations', 'messages_user_id' => $conversationId]);
                }
                else {
                    $url = Url::toRoute(['/coach']);
                }
                return $url;
            }
        }
        else {
            // gotta parse the name now
            if (substr($name, 0, 7) == 'budget_') {
                return Url::toRoute(['/mock-budgets/budget-detail', 'id' => substr($name, 7)]);
            }
        }
    }
}
