<?php

namespace common\models\db;

use backend\models\db\User;
use Yii;
use yii\helpers\Url;

/**
 * This is the model class for table "user_password_reset_requests".
 *
 * @property integer $id
 * @property integer $user_id
 * @property string $time
 * @property string $auth_token
 * @property string $used_time
 * @property string $source
 *
 * @property User $user
 */
class UserPasswordResetRequest extends \yii\db\ActiveRecord
{
    const REQUEST_EXPIRY_TIME = 86400;


    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'user_password_reset_requests';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['user_id'], 'integer'],
            [['time', 'used_time', 'source'], 'safe'],
            [['auth_token'], 'string', 'max' => 100],
            [['user_id'], 'exist', 'skipOnError' => true, 'targetClass' => User::className(), 'targetAttribute' => ['user_id' => 'id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'user_id' => 'User ID',
            'time' => 'Time',
            'auth_token' => 'Auth Token',
            'used_time' => 'Used Time',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(User::className(), ['id' => 'user_id']);
    }

    public function getPasswordResetUrl()
    {
        return Url::to(['/site/reset-password', 'token' => $this->auth_token], true);
    }

    public function markUsed()
    {
        $this->used_time = date('Y-m-d H:i:s');
        return $this->save();
    }

    public function getIsFromMembershipPage()
    {
        return $this->source == 'members' ? true : false;
    }
}
