<?php

use yii\db\Migration;

class m160810_111541_alter_field_types extends Migration
{
    public function up()
    {
        $this->alterColumn('accounts', 'name', "varchar(60) not null default ''");
        $this->alterColumn('accounts', 'balance', "decimal(10,2) null default 0");

        $this->alterColumn('account_balances', 'balance', "decimal(10,2) not null default 0");

        $this->alterColumn('account_eoms_balances', 'balance', "decimal(10,2) not null default 0");

        $this->alterColumn('cc_transactions', 'amount', "decimal(10,2) not null default 0");

        $this->alterColumn('debts', 'interest', "decimal(7,3) null default 0");
        $this->alterColumn('debts', 'monthly_interest', "decimal(10,2) not null default 0");
        $this->alterColumn('debts', 'payment', "decimal(10,2) null default 0");
        $this->alterColumn('debts', 'payment_minimum', "decimal(10,2) null default 0");
        $this->alterColumn('debts', 'amount', "decimal(10,2) null default 0");

        $this->alterColumn('debt_amounts', 'amount', "decimal(10,2) not null default 0");
        $this->alterColumn('debt_amounts', 'this_months_amount', "decimal(10,2) not null default 0");

        $this->alterColumn('debt_payments', 'amount', "decimal(10,2) null default 0");

        $this->alterColumn('expenses', 'amount', "decimal(10,2) null default 0");

        $this->alterColumn('faq_categories', 'name', "varchar(128) not null default ''");
        $this->alterColumn('faq_categories', 'order', "int(11) not null default 0");

        $this->alterColumn('faq_questions', 'title', "varchar(255) not null default ''");
        $this->alterColumn('faq_questions', 'description', "text null default null");
        $this->alterColumn('faq_questions', 'order', "int(11) not null default 0");

        $this->alterColumn('incomes', 'amount', "decimal(10,2) null default 0");

        $this->alterColumn('income_transactions', 'amount', "decimal(10,2) null default 0");

        $this->alterColumn('invoices', 'bill_name', "varchar(255) not null default ''");
        $this->alterColumn('invoices', 'bill_address_1', "varchar(255) not null default ''");
        $this->alterColumn('invoices', 'bill_address_2', "varchar(255) not null default ''");
        $this->alterColumn('invoices', 'bill_address_3', "varchar(255) not null default ''");
        $this->alterColumn('invoices', 'bill_country', "varchar(255) not null default ''");
        $this->alterColumn('invoices', 'total', "decimal(10,2) not null default 0");
        $this->alterColumn('invoices', 'payment_data', "text null default null");

        $this->alterColumn('invoice_items', 'description', "varchar(255) not null default ''");
        $this->alterColumn('invoice_items', 'amount', "decimal(10,2) not null default 0");

        $this->alterColumn('jars', 'amount', "decimal(10,2) null default 0");

        $this->alterColumn('media', 'type', "varchar(15) not null default ''");
        $this->alterColumn('media', 'name', "varchar(255) not null default ''");

        $this->alterColumn('notifications', 'content', "text null default null");

        $this->alterColumn('transactions', 'amount', "decimal(10,2) null default 0");

        $this->alterColumn('transfers', 'amount', "decimal(10,2) null default 0");

        $this->alterColumn('updates', 'end_time', "timestamp null default null");
        $this->alterColumn('updates', 'type', "varchar(20) not null default ''");
        $this->alterColumn('updates', 'step', "varchar(30) not null default ''");

        $this->alterColumn('users', 'username', "varchar(50) not null default ''");
        $this->alterColumn('users', 'password', "varchar(60) not null default ''");
        $this->alterColumn('users', 'password_salt', "varchar(12) not null default ''");
        $this->alterColumn('users', 'email', "varchar(60) not null default ''");

        $this->alterColumn('user_activity', 'title', "varchar(128) not null default ''");
        $this->alterColumn('user_activity', 'description', "varchar(128) not null default ''");
        $this->alterColumn('user_activity', 'data', "text null default null");
    }

    public function down()
    {
        echo "m160810_111541_alter_field_types cannot be reverted.\n";

        return false;
    }

    /*
    // Use safeUp/safeDown to run migration code within a transaction
    public function safeUp()
    {
    }

    public function safeDown()
    {
    }
    */
}
