<?php

use backend\models\db\NotificationTemplate;
use yii\db\Migration;

class m160815_102241_update_eoms_notification_templates extends Migration
{
    public function up()
    {
        $this->update(
            NotificationTemplate::tableName(),
            [
                'content' => 'Today is the last day of the month, ' .
                    'please don’t forget to record your end of month bank, ' .
                    'credit card and debt balances today. You can submit them ' .
                    '<a href="%url%" class="system-link">here</a>.'
            ],
            ['name' => 'eoms_overdue']
        );
        $this->insert(
            NotificationTemplate::tableName(),
            [
                'content' => 'It is now the new month, ' .
                    'please take time to update your end of month bank, ' .
                    'credit card and debt balances as they were on the ' .
                    'last day of the month. You can submit them ' .
                    '<a href="%url%" class="system-link">here</a>.',
                'name' => 'eoms_overdue_new_month',
                'notification_category_id' => 2 // End of month category
            ]
        );
    }

    public function down()
    {
        echo "m160815_102241_update_eoms_notification_templates cannot be reverted.\n";

        return false;
    }

    /*
    // Use safeUp/safeDown to run migration code within a transaction
    public function safeUp()
    {
    }

    public function safeDown()
    {
    }
    */
}
