<?php

use backend\models\db\Income;
use backend\models\db\IncomeTransaction;
use yii\db\Migration;

class m161201_112931_income_descriptions extends Migration
{
    public function up()
    {
        $this->addColumn('income_transactions', 'description', $this->string(255)->null()->defaultExpression('NULL')->after('date'));
        // init the descriptions with income name
        foreach (IncomeTransaction::find()->all() as $incomeTransaction) {
            $incomeTransaction->updateAttributes([
                'description' => $incomeTransaction->income->name
            ]);
        }
    }

    public function down()
    {
        echo "m161201_112931_income_descriptions cannot be reverted.\n";

        return false;
    }

    /*
    // Use safeUp/safeDown to run migration code within a transaction
    public function safeUp()
    {
    }

    public function safeDown()
    {
    }
    */
}
