<?php

use yii\db\Migration;

class m161202_115541_fix_user_registrations_table extends Migration
{
    public function up()
    {
        $this->delete('user_registrations', [
            'auth_token' => null
        ]);
        $this->alterColumn('user_registrations', 'auth_time', $this->timestamp()->null()->defaultExpression('NULL'));
        $this->alterColumn('user_registrations', 'time', $this->timestamp()->notNull()->defaultExpression('CURRENT_TIMESTAMP'));
        $this->alterColumn('user_registrations', 'user_id', $this->integer()->notNull());
        $this->alterColumn('user_registrations', 'auth_token', $this->string(42)->notNull());
    }

    public function down()
    {
        echo "m161202_115541_fix_user_registrations_table cannot be reverted.\n";

        return false;
    }

    /*
    // Use safeUp/safeDown to run migration code within a transaction
    public function safeUp()
    {
    }

    public function safeDown()
    {
    }
    */
}
