<?php

use backend\models\db\UserPlan;
use yii\db\Migration;

class m161208_140515_plan_variations extends Migration
{
    public function up()
    {
        /** @var UserPlan $plan */
        foreach (UserPlan::find()->where(['user_plan_variation_id' => null])->all() as $plan) {
            $plan->user_plan_variation_id = $plan->userPlanType->getDefaultPlanVariation()->id;
            $plan->save();
        }

        $this->addColumn('user_plan_types', 'description', $this->text()->null()->defaultExpression('NULL')->after('name'));

        // Kickstart
        $this->update('user_plan_types', [
            'description' => 'Need some helping getting a realistic budget set up and working? Our Kickstarter plan gives '.
                'you 4 sessions with one of our experienced coaches to help you implement our proven budgeting system and '.
                'navigate the inevitable obstacles cause most budgets to fail.'
        ], [
            'id' => 1
        ]);
        // One to One Coaching
        $this->update('user_plan_types', [
            'description' => 'This our highly successful 12 month coaching, a dedicated coach will provide you with the '.
                'expertise, encouragement and accountability you need to take control of your money, break the pay cheque '.
                'cycle, pay off lifestyle debt and build a strong financial foundation.'
        ], [
            'id' => 2
        ]);
        // Maintenance
        $this->update('user_plan_types', [
            'description' => 'Once you have completed our Kickstart or 12 month coaching program you may want some ongoing '.
                'support and accountability to continue to achieve your goals. The Maintenance program allows you to stay '.
                'in contact with your coach through quarterly meetings and our internal messaging system.'
        ], [
            'id' => 3
        ]);
        // Application
        $this->update('user_plan_types', [
            'description' => 'Our basic subscription package to use our Grandma’s Jars Budget application, includes access '.
                'to our End of Month Summary webinars.'
        ], [
            'id' => 4
        ]);
        // Membership
        $this->update('user_plan_types', [
            'description' => 'You will get access to the GMJS budgeting app and the members bootcamp.'
        ], [
            'id' => 5
        ]);
    }

    public function down()
    {
        echo "m161208_140515_plan_variations cannot be reverted.\n";

        return false;
    }

    /*
    // Use safeUp/safeDown to run migration code within a transaction
    public function safeUp()
    {
    }

    public function safeDown()
    {
    }
    */
}
