<?php

use yii\db\Migration;

class m161228_133500_search_logs extends Migration
{
    public function up()
    {
        $this->createTable('search_logs', [
            'id' => $this->primaryKey(),
            'query' => $this->text()->notNull(),
            'user_id' => $this->integer()->notNull(),
            'searched_at' => $this->timestamp()->notNull()->defaultExpression('CURRENT_TIMESTAMP')
        ]);
        $this->addForeignKey('user_fk', 'search_logs', 'user_id', 'users', 'id', 'CASCADE', 'CASCADE');
    }

    public function down()
    {
        echo "m161228_133500_search_logs cannot be reverted.\n";

        return false;
    }

    /*
    // Use safeUp/safeDown to run migration code within a transaction
    public function safeUp()
    {
    }

    public function safeDown()
    {
    }
    */
}
