<?php

use yii\db\Migration;

class m170323_125550_appointments_time_slots extends Migration
{
    public function up()
    {
        $this->createTable('time_slots', [
            'id' => $this->primaryKey(),
            'coach_id' => $this->integer()->notNull(),
            'start_date' => $this->date()->notNull(),
            'end_date' => $this->date()->notNull(),
            'start_time' => $this->string(10)->notNull(),
            'end_time' => $this->string(10)->notNull(),
            'name' => $this->string()->null()->defaultExpression('null'),
            'frequency' => $this->string(50)->null()->defaultExpression('null'),
            'repeat_every' => $this->integer()->notNull()->defaultValue(1),
            'slot_time' => $this->integer()->null()->defaultExpression('null')
        ]);
        $this->addForeignKey('fk_time_slot_coach_id', 'time_slots', 'coach_id', 'users', 'id');
        $this->createTable('time_slot_items', [
            'id' => $this->primaryKey(),
            'time_slot_id' => $this->integer()->notNull(),
            'start_at' => $this->dateTime()->notNull(),
            'end_at' => $this->dateTime()->notNull()
        ]);
        $this->addForeignKey('fk_time_slot_item_time_slot_id', 'time_slot_items', 'time_slot_id', 'time_slots', 'id');
    }

    public function down()
    {
        echo "m170323_125550_appointments_time_slots cannot be reverted.\n";

        return false;
    }

    /*
    // Use safeUp/safeDown to run migration code within a transaction
    public function safeUp()
    {
    }

    public function safeDown()
    {
    }
    */
}
