<?php

use yii\db\Migration;

class m170404_085834_appointments_time_slot_bookings extends Migration
{
    public function up()
    {
        $this->createTable('time_slot_bookings', [
            'id' => $this->primaryKey(),
            'time_slot_id' => $this->integer()->notNull(),
            'time_slot_item_id' => $this->integer()->notNull(),
            'user_id' => $this->integer()->notNull(),
            'start_at' => $this->dateTime()->notNull(),
            'end_at' => $this->dateTime()->notNull()
        ]);
        $this->addForeignKey('fk_time_slot_booking_time_slot_id',
            'time_slot_bookings', 'time_slot_id', 'time_slots', 'id');
        $this->addForeignKey('fk_time_slot_booking_time_slot_item_id',
            'time_slot_bookings', 'time_slot_item_id', 'time_slot_items', 'id');
        $this->addForeignKey('fk_time_slot_booking_user_id',
            'time_slot_bookings', 'user_id', 'users', 'id');
    }

    public function down()
    {
        echo "m170404_085834_appointments_time_slot_bookings cannot be reverted.\n";

        return false;
    }

    /*
    // Use safeUp/safeDown to run migration code within a transaction
    public function safeUp()
    {
    }

    public function safeDown()
    {
    }
    */
}
