<?php

use backend\models\db\UserPlanType;
use yii\db\Migration;

class m170609_133652_update_plan_features extends Migration
{
    public function up()
    {
        $application = UserPlanType::findOne(['name' => 'Grandma\'s Jars Application']);
        $membership = UserPlanType::findOne(['name' => 'Grandma\'s Jars Membership']);

        // Web & Mobile Apps
        $this->insert('user_plan_details', [
            'user_plan_type_id' => $application->id,
            'user_plan_feature_id' => 1,
            'value' => null,
            'archived' => 0
        ]);
        $this->insert('user_plan_details', [
            'user_plan_type_id' => $membership->id,
            'user_plan_feature_id' => 1,
            'value' => null,
            'archived' => 0
        ]);

        // Live Webinars
        $this->insert('user_plan_details', [
            'user_plan_type_id' => $application->id,
            'user_plan_feature_id' => 2,
            'value' => null,
            'archived' => 0
        ]);
        $this->insert('user_plan_details', [
            'user_plan_type_id' => $membership->id,
            'user_plan_feature_id' => 2,
            'value' => null,
            'archived' => 0
        ]);

        // G-Jars Community Forum
        $this->insert('user_plan_details', [
            'user_plan_type_id' => $membership->id,
            'user_plan_feature_id' => 3,
            'value' => null,
            'archived' => 0
        ]);

        // Tutorials & Articles
        $this->insert('user_plan_details', [
            'user_plan_type_id' => $membership->id,
            'user_plan_feature_id' => 4,
            'value' => null,
            'archived' => 0
        ]);

        // Plan Length
        $this->insert('user_plan_details', [
            'user_plan_type_id' => $application->id,
            'user_plan_feature_id' => 5,
            'value' => 'Variable',
            'archived' => 0
        ]);
        $this->insert('user_plan_details', [
            'user_plan_type_id' => $membership->id,
            'user_plan_feature_id' => 5,
            'value' => 'Variable',
            'archived' => 0
        ]);
    }

    public function down()
    {
        echo "m170609_133652_update_plan_features cannot be reverted.\n";

        return false;
    }

    /*
    // Use safeUp/safeDown to run migration code within a transaction
    public function safeUp()
    {
    }

    public function safeDown()
    {
    }
    */
}
