<?php

use yii\db\Migration;

class m170929_103209_add_conquer_plan extends Migration
{
    public function up()
    {
        $this->dropIndex('stripe_plan_idx', 'user_plan_variations');
        $this->createIndex('stripe_plan_idx', 'user_plan_variations', 'stripe_plan_id');

        $this->insert('user_plan_types', [
            'name' => 'Conquer Your Credit Card',
            'description' => 'Registering gives you unlimited access to the Conquer your Credit Card course and all supplemental materials'
        ]);
        $planId = Yii::$app->db->getLastInsertID();
        $this->insert('user_plan_variations', [
            'name' => 'Conquer Your Credit Card Course + Application 3 Months',
            'stripe_plan_id' => '',
            'user_plan_type_id' => $planId,
            'plan_length' => 3,
            'price' => 197
        ]);
        $this->insert('user_plan_variations', [
            'name' => 'Conquer Your Credit Card Course + Application 1 Year',
            'stripe_plan_id' => '',
            'user_plan_type_id' => $planId,
            'plan_length' => 12,
            'price' => 247
        ]);
    }

    public function down()
    {
        echo "m170929_103209_add_conquer_plan cannot be reverted.\n";

        return false;
    }

    /*
    // Use safeUp/safeDown to run migration code within a transaction
    public function safeUp()
    {
    }

    public function safeDown()
    {
    }
    */
}
