<?php

use yii\db\Migration;

/**
 * Handles the creation of table `ip_tracking`.
 */
class m171011_041147_create_ip_tracking_table extends Migration
{
    /**
     * @inheritdoc
     */
    public function up()
    {
        $this->createTable('ip_tracking', [
            'id' => $this->primaryKey(),
            'ip' => $this->string()->notNull(),
            'page' => $this->string()->notNull(),
            'accessed_at' => $this->timestamp()->defaultExpression('CURRENT_TIMESTAMP')
        ]);
        $this->createIndex('ip_tracking_idx', 'ip_tracking', ['ip', 'page']);
    }

    /**
     * @inheritdoc
     */
    public function down()
    {
        $this->dropTable('ip_tracking');
    }
}
